/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.ui.Gray;
import com.intellij.ui.jcef.JBCefCaretListener;
import com.intellij.ui.jcef.JBCefFpsMeter;
import com.intellij.util.Function;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefDragData;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefScreenInfo;
import org.cef.misc.CefRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JBCefOsrHandler
implements CefRenderHandler {
    @NotNull
    private final JBCefFpsMeter myFpsMeter;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final Function<? super JComponent, ? extends Rectangle> myScreenBoundsProvider;
    @Nullable
    protected volatile JBHiDPIScaledImage myImage;
    @Nullable
    protected volatile JBHiDPIScaledImage myPopupImage;
    private volatile boolean myPopupShown;
    @NotNull
    private volatile Rectangle myPopupBounds;
    protected final Object myPopupMutex;
    @Nullable
    private volatile VolatileImage myVolatileImage;
    protected volatile boolean myContentOutdated;
    @Nullable
    private volatile JBCefCaretListener myCaretListener;
    private volatile double myPixelDensity;
    private volatile double myScaleFactor;
    @NotNull
    private final AtomicReference<Point> myLocationOnScreenRef;
    @Nullable
    private Timer myResizePusherAlarm;
    @Nullable
    private Instant resizePushStarted;
    private final Duration RESIZE_PUSHER_TIMEOUT;

    JBCefOsrHandler(@NotNull JComponent component, @NotNull Function<? super JComponent, ? extends Rectangle> screenBoundsProvider) {
        if (component == null) {
            JBCefOsrHandler.$$$reportNull$$$0(0);
        }
        if (screenBoundsProvider == null) {
            JBCefOsrHandler.$$$reportNull$$$0(1);
        }
        this.myFpsMeter = JBCefFpsMeter.register(RegistryManager.getInstance().get("ide.browser.jcef.osr.measureFPS.id").asString());
        this.myPopupShown = false;
        this.myPopupBounds = new Rectangle();
        this.myPopupMutex = new Object();
        this.myContentOutdated = false;
        this.myPixelDensity = 1.0;
        this.myScaleFactor = 1.0;
        this.myLocationOnScreenRef = new AtomicReference<Point>(new Point());
        this.myResizePusherAlarm = null;
        this.resizePushStarted = null;
        this.RESIZE_PUSHER_TIMEOUT = Duration.ofSeconds(2L);
        this.myComponent = component;
        this.myScreenBoundsProvider = screenBoundsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPopupShow(CefBrowser browser, boolean show) {
        Object object = this.myPopupMutex;
        synchronized (object) {
            this.myPopupShown = show;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPopupSize(CefBrowser browser, Rectangle size) {
        Object object = this.myPopupMutex;
        synchronized (object) {
            this.myPopupBounds = size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        Rectangle rect = this.getViewRect(browser);
        double w = (double)rect.width * this.getPixelDensity();
        double h = (double)rect.height * this.getPixelDensity();
        if (w != (double)width || h != (double)height) {
            this.startResizePusher(browser, false);
        } else {
            this.stopResizePusher();
        }
        this.myFpsMeter.onPaintStarted();
        JBHiDPIScaledImage image = popup ? this.myPopupImage : this.myImage;
        Dimension size = JBCefOsrHandler.getRealImageSize(image);
        if (size.width != width || size.height != height) {
            image = (JBHiDPIScaledImage)RetinaImage.createFrom((Image)new BufferedImage(width, height, 3), (double)this.getPixelDensity(), null);
        }
        assert (image != null);
        if (popup) {
            Object object = this.myPopupMutex;
            synchronized (object) {
                JBCefOsrHandler.drawByteBuffer(image, buffer, dirtyRects);
                this.myPopupImage = image;
            }
        } else {
            JBCefOsrHandler.drawByteBuffer(image, buffer, dirtyRects);
            this.myImage = image;
        }
        this.myContentOutdated = true;
        SwingUtilities.invokeLater(() -> {
            if (!browser.getUIComponent().isShowing()) {
                return;
            }
            Component component = browser.getUIComponent();
            JRootPane root = SwingUtilities.getRootPane(component);
            RepaintManager rm = RepaintManager.currentManager(root);
            Rectangle dirtySrc = new Rectangle(0, 0, component.getWidth(), component.getHeight());
            Rectangle dirtyDst = SwingUtilities.convertRectangle(component, dirtySrc, root);
            int dx = 1;
            rm.addDirtyRegion(root, dirtyDst.x - dx, dirtyDst.y - dx, dirtyDst.width + dx * 2, dirtyDst.height + dx * 2);
        });
        long pixCount = 0L;
        for (Rectangle r : dirtyRects) {
            pixCount += (long)r.width * (long)r.height;
        }
        this.myFpsMeter.onPaintFinished(pixCount);
    }

    protected Dimension getCurrentFrameSize() {
        JBHiDPIScaledImage image = this.myImage;
        return image == null ? null : new Dimension(image.getWidth(), image.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g) {
        Dimension frameSize = this.getCurrentFrameSize();
        if (frameSize == null) {
            return;
        }
        this.myFpsMeter.paintFrameStarted();
        VolatileImage vi = this.myVolatileImage;
        do {
            boolean contentOutdated = this.myContentOutdated;
            this.myContentOutdated = false;
            if (vi == null || vi.getWidth() != frameSize.width || vi.getHeight() != frameSize.height) {
                vi = this.createVolatileImage(g, frameSize.width, frameSize.height);
            } else if (contentOutdated) {
                this.drawVolatileImage(vi);
            }
            switch (vi.validate(g.getDeviceConfiguration())) {
                case 1: {
                    this.drawVolatileImage(vi);
                    break;
                }
                case 2: {
                    vi = this.createVolatileImage(g, frameSize.width, frameSize.height);
                }
            }
            g.drawImage(vi, 0, 0, null);
        } while (vi.contentsLost());
        this.myVolatileImage = vi;
        if (this.myPopupShown) {
            Object object = this.myPopupMutex;
            synchronized (object) {
                JBHiDPIScaledImage popupImage = this.myPopupImage;
                if (this.myPopupShown && popupImage != null) {
                    UIUtil.drawImage((Graphics)g, (Image)popupImage, (int)this.myPopupBounds.x, (int)this.myPopupBounds.y, null);
                }
            }
        }
        this.myFpsMeter.paintFrameFinished(g);
    }

    public void setScreenInfo(double pixelDensity, double scaleFactor) {
        this.myPixelDensity = pixelDensity;
        this.myScaleFactor = scaleFactor;
    }

    protected double getPixelDensity() {
        return this.myPixelDensity;
    }

    protected double getScaleFactor() {
        return this.myScaleFactor;
    }

    public Rectangle getViewRect(CefBrowser browser) {
        Component component = browser.getUIComponent();
        double scale = this.getScaleFactor();
        double width = (double)component.getWidth() / scale;
        double height = (double)component.getHeight() / scale;
        return new Rectangle(0, 0, (int)Math.ceil(width), (int)Math.ceil(height));
    }

    public boolean getScreenInfo(CefBrowser browser, CefScreenInfo screenInfo) {
        Rectangle rect = (Rectangle)this.myScreenBoundsProvider.fun((Object)this.myComponent);
        double scale = this.myScaleFactor * this.myPixelDensity;
        screenInfo.Set(scale, 32, 4, false, rect, rect);
        return true;
    }

    public Point getScreenPoint(CefBrowser browser, Point viewPoint) {
        Point pt = viewPoint.getLocation();
        Point loc = this.myLocationOnScreenRef.get();
        if (OS.isMacintosh()) {
            Rectangle rect = (Rectangle)this.myScreenBoundsProvider.fun((Object)this.myComponent);
            pt.setLocation(loc.x + pt.x, rect.height - loc.y - pt.y);
        } else {
            pt.translate(loc.x, loc.y);
        }
        return OS.isMacintosh() ? pt : this.toRealCoordinates(pt);
    }

    public double getDeviceScaleFactor(CefBrowser browser) {
        return this.myScaleFactor * this.myPixelDensity;
    }

    public boolean onCursorChange(CefBrowser browser, int cursorType) {
        SwingUtilities.invokeLater(() -> browser.getUIComponent().setCursor(new Cursor(cursorType)));
        return true;
    }

    public boolean startDragging(CefBrowser browser, CefDragData dragData, int mask, int x, int y) {
        return false;
    }

    public void updateDragCursor(CefBrowser browser, int operation) {
    }

    public void OnImeCompositionRangeChanged(CefBrowser browser, CefRange selectionRange, Rectangle[] characterBounds) {
        JBCefCaretListener listener = this.myCaretListener;
        if (listener != null) {
            listener.onImeCompositionRangeChanged(selectionRange, characterBounds);
        }
    }

    public void OnTextSelectionChanged(CefBrowser browser, String selectedText, CefRange selectionRange) {
        JBCefCaretListener listener = this.myCaretListener;
        if (listener != null) {
            listener.onTextSelectionChanged(selectedText, selectionRange);
        }
    }

    public void setLocationOnScreen(Point location) {
        this.myLocationOnScreenRef.set(location);
    }

    @NotNull
    private Point toRealCoordinates(@NotNull Point pt) {
        if (pt == null) {
            JBCefOsrHandler.$$$reportNull$$$0(2);
        }
        double scale = this.getPixelDensity();
        return new Point((int)Math.round((double)pt.x * scale), (int)Math.round((double)pt.y * scale));
    }

    void addCaretListener(JBCefCaretListener listener) {
        this.myCaretListener = listener;
    }

    @NotNull
    private static Dimension getRealImageSize(JBHiDPIScaledImage image) {
        if (image == null) {
            return new Dimension(0, 0);
        }
        BufferedImage bi = (BufferedImage)image.getDelegate();
        assert (bi != null);
        return new Dimension(bi.getWidth(), bi.getHeight());
    }

    private static void drawByteBuffer(@NotNull JBHiDPIScaledImage dst, @NotNull ByteBuffer src, Rectangle[] rectangles) {
        if (dst == null) {
            JBCefOsrHandler.$$$reportNull$$$0(3);
        }
        if (src == null) {
            JBCefOsrHandler.$$$reportNull$$$0(4);
        }
        BufferedImage image = (BufferedImage)dst.getDelegate();
        assert (image != null);
        int[] dstData = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        IntBuffer srcData = src.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        for (Rectangle rect : rectangles) {
            if (rect.width < image.getWidth()) {
                for (int line = rect.y; line < rect.y + rect.height; ++line) {
                    int offset = line * image.getWidth() + rect.x;
                    srcData.position(offset).get(dstData, offset, Math.min(rect.width, src.capacity() - offset));
                }
                continue;
            }
            int offset = rect.y * image.getWidth();
            srcData.position(offset).get(dstData, offset, Math.min(rect.height * image.getWidth(), src.capacity() - offset));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawVolatileImage(VolatileImage vi) {
        JBHiDPIScaledImage image = this.myImage;
        Graphics2D g = (Graphics2D)vi.getGraphics().create();
        try {
            g.setBackground(Gray.TRANSPARENT);
            g.setComposite(AlphaComposite.Src);
            g.clearRect(0, 0, vi.getWidth(), vi.getHeight());
            if (image != null) {
                UIUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
            }
        }
        finally {
            g.dispose();
        }
    }

    private VolatileImage createVolatileImage(Graphics2D g, int width, int height) {
        VolatileImage image = g.getDeviceConfiguration().createCompatibleVolatileImage(width, height, 3);
        Graphics2D gimg = (Graphics2D)image.getGraphics().create();
        gimg.setBackground(Gray.TRANSPARENT);
        gimg.setComposite(AlphaComposite.Src);
        gimg.clearRect(0, 0, image.getWidth(), image.getHeight());
        gimg.dispose();
        this.drawVolatileImage(image);
        return image;
    }

    Color getColorAt(int x, int y) {
        JBHiDPIScaledImage image = this.myImage;
        if (image == null) {
            return null;
        }
        BufferedImage bi = (BufferedImage)image.getDelegate();
        if (bi == null) {
            return null;
        }
        if (x >= bi.getWidth() || y >= bi.getHeight() || x < 0 || y < 0) {
            return null;
        }
        return new Color(bi.getRGB(x, y), true);
    }

    void startResizePusher(CefBrowser browser, boolean resetTimeout) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myComponent.isShowing()) {
                this.startResizePusherImpl(browser, resetTimeout);
            }
        });
    }

    private void startResizePusherImpl(final CefBrowser browser, boolean resetTimeout) {
        if (this.myResizePusherAlarm != null) {
            if (resetTimeout) {
                this.resizePushStarted = Instant.now();
            }
            return;
        }
        this.myResizePusherAlarm = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JBCefOsrHandler.this.resizePushStarted == null || JBCefOsrHandler.this.resizePushStarted.plus(JBCefOsrHandler.this.RESIZE_PUSHER_TIMEOUT).isBefore(Instant.now())) {
                    JBCefOsrHandler.this.stopResizePusher();
                    return;
                }
                browser.invalidate();
            }
        });
        this.myResizePusherAlarm.setRepeats(true);
        this.myResizePusherAlarm.start();
        this.resizePushStarted = Instant.now();
    }

    void stopResizePusher() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myResizePusherAlarm == null) {
                return;
            }
            this.myResizePusherAlarm.stop();
            this.myResizePusherAlarm = null;
            this.resizePushStarted = null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenBoundsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pt";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/jcef/JBCefOsrHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "toRealCoordinates";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "drawByteBuffer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

