/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.execution.Platform;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u0005H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/ui/jcef/JBCefAppCache;", "", "<init>", "()V", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "path$delegate", "Lkotlin/Lazy;", "markInvalidated", "", "prepareCachePath", "intellij.platform.ui.jcef"})
@SourceDebugExtension(value={"SMAP\nJBCefAppCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBCefAppCache.kt\ncom/intellij/ui/jcef/JBCefAppCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,62:1\n23#2:63\n*S KotlinDebug\n*F\n+ 1 JBCefAppCache.kt\ncom/intellij/ui/jcef/JBCefAppCache\n*L\n37#1:63\n*E\n"})
public final class JBCefAppCache {
    @NotNull
    private final Lazy path$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, () -> JBCefAppCache.path_delegate$lambda$0(this));

    @NotNull
    public final Path getPath() {
        Lazy lazy = this.path$delegate;
        return (Path)lazy.getValue();
    }

    public final void markInvalidated() {
        FileUtil.createIfDoesntExist((File)this.getPath().resolve("invalidation.marker").toFile());
    }

    private final Path prepareCachePath() {
        char fileSeparator = Platform.current().fileSeparator;
        String defaultCachePath = PathManager.getSystemPath() + fileSeparator + "jcef_cache" + fileSeparator;
        Path path = Paths.get(System.getProperty("ide.browser.jcef.cache.path", defaultCachePath), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path suggestedPath = path;
        Path invalidationMarkerFilePath = suggestedPath.resolve("invalidation.marker");
        JBCefAppCache $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JBCefAppCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        if (FileUtil.exists((String)((Object)invalidationMarkerFilePath).toString())) {
            try {
                FileUtil.delete((Path)suggestedPath);
                logger2.info("Successfully deleted JCEF browser engine cache at \"" + suggestedPath + "\"");
            }
            catch (IOException exception) {
                Object[] objectArray = new Object[]{exception.getMessage()};
                Notifications.Bus.notify((Notification)new Notification("IDE Caches", IdeBundle.message((String)"jcef.local.cache.invalidate.failed.title", (Object[])new Object[0]), IdeBundle.message((String)"jcef.local.cache.invalidate.failed.message", (Object[])objectArray), NotificationType.ERROR));
                logger2.error("Failed to cleanup JCEF browser engine cache due to I/O error", (Throwable)exception);
            }
        }
        logger2.debug("JCEF cache path: \"" + suggestedPath + "\"");
        return suggestedPath;
    }

    private static final Path path_delegate$lambda$0(JBCefAppCache this$0) {
        return this$0.prepareCachePath();
    }
}

