/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageNodePresentation;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

final class UsageViewTreeCellRenderer
extends ColoredTreeCellRenderer {
    private static final Logger LOG = Logger.getInstance(UsageViewTreeCellRenderer.class);
    private static final Insets STANDARD_IPAD_NOWIFI = JBUI.insets((int)1, (int)2);
    private final UsageViewPresentation myPresentation;
    private final UsageViewImpl myView;
    private Dimension cachedPreferredSize;

    UsageViewTreeCellRenderer(@NotNull UsageViewImpl view) {
        if (view == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(0);
        }
        this.myView = view;
        this.myPresentation = view.getPresentation();
        this.setIpad(STANDARD_IPAD_NOWIFI);
    }

    @DirtyUI
    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(1);
        }
        if (this.myView.isDisposed()) {
            return;
        }
        boolean showAsReadOnly = false;
        if (value instanceof Node) {
            Node node = (Node)value;
            if (value != tree.getModel().getRoot()) {
                if (!node.isValid()) {
                    this.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", UsageTreeColors.INVALID_ATTRIBUTES);
                    return;
                }
                if (this.myPresentation.isShowReadOnlyStatusAsRed() && node.isReadOnly()) {
                    showAsReadOnly = true;
                }
            }
        }
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof UsageTarget) {
                String text;
                UsageTarget usageTarget = (UsageTarget)userObject;
                LOG.assertTrue(treeNode instanceof Node);
                if (!((Node)treeNode).isValid()) {
                    if (!this.getCharSequence(false).toString().contains(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]))) {
                        this.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]), UsageTreeColors.INVALID_ATTRIBUTES);
                    }
                    return;
                }
                ItemPresentation presentation = usageTarget.getPresentation();
                LOG.assertTrue(presentation != null);
                if (showAsReadOnly) {
                    this.append(UsageViewBundle.message((String)"node.readonly", (Object[])new Object[0]) + " ", UsageTreeColors.INVALID_ATTRIBUTES);
                }
                this.append((text = presentation.getPresentableText()) == null ? "" : text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String locationString = presentation.getLocationString();
                this.append((String)(locationString == null ? "" : " " + locationString), SimpleTextAttributes.GRAY_ATTRIBUTES);
                this.setIcon(presentation.getIcon(expanded));
            } else if (treeNode instanceof GroupNode) {
                GroupNode node = (GroupNode)treeNode;
                if (node.isRoot()) {
                    this.append("<root>", UsageViewTreeCellRenderer.patchAttrs(node, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
                } else {
                    this.renderNode(node);
                }
                int count = node.getRecursiveUsageCount();
                SimpleTextAttributes attributes = UsageViewTreeCellRenderer.patchAttrs(node, UsageTreeColors.NUMBER_OF_USAGES_ATTRIBUTES);
                this.append(FontUtil.spaceAndThinSpace() + UsageViewBundle.message((String)"usage.view.counter", (Object[])new Object[]{count}), SimpleTextAttributes.GRAYED_ATTRIBUTES.derive(attributes.getStyle(), null, null, null));
                if (!node.isRoot() && ((DefaultMutableTreeNode)node.getParent()).isRoot() && DumbService.isDumb((Project)this.myView.getProject())) {
                    this.append(FontUtil.spaceAndThinSpace() + IdeBundle.message((String)"dumb.mode.analyzing.project", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            } else if (treeNode instanceof UsageNode) {
                UsageNode node = (UsageNode)treeNode;
                if (!node.isValid()) {
                    this.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]), UsageTreeColors.INVALID_ATTRIBUTES);
                    return;
                }
                if (showAsReadOnly) {
                    this.append(UsageViewBundle.message((String)"node.readonly", (Object[])new Object[0]) + " ", UsageViewTreeCellRenderer.patchAttrs(node, UsageTreeColors.READ_ONLY_ATTRIBUTES));
                }
                this.renderNode(node);
            } else if (userObject instanceof String) {
                this.append((String)userObject, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else {
                this.append(userObject == null ? "" : userObject.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        } else {
            this.append(value.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree, (SimpleColoredComponent)this, (boolean)true, (boolean)this.mySelected);
    }

    private void renderNode(Node node) {
        UsageNodePresentation presentation = node.getCachedPresentation();
        if (presentation == null) {
            this.append(UsageViewBundle.message((String)"loading", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES, true);
            node.forceUpdate();
            this.myView.updateLater();
            return;
        }
        this.setIcon(presentation.getIcon());
        TextChunk[] text = presentation.getText();
        for (int i = 0; i < text.length; ++i) {
            TextChunk textChunk = text[i];
            SimpleTextAttributes simples = textChunk.getSimpleAttributesIgnoreBackground();
            this.append(textChunk.getText() + (i == 0 ? " " : ""), UsageViewTreeCellRenderer.patchAttrs(node, simples), true);
        }
    }

    @NotNull
    String getPlainTextForNode(Object value) {
        boolean showAsReadOnly = false;
        StringBuilder result = new StringBuilder();
        if (value instanceof Node) {
            Node node = (Node)value;
            if (!node.isValid()) {
                result.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0])).append(" ");
            }
            if (this.myPresentation.isShowReadOnlyStatusAsRed() && node.isReadOnly()) {
                showAsReadOnly = true;
            }
        }
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof UsageTarget) {
                UsageTarget usageTarget = (UsageTarget)userObject;
                if (usageTarget.isValid()) {
                    String text;
                    ItemPresentation presentation = usageTarget.getPresentation();
                    LOG.assertTrue(presentation != null);
                    if (showAsReadOnly) {
                        result.append(UsageViewBundle.message((String)"node.readonly", (Object[])new Object[0])).append(" ");
                    }
                    result.append((text = presentation.getPresentableText()) == null ? "" : text);
                } else {
                    result.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]));
                }
            } else if (treeNode instanceof GroupNode) {
                GroupNode node = (GroupNode)treeNode;
                if (node.isRoot()) {
                    result.append("<root>");
                } else {
                    result.append(node.getGroup().getPresentableGroupText());
                }
                result.append(" (").append(node.getRecursiveUsageCount()).append(")");
            } else if (treeNode instanceof UsageNode) {
                UsageNode node = (UsageNode)treeNode;
                if (showAsReadOnly) {
                    result.append(UsageViewBundle.message((String)"node.readonly", (Object[])new Object[0])).append(" ");
                }
                if (node.isValid()) {
                    TextChunk[] text;
                    for (TextChunk textChunk : text = node.getUsage().getPresentation().getText()) {
                        result.append(textChunk.getText());
                    }
                }
            } else if (userObject instanceof String) {
                result.append((String)userObject);
            } else {
                result.append(userObject == null ? "" : userObject.toString());
            }
        } else {
            result.append(value);
        }
        String string = result.toString();
        if (string == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    RowLocation isRowVisible(int row, @NotNull Rectangle visibleRect) {
        Dimension pref;
        if (visibleRect == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(3);
        }
        if (this.cachedPreferredSize == null) {
            this.cachedPreferredSize = pref = this.getPreferredSize();
        } else {
            pref = this.cachedPreferredSize;
        }
        pref.width = Math.max(visibleRect.width, pref.width);
        JTree tree = this.getTree();
        Rectangle bounds = tree == null ? null : tree.getRowBounds(row);
        int y = bounds == null ? 0 : bounds.y;
        TextRange vis = TextRange.from((int)Math.max(0, visibleRect.y - pref.height), (int)(visibleRect.height + pref.height * 2));
        boolean inside = vis.contains(y);
        if (inside) {
            RowLocation rowLocation = RowLocation.INSIDE_VISIBLE_RECT;
            if (rowLocation == null) {
                UsageViewTreeCellRenderer.$$$reportNull$$$0(4);
            }
            return rowLocation;
        }
        RowLocation rowLocation = y < vis.getStartOffset() ? RowLocation.BEFORE_VISIBLE_RECT : RowLocation.AFTER_VISIBLE_RECT;
        if (rowLocation == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(5);
        }
        return rowLocation;
    }

    private static SimpleTextAttributes patchAttrs(@NotNull Node node, @NotNull SimpleTextAttributes original) {
        DefaultMutableTreeNode parent;
        if (node == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(6);
        }
        if (original == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(7);
        }
        if (node.isExcluded()) {
            original = new SimpleTextAttributes(original.getStyle() | 4, original.getFgColor(), original.getWaveColor());
        }
        if (node instanceof GroupNode && (parent = (DefaultMutableTreeNode)node.getParent()) != null && parent.isRoot()) {
            original = new SimpleTextAttributes(original.getStyle() | 1, original.getFgColor(), original.getWaveColor());
        }
        return original;
    }

    @NlsContexts.Tooltip
    static String getTooltipFromPresentation(Object value) {
        DefaultMutableTreeNode treeNode;
        if (value instanceof DefaultMutableTreeNode && (treeNode = (DefaultMutableTreeNode)value) instanceof UsageNode) {
            UsageNode node = (UsageNode)treeNode;
            return node.getUsage().getPresentation().getTooltipText();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/UsageViewTreeCellRenderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/UsageViewTreeCellRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainTextForNode";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "isRowVisible";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRowVisible";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "patchAttrs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }

    static enum RowLocation {
        BEFORE_VISIBLE_RECT,
        INSIDE_VISIBLE_RECT,
        AFTER_VISIBLE_RECT;

    }
}

