/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages.similarity;

import com.intellij.find.findUsages.similarity.ExportClusteringResultActionLink;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.ActionLink;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.similarity.clustering.ClusteringSearchSession;
import com.intellij.usages.similarity.clustering.UsageCluster;
import com.intellij.usages.similarity.usageAdapter.SimilarUsage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;

class ImportClusteringResultActionLink
extends ActionLink {
    private static final Logger LOG = Logger.getLogger(ImportClusteringResultActionLink.class.getName());

    ImportClusteringResultActionLink(@NotNull Project project, @NotNull ClusteringSearchSession session, @NotNull AnAction refreshAction) {
        if (project == null) {
            ImportClusteringResultActionLink.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ImportClusteringResultActionLink.$$$reportNull$$$0(1);
        }
        if (refreshAction == null) {
            ImportClusteringResultActionLink.$$$reportNull$$$0(2);
        }
        super(UsageViewBundle.message((String)"similar.usages.internal.import.clustering.data", (Object[])new Object[0]), event -> {
            FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
            fileChooserDescriptor.setTitle(UsageViewBundle.message((String)"similar.usages.internal.import.clustering.data.title", (Object[])new Object[0]));
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Project)project, null);
            if (file == null) {
                return;
            }
            try {
                Map<String, SimilarUsage> usageIndex = ImportClusteringResultActionLink.buildIndex(session);
                session.updateClusters(ImportClusteringResultActionLink.parseFile(file, usageIndex));
                refreshAction.actionPerformed(ActionUtil.createEmptyEvent());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        });
    }

    private static Map<String, SimilarUsage> buildIndex(@NotNull ClusteringSearchSession session) {
        if (session == null) {
            ImportClusteringResultActionLink.$$$reportNull$$$0(3);
        }
        List usages = session.getClusters().stream().flatMap(e -> e.getUsages().stream()).toList();
        return usages.stream().collect(Collectors.toMap(e -> ExportClusteringResultActionLink.getUsageId(Objects.requireNonNull(((UsageInfo2UsageAdapter)e).getElement())), value -> value, (usageId1, usageId2) -> {
            LOG.warning("Duplicate found:" + String.valueOf(usageId1));
            return usageId1;
        }));
    }

    @NotNull
    private static Collection<UsageCluster> parseFile(@NotNull VirtualFile file, @NotNull Map<String, SimilarUsage> usageIndex) throws IOException {
        if (file == null) {
            ImportClusteringResultActionLink.$$$reportNull$$$0(4);
        }
        if (usageIndex == null) {
            ImportClusteringResultActionLink.$$$reportNull$$$0(5);
        }
        JsonReaderEx json = new JsonReaderEx((CharSequence)VfsUtilCore.loadText((VirtualFile)file));
        List list = JsonUtil.nextList((JsonReaderEx)json);
        Int2ObjectOpenHashMap clusters = new Int2ObjectOpenHashMap();
        list.forEach(arg_0 -> ImportClusteringResultActionLink.lambda$parseFile$5((Int2ObjectMap)clusters, usageIndex, arg_0));
        ObjectCollection objectCollection = clusters.values();
        if (objectCollection == null) {
            ImportClusteringResultActionLink.$$$reportNull$$$0(6);
        }
        return objectCollection;
    }

    private static /* synthetic */ void lambda$parseFile$5(Int2ObjectMap clusters, Map usageIndex, Map e) {
        Object filename;
        int cluster_number = (int)((Double)e.get("cluster_number")).doubleValue();
        UsageCluster cluster = (UsageCluster)clusters.get(cluster_number);
        if (cluster == null) {
            cluster = new UsageCluster();
            clusters.put(cluster_number, (Object)cluster);
        }
        if ((filename = e.get("filename")) != null) {
            SimilarUsage usage = (SimilarUsage)usageIndex.get(filename);
            if (usage == null) {
                LOG.warning("No usage found for " + String.valueOf(filename));
            } else {
                cluster.addUsage(usage);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageIndex";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/similarity/ImportClusteringResultActionLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/similarity/ImportClusteringResultActionLink";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildIndex";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

