/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.project.Project;
import com.intellij.usages.impl.rules.ImportUsageFilteringRule;
import com.intellij.usages.impl.rules.ReadAccessFilteringRule;
import com.intellij.usages.impl.rules.UsageInGeneratedCodeFilteringRule;
import com.intellij.usages.impl.rules.WriteAccessFilteringRule;
import com.intellij.usages.rules.GeneratedSourceUsageFilter;
import com.intellij.usages.rules.ImportFilteringRule;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\b\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"usageFilteringRules", "", "Lcom/intellij/usages/rules/UsageFilteringRule;", "project", "Lcom/intellij/openapi/project/Project;", "platformUsageFilteringRules", "areGeneratedSourceUsageFiltersAvailable", "", "fromExtensions", "", "result", "", "intellij.platform.usageView.impl"})
@JvmName(name="UsageFilteringRules")
@SourceDebugExtension(value={"SMAP\nusageFilteringRules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 usageFilteringRules.kt\ncom/intellij/usages/impl/rules/UsageFilteringRules\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1761#2,3:43\n*S KotlinDebug\n*F\n+ 1 usageFilteringRules.kt\ncom/intellij/usages/impl/rules/UsageFilteringRules\n*L\n34#1:43,3\n*E\n"})
public final class UsageFilteringRules {
    @NotNull
    public static final List<UsageFilteringRule> usageFilteringRules(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList result = new ArrayList(UsageFilteringRules.platformUsageFilteringRules(project));
        UsageFilteringRules.fromExtensions(project, result);
        List<UsageFilteringRule> list = List.copyOf(result);
        Intrinsics.checkNotNullExpressionValue(list, (String)"copyOf(...)");
        return list;
    }

    @ApiStatus.Internal
    @NotNull
    public static final List<UsageFilteringRule> platformUsageFilteringRules(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(ReadAccessFilteringRule.INSTANCE);
        result.add(WriteAccessFilteringRule.INSTANCE);
        if (UsageFilteringRules.areGeneratedSourceUsageFiltersAvailable()) {
            result.add(new UsageInGeneratedCodeFilteringRule(project));
        }
        if (ImportFilteringRule.EP_NAME.hasAnyExtensions()) {
            result.add(ImportUsageFilteringRule.INSTANCE);
        }
        return result;
    }

    private static final boolean areGeneratedSourceUsageFiltersAvailable() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = GeneratedSourceUsageFilter.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GeneratedSourceUsageFilter p0 = (GeneratedSourceUsageFilter)element$iv;
                    boolean bl2 = false;
                    if (!p0.isAvailable()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void fromExtensions(Project project, List<UsageFilteringRule> result) {
        for (UsageFilteringRuleProvider provider : UsageFilteringRuleProvider.EP_NAME.getExtensionList()) {
            Collection collection = provider.getApplicableRules(project);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getApplicableRules(...)");
            result.addAll(collection);
        }
    }
}

