/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.similarity.internal;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.similarity.bag.Bag;
import com.intellij.usages.similarity.features.UsageSimilarityFeaturesProvider;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ShowUsageFeaturesInternalAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            ShowUsageFeaturesInternalAction.$$$reportNull$$$0(0);
        }
        if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) == null) {
            return;
        }
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file == null) {
            return;
        }
        Project project = e.getProject();
        assert (project != null);
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        assert (projectDir != null);
        PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(projectDir);
        assert (directory != null);
        Ref featuresDump = new Ref();
        ShowUsageFeaturesInternalAction.calculateFeaturesForUsage(editor, file, project, (Ref<? super PsiFile>)featuresDump);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowUsageFeaturesInternalAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    private static void calculateFeaturesForUsage(final @NotNull Editor editor, final @NotNull PsiFile file, final @NotNull Project project, final @NotNull Ref<? super PsiFile> featuresDump) {
        if (editor == null) {
            ShowUsageFeaturesInternalAction.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ShowUsageFeaturesInternalAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            ShowUsageFeaturesInternalAction.$$$reportNull$$$0(4);
        }
        if (featuresDump == null) {
            ShowUsageFeaturesInternalAction.$$$reportNull$$$0(5);
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project, UsageViewBundle.message("similar.usages.show.usage.features.action.calculating.usage.features.progress.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Bag features = new Bag();
                Ref element = new Ref();
                ApplicationManager.getApplication().runReadAction(() -> {
                    PsiReference referenceAt = file.findReferenceAt(editor.getCaretModel().getOffset());
                    if (referenceAt == null) {
                        return;
                    }
                    element.set((Object)referenceAt.getElement());
                    if (!element.isNull()) {
                        UsageSimilarityFeaturesProvider.EP_NAME.forEachExtensionSafe(provider -> features.addAll(provider.getFeatures((PsiElement)element.get())));
                    }
                });
                if (element.isNull()) {
                    return;
                }
                WriteCommandAction.writeCommandAction((Project)project).compute(() -> {
                    ScratchFileService fileService = ScratchFileService.getInstance();
                    try {
                        Document document;
                        VirtualFile scratchFile = fileService.findFile(RootType.findById((String)"scratches"), ShowUsageFeaturesInternalAction.getFeaturesFileName(file, (PsiElement)element.get(), editor), ScratchFileService.Option.create_new_always);
                        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(scratchFile);
                        featuresDump.set((Object)psiFile);
                        Document document2 = document = psiFile != null ? PsiDocumentManager.getInstance((Project)project).getDocument(psiFile) : null;
                        if (document != null) {
                            document.insertString(document.getTextLength(), (CharSequence)StringUtil.join((Iterable)features.getBag().object2IntEntrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList()), (String)",\n"));
                            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                            psiFile.navigate(true);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return true;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/usages/similarity/internal/ShowUsageFeaturesInternalAction$1", "run"));
            }
        });
    }

    @NotNull
    private static String getFeaturesFileName(@NotNull PsiFile file, @NotNull PsiElement element, @NotNull Editor editor) {
        if (file == null) {
            ShowUsageFeaturesInternalAction.$$$reportNull$$$0(6);
        }
        if (element == null) {
            ShowUsageFeaturesInternalAction.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            ShowUsageFeaturesInternalAction.$$$reportNull$$$0(8);
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        String fileName = file.getName();
        String string = "features" + fileName.substring(0, fileName.lastIndexOf(46)) + String.valueOf(document != null ? Integer.valueOf(document.getLineNumber(editor.getCaretModel().getOffset())) : "") + "-" + element.getText() + "-.txt";
        if (string == null) {
            ShowUsageFeaturesInternalAction.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/similarity/internal/ShowUsageFeaturesInternalAction";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featuresDump";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/similarity/internal/ShowUsageFeaturesInternalAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeaturesFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateFeaturesForUsage";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFeaturesFileName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 9 -> new IllegalStateException(string);
        };
    }
}

