/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.usageView.UsageViewBundle;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageViewPresentation {
    private static final Logger LOG = Logger.getInstance(UsageViewPresentation.class);
    @NlsContexts.TabTitle
    private String myTabText;
    @NlsSafe
    private String myScopeText = "";
    @NlsSafe
    private String myUsagesString;
    @NlsSafe
    private String mySearchString;
    private @NlsContexts.ListItem String myTargetsNodeText = UsageViewBundle.message("node.targets", new Object[0]);
    private @NlsContexts.ListItem String myNonCodeUsagesString = UsageViewBundle.message("node.non.code.usages", new Object[0]);
    private @NlsContexts.ListItem String myCodeUsagesString = UsageViewBundle.message("node.found.usages", new Object[0]);
    private boolean myShowReadOnlyStatusAsRed;
    private boolean myShowCancelButton;
    private boolean myOpenInNewTab = true;
    private int myRerunHash;
    private boolean myCodeUsages = true;
    private boolean myUsageTypeFilteringAvailable;
    @NlsContexts.TabTitle
    private String myTabName;
    @NlsContexts.TabTitle
    private String myToolwindowTitle;
    private boolean myDetachedMode;
    private @NlsContexts.ListItem String myDynamicCodeUsagesString;
    private boolean myMergeDupLinesAvailable = true;
    private boolean myExcludeAvailable = true;
    private boolean myNonCodeUsageAvailable = true;
    private Pattern mySearchPattern;
    private boolean myCaseSensitive;
    private boolean myPreserveCase;
    private String myReplaceString;
    private boolean myReplaceMode;

    @NlsContexts.TabTitle
    public String getTabText() {
        return this.myTabText;
    }

    public void setTabText(@NlsContexts.TabTitle String tabText) {
        this.myTabText = tabText;
    }

    @NotNull
    @NlsSafe
    public String getScopeText() {
        String string = this.myScopeText;
        if (string == null) {
            UsageViewPresentation.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setScopeText(@NotNull @NlsSafe String scopeText) {
        if (scopeText == null) {
            UsageViewPresentation.$$$reportNull$$$0(1);
        }
        this.myScopeText = scopeText;
    }

    public boolean isShowReadOnlyStatusAsRed() {
        return this.myShowReadOnlyStatusAsRed;
    }

    public void setShowReadOnlyStatusAsRed(boolean showReadOnlyStatusAsRed) {
        this.myShowReadOnlyStatusAsRed = showReadOnlyStatusAsRed;
    }

    @Deprecated
    public void setUsagesString(@Nls String usagesString) {
        this.myUsagesString = usagesString;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getSearchString() {
        String searchString = this.mySearchString;
        if (searchString != null) {
            String string = searchString;
            if (string == null) {
                UsageViewPresentation.$$$reportNull$$$0(2);
            }
            return string;
        }
        String usagesString = this.myUsagesString;
        if (usagesString != null) {
            String string = StringUtil.capitalize((String)this.myUsagesString);
            if (string == null) {
                UsageViewPresentation.$$$reportNull$$$0(3);
            }
            return string;
        }
        LOG.error("search string must be set");
        return "";
    }

    public void setSearchString(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String searchString) {
        if (searchString == null) {
            UsageViewPresentation.$$$reportNull$$$0(4);
        }
        this.mySearchString = searchString;
    }

    @NlsContexts.ListItem
    @Nullable(value="null means the targets node must not be visible")
    public @NlsContexts.ListItem @Nullable(value="null means the targets node must not be visible") String getTargetsNodeText() {
        return this.myTargetsNodeText;
    }

    public void setTargetsNodeText(@NlsContexts.ListItem String targetsNodeText) {
        this.myTargetsNodeText = targetsNodeText;
    }

    public boolean isShowCancelButton() {
        return this.myShowCancelButton;
    }

    public void setShowCancelButton(boolean showCancelButton) {
        this.myShowCancelButton = showCancelButton;
    }

    @NlsContexts.ListItem
    @NotNull
    public String getNonCodeUsagesString() {
        String string = this.myNonCodeUsagesString;
        if (string == null) {
            UsageViewPresentation.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setNonCodeUsagesString(@NlsContexts.ListItem @NotNull String nonCodeUsagesString) {
        if (nonCodeUsagesString == null) {
            UsageViewPresentation.$$$reportNull$$$0(6);
        }
        this.myNonCodeUsagesString = nonCodeUsagesString;
    }

    @NlsContexts.ListItem
    @NotNull
    public String getCodeUsagesString() {
        String string = this.myCodeUsagesString;
        if (string == null) {
            UsageViewPresentation.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void setCodeUsagesString(@NlsContexts.ListItem @NotNull String codeUsagesString) {
        if (codeUsagesString == null) {
            UsageViewPresentation.$$$reportNull$$$0(8);
        }
        this.myCodeUsagesString = codeUsagesString;
    }

    public boolean isOpenInNewTab() {
        return this.myOpenInNewTab;
    }

    public void setOpenInNewTab(boolean openInNewTab) {
        this.myOpenInNewTab = openInNewTab;
    }

    public int getRerunHash() {
        return this.myRerunHash;
    }

    public void setRerunHash(int rerunHash) {
        this.myRerunHash = rerunHash;
    }

    public boolean isCodeUsages() {
        return this.myCodeUsages;
    }

    public void setCodeUsages(boolean codeUsages) {
        this.myCodeUsages = codeUsages;
    }

    @NlsContexts.TabTitle
    public String getTabName() {
        return this.myTabName;
    }

    public void setTabName(@NlsContexts.TabTitle String tabName) {
        this.myTabName = tabName;
    }

    @NlsContexts.TabTitle
    public String getToolwindowTitle() {
        return this.myToolwindowTitle;
    }

    public void setToolwindowTitle(@NlsContexts.TabTitle String toolwindowTitle) {
        this.myToolwindowTitle = toolwindowTitle;
    }

    public boolean isDetachedMode() {
        return this.myDetachedMode;
    }

    public void setDetachedMode(boolean detachedMode) {
        this.myDetachedMode = detachedMode;
    }

    public void setDynamicUsagesString(@NlsContexts.ListItem String dynamicCodeUsagesString) {
        this.myDynamicCodeUsagesString = dynamicCodeUsagesString;
    }

    @NlsContexts.ListItem
    public String getDynamicCodeUsagesString() {
        return this.myDynamicCodeUsagesString;
    }

    public boolean isMergeDupLinesAvailable() {
        return this.myMergeDupLinesAvailable;
    }

    public void setMergeDupLinesAvailable(boolean mergeDupLinesAvailable) {
        this.myMergeDupLinesAvailable = mergeDupLinesAvailable;
    }

    public boolean isUsageTypeFilteringAvailable() {
        return this.myCodeUsages || this.myUsageTypeFilteringAvailable;
    }

    public void setUsageTypeFilteringAvailable(boolean usageTypeFilteringAvailable) {
        this.myUsageTypeFilteringAvailable = usageTypeFilteringAvailable;
    }

    public boolean isExcludeAvailable() {
        return this.myExcludeAvailable;
    }

    public void setExcludeAvailable(boolean excludeAvailable) {
        this.myExcludeAvailable = excludeAvailable;
    }

    public boolean isNonCodeUsageAvailable() {
        return this.myNonCodeUsageAvailable;
    }

    public void setNonCodeUsageAvailable(boolean nonCodeUsageAvailable) {
        this.myNonCodeUsageAvailable = nonCodeUsageAvailable;
    }

    public void setSearchPattern(Pattern searchPattern) {
        this.mySearchPattern = searchPattern;
    }

    public Pattern getSearchPattern() {
        return this.mySearchPattern;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public void setPreserveCase(boolean preserveCase) {
        this.myPreserveCase = preserveCase;
    }

    public boolean isPreserveCase() {
        return this.myPreserveCase;
    }

    @Deprecated(forRemoval=true)
    public void setReplacePattern(Pattern replacePattern) {
    }

    public void setReplaceString(String replaceString) {
        this.myReplaceString = replaceString;
    }

    public String getReplaceString() {
        return this.myReplaceString;
    }

    public boolean isReplaceMode() {
        return this.myReplaceMode;
    }

    public void setReplaceMode(boolean replaceMode) {
        this.myReplaceMode = replaceMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageViewPresentation that = (UsageViewPresentation)o;
        return this.myCodeUsages == that.myCodeUsages && this.myDetachedMode == that.myDetachedMode && this.myMergeDupLinesAvailable == that.myMergeDupLinesAvailable && this.myOpenInNewTab == that.myOpenInNewTab && this.myShowCancelButton == that.myShowCancelButton && this.myShowReadOnlyStatusAsRed == that.myShowReadOnlyStatusAsRed && this.myUsageTypeFilteringAvailable == that.myUsageTypeFilteringAvailable && this.myExcludeAvailable == that.myExcludeAvailable && this.myReplaceMode == that.myReplaceMode && Objects.equals(this.myCodeUsagesString, that.myCodeUsagesString) && Objects.equals(this.myDynamicCodeUsagesString, that.myDynamicCodeUsagesString) && Objects.equals(this.myNonCodeUsagesString, that.myNonCodeUsagesString) && Objects.equals(this.myScopeText, that.myScopeText) && Objects.equals(this.myTabName, that.myTabName) && Objects.equals(this.myTabText, that.myTabText) && Objects.equals(this.myTargetsNodeText, that.myTargetsNodeText) && Objects.equals(this.myToolwindowTitle, that.myToolwindowTitle) && Objects.equals(this.myUsagesString, that.myUsagesString) && Objects.equals(this.mySearchString, that.mySearchString) && UsageViewPresentation.arePatternsEqual(this.mySearchPattern, that.mySearchPattern) && Objects.equals(this.myReplaceString, that.myReplaceString);
    }

    public static boolean arePatternsEqual(Pattern p1, Pattern p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        return Objects.equals(p1.pattern(), p2.pattern()) && p1.flags() == p2.flags();
    }

    public static int getHashCode(Pattern pattern) {
        if (pattern == null) {
            return 0;
        }
        String s = pattern.pattern();
        return (s != null ? s.hashCode() : 0) * 31 + pattern.flags();
    }

    public int hashCode() {
        int result = Objects.hash(this.myTabText, this.myScopeText, this.myUsagesString, this.mySearchString, this.myTargetsNodeText, this.myNonCodeUsagesString, this.myCodeUsagesString, this.myShowReadOnlyStatusAsRed, this.myShowCancelButton, this.myOpenInNewTab, this.myCodeUsages, this.myUsageTypeFilteringAvailable, this.myExcludeAvailable, this.myTabName, this.myToolwindowTitle, this.myDetachedMode, this.myDynamicCodeUsagesString, this.myMergeDupLinesAvailable, this.myReplaceMode, this.myReplaceString);
        result = 31 * result + UsageViewPresentation.getHashCode(this.mySearchPattern);
        return result;
    }

    public UsageViewPresentation copy() {
        UsageViewPresentation copyInstance = new UsageViewPresentation();
        copyInstance.myTabText = this.myTabText;
        copyInstance.myScopeText = this.myScopeText;
        copyInstance.myUsagesString = this.myUsagesString;
        copyInstance.mySearchString = this.mySearchString;
        copyInstance.myTargetsNodeText = this.myTargetsNodeText;
        copyInstance.myNonCodeUsagesString = this.myNonCodeUsagesString;
        copyInstance.myCodeUsagesString = this.myCodeUsagesString;
        copyInstance.myShowReadOnlyStatusAsRed = this.myShowReadOnlyStatusAsRed;
        copyInstance.myShowCancelButton = this.myShowCancelButton;
        copyInstance.myOpenInNewTab = this.myOpenInNewTab;
        copyInstance.myCodeUsages = this.myCodeUsages;
        copyInstance.myUsageTypeFilteringAvailable = this.myUsageTypeFilteringAvailable;
        copyInstance.myTabName = this.myTabName;
        copyInstance.myToolwindowTitle = this.myToolwindowTitle;
        copyInstance.myDetachedMode = this.myDetachedMode;
        copyInstance.myDynamicCodeUsagesString = this.myDynamicCodeUsagesString;
        copyInstance.myMergeDupLinesAvailable = this.myMergeDupLinesAvailable;
        copyInstance.myExcludeAvailable = this.myExcludeAvailable;
        copyInstance.mySearchPattern = this.mySearchPattern;
        copyInstance.myReplaceString = this.myReplaceString;
        copyInstance.myReplaceMode = this.myReplaceMode;
        return copyInstance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 6, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/UsageViewPresentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchString";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonCodeUsagesString";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeUsagesString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeText";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/UsageViewPresentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonCodeUsagesString";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeUsagesString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setScopeText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSearchString";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setNonCodeUsagesString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCodeUsagesString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 6, 8 -> new IllegalArgumentException(string);
        };
    }
}

