/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.NavigationItemFileStatus;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usages.NamedPresentably;
import com.intellij.usages.UsageGroup;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiElementUsageGroupBase<T extends PsiElement & NavigationItem>
implements UsageGroup,
NamedPresentably {
    private final SmartPsiElementPointer<T> myElementPointer;
    @NotNull
    @NlsSafe
    private final String myName;
    private final Icon myIcon;

    public PsiElementUsageGroupBase(@NotNull T element, Icon icon, @NotNull @NlsSafe String name) {
        if (element == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        this.myIcon = icon;
    }

    public PsiElementUsageGroupBase(@NotNull T element, Icon icon) {
        if (element == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(2);
        }
        this(element, icon, PsiElementUsageGroupBase.getPresentationName(element));
    }

    public PsiElementUsageGroupBase(@NotNull T element) {
        if (element == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(3);
        }
        this(element, element.getIcon(0));
    }

    public PsiElementUsageGroupBase(@NotNull T element, @NotNull String name) {
        if (element == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(5);
        }
        this(element, element.getIcon(0), name);
    }

    @NotNull
    private static <T extends PsiElement & NavigationItem> String getPresentationName(@NotNull T element) {
        String name;
        if (element == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(6);
        }
        return (name = ((NavigationItem)element).getName()) != null ? name : "<anonymous>";
    }

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    public T getElement() {
        return (T)this.myElementPointer.getElement();
    }

    @Override
    @NotNull
    public String getPresentableGroupText() {
        String string = this.myName;
        if (string == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public FileStatus getFileStatus() {
        return this.isValid() ? NavigationItemFileStatus.get((NavigationItem)((NavigationItem)this.getElement())) : null;
    }

    @Override
    public boolean isValid() {
        T element = this.getElement();
        return element != null && element.isValid();
    }

    public void navigate(boolean focus) throws UnsupportedOperationException {
        if (this.canNavigate()) {
            ((Navigatable)this.getElement()).navigate(focus);
        }
    }

    public boolean canNavigate() {
        return this.isValid();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    public int compareTo(@NotNull UsageGroup o) {
        String string;
        if (o == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(8);
        }
        if (o instanceof NamedPresentably) {
            NamedPresentably presentably = (NamedPresentably)((Object)o);
            string = presentably.getPresentableName();
        } else {
            string = o.getPresentableGroupText();
        }
        String name = string;
        return this.myName.compareToIgnoreCase(name);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PsiElementUsageGroupBase)) {
            return false;
        }
        PsiElementUsageGroupBase group = (PsiElementUsageGroupBase)obj;
        return (Boolean)ReadAction.compute(() -> this.isValid() && group.isValid() && this.getElement().getManager().areElementsEquivalent(this.getElement(), group.getElement()) || this.myName.equals(group.myName));
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myName;
        if (string == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/PsiElementUsageGroupBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/PsiElementUsageGroupBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableGroupText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationName";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9 -> new IllegalStateException(string);
        };
    }
}

