/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.highlighting.ReadWriteUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ReadWriteAccessUsageInfo2UsageAdapter;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.similarity.bag.Bag;
import com.intellij.usages.similarity.clustering.ClusteringSearchSession;
import com.intellij.usages.similarity.features.UsageSimilarityFeaturesProvider;
import com.intellij.usages.similarity.usageAdapter.SimilarReadWriteUsageInfo2UsageAdapter;
import com.intellij.usages.similarity.usageAdapter.SimilarUsage;
import com.intellij.usages.similarity.usageAdapter.SimilarUsageInfo2UsageAdapter;
import com.intellij.util.ArrayFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class UsageInfoToUsageConverter {
    private UsageInfoToUsageConverter() {
    }

    @NotNull
    public static Usage convert(@NotNull TargetElementsDescriptor descriptor, @NotNull UsageInfo usageInfo) {
        if (descriptor == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(0);
        }
        if (usageInfo == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(1);
        }
        PsiElement[] primaryElements = descriptor.getPrimaryElements();
        return UsageInfoToUsageConverter.convert(primaryElements, usageInfo);
    }

    @NotNull
    public static Usage convert(PsiElement @NotNull [] primaryElements, @NotNull UsageInfo usageInfo) {
        ReadWriteAccessDetector.Access rwAccess;
        PsiElement usageElement;
        if (usageInfo == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(2);
        }
        if (primaryElements == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(3);
        }
        if ((usageElement = usageInfo.getElement()) != null && primaryElements.length != 0 && (rwAccess = ReadWriteUtil.getReadWriteAccess((PsiElement[])primaryElements, (PsiElement)usageElement)) != null) {
            return new ReadWriteAccessUsageInfo2UsageAdapter(usageInfo, rwAccess);
        }
        return new UsageInfo2UsageAdapter(usageInfo);
    }

    @NotNull
    public static Usage convertToSimilarUsage(PsiElement @NotNull [] primaryElements, @NotNull UsageInfo usageInfo, @NotNull ClusteringSearchSession session) {
        PsiElement usageElement;
        if (usageInfo == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(4);
        }
        if (session == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(5);
        }
        if (primaryElements == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(6);
        }
        if ((usageElement = usageInfo.getElement()) != null && primaryElements.length != 0) {
            Bag features = new Bag();
            UsageSimilarityFeaturesProvider.EP_NAME.forEachExtensionSafe(provider -> features.addAll(provider.getFeatures(usageElement)));
            if (!features.isEmpty()) {
                ReadWriteAccessDetector.Access readWriteAccess = ReadWriteUtil.getReadWriteAccess((PsiElement[])primaryElements, (PsiElement)usageElement);
                UsageInfo2UsageAdapter similarUsageAdapter = readWriteAccess != null ? new SimilarReadWriteUsageInfo2UsageAdapter(usageInfo, readWriteAccess, features, session) : new SimilarUsageInfo2UsageAdapter(usageInfo, features, session);
                SimilarUsage similarUsage = session.clusterUsage((SimilarUsage)((Object)similarUsageAdapter));
                if (similarUsage == null) {
                    UsageInfoToUsageConverter.$$$reportNull$$$0(7);
                }
                return similarUsage;
            }
        }
        return UsageInfoToUsageConverter.convert(primaryElements, usageInfo);
    }

    public static Usage @NotNull [] convert(@NotNull TargetElementsDescriptor descriptor, UsageInfo @NotNull [] usageInfos) {
        if (descriptor == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(8);
        }
        if (usageInfos == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(9);
        }
        Usage[] usages = new Usage[usageInfos.length];
        for (int i = 0; i < usages.length; ++i) {
            usages[i] = UsageInfoToUsageConverter.convert(descriptor, usageInfos[i]);
        }
        if (usages == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(10);
        }
        return usages;
    }

    public static Usage @NotNull [] convert(PsiElement @NotNull [] primaryElements, UsageInfo @NotNull [] usageInfos) {
        if (primaryElements == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(11);
        }
        if (usageInfos == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(12);
        }
        Usage[] usageArray = (Usage[])ContainerUtil.map((Object[])usageInfos, info -> UsageInfoToUsageConverter.convert(primaryElements, info), (Object[])new Usage[usageInfos.length]);
        if (usageArray == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(13);
        }
        return usageArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryElements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/UsageInfoToUsageConverter";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/UsageInfoToUsageConverter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToSimilarUsage";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertToSimilarUsage";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 13 -> new IllegalStateException(string);
        };
    }

    public static class TargetElementsDescriptor {
        private final List<SmartPsiElementPointer<PsiElement>> myPrimarySearchedElements;
        private final List<SmartPsiElementPointer<PsiElement>> myAdditionalSearchedElements;

        public TargetElementsDescriptor(@NotNull PsiElement element) {
            if (element == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(0);
            }
            this(new PsiElement[]{element});
        }

        public TargetElementsDescriptor(@NotNull @NotNull PsiElement @NotNull [] primarySearchedElements) {
            if (primarySearchedElements == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(1);
            }
            this(primarySearchedElements, PsiElement.EMPTY_ARRAY);
        }

        public TargetElementsDescriptor(@NotNull @NotNull PsiElement @NotNull [] primarySearchedElements, @NotNull @NotNull PsiElement @NotNull [] additionalSearchedElements) {
            if (primarySearchedElements == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(2);
            }
            if (additionalSearchedElements == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(3);
            }
            this.myPrimarySearchedElements = TargetElementsDescriptor.convertToSmartPointers(primarySearchedElements);
            this.myAdditionalSearchedElements = TargetElementsDescriptor.convertToSmartPointers(additionalSearchedElements);
        }

        @NotNull
        private static @NotNull PsiElement @NotNull [] convertToPsiElements(@NotNull List<? extends SmartPsiElementPointer<PsiElement>> primary) {
            if (primary == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(4);
            }
            PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.toArray((Collection)ContainerUtil.mapNotNull(primary, SmartPsiElementPointer::getElement), (ArrayFactory)PsiElement.ARRAY_FACTORY);
            if (psiElementArray == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(5);
            }
            return psiElementArray;
        }

        @NotNull
        private static @NotNull @Unmodifiable List<@NotNull SmartPsiElementPointer<PsiElement>> convertToSmartPointers(@NotNull @NotNull PsiElement @NotNull [] primaryElements) {
            if (primaryElements == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(6);
            }
            if (primaryElements.length == 0) {
                List<SmartPsiElementPointer<PsiElement>> list = Collections.emptyList();
                if (list == null) {
                    TargetElementsDescriptor.$$$reportNull$$$0(7);
                }
                return list;
            }
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)primaryElements[0].getProject());
            List list = ContainerUtil.mapNotNull((Object[])primaryElements, arg_0 -> ((SmartPointerManager)smartPointerManager).createSmartPsiElementPointer(arg_0));
            if (list == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        public @NotNull PsiElement @NotNull [] getPrimaryElements() {
            return TargetElementsDescriptor.convertToPsiElements(this.myPrimarySearchedElements);
        }

        @NotNull
        public @NotNull PsiElement @NotNull [] getAdditionalElements() {
            return TargetElementsDescriptor.convertToPsiElements(this.myAdditionalSearchedElements);
        }

        @NotNull
        public List<PsiElement> getAllElements() {
            PsiElement element;
            ArrayList<PsiElement> result = new ArrayList<PsiElement>(this.myPrimarySearchedElements.size() + this.myAdditionalSearchedElements.size());
            for (SmartPsiElementPointer<PsiElement> pointer : this.myPrimarySearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            for (SmartPsiElementPointer<PsiElement> pointer : this.myAdditionalSearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            ArrayList<PsiElement> arrayList = result;
            if (arrayList == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        @NotNull
        public @Unmodifiable List<SmartPsiElementPointer<PsiElement>> getAllElementPointers() {
            List list = ContainerUtil.concat(this.myPrimarySearchedElements, this.myAdditionalSearchedElements);
            if (list == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(10);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 7, 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primarySearchedElements";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalSearchedElements";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primary";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primaryElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToPsiElements";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToSmartPointers";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllElements";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllElementPointers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToPsiElements";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToSmartPointers";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 7, 8, 9, 10 -> new IllegalStateException(string);
            };
        }
    }
}

