/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.Strings;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ByteArrayCharSequence
implements CharSequenceWithStringHash {
    private final int myStart;
    private final int myEnd;
    private transient int hash;
    private final byte[] myChars;

    public ByteArrayCharSequence(byte @NotNull [] chars) {
        if (chars == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(0);
        }
        this(chars, 0, chars.length);
    }

    public ByteArrayCharSequence(byte @NotNull [] chars, int start, int end) {
        if (chars == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(1);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Strings.stringHashCode((CharSequence)((Object)this), 0, this.length());
        }
        return h;
    }

    public int length() {
        return this.myEnd - this.myStart;
    }

    public char charAt(int index) {
        return (char)(this.myChars[index + this.myStart] & 0xFF);
    }

    @NotNull
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? this : new ByteArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @NotNull
    public String toString() {
        return new String(this.myChars, this.myStart, this.length(), StandardCharsets.ISO_8859_1);
    }

    public void getChars(int start, int end, char[] dest, int pos) {
        for (int idx = start; idx < end; ++idx) {
            dest[idx - start + pos] = (char)(this.myChars[idx + this.myStart] & 0xFF);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/ByteArrayCharSequence", "<init>"));
    }
}

