/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.containers.ConcurrentRefHashMap;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.containers.SoftKeySoftValueHashMap;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.containers.WeakKeySoftValueHashMap;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class CollectionFactory {
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakMap() {
        return new ConcurrentWeakHashMap(16, 0.75f, ConcurrentRefHashMap.DEFAULT_CONCURRENCY_LEVEL, null, null);
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(0);
        }
        return new ConcurrentWeakHashMap(16, 0.75f, ConcurrentRefHashMap.DEFAULT_CONCURRENCY_LEVEL, strategy, null);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentMap<@NotNull String, @NotNull V> createConcurrentWeakCaseInsensitiveMap() {
        return CollectionFactory.createConcurrentWeakMap(HashingStrategy.caseInsensitive());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakValueMap() {
        return new ConcurrentWeakValueHashMap(null);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftValueMap() {
        return new ConcurrentSoftValueHashMap(null);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakValueMap(@NotNull @NotNull BiConsumer<? super @NotNull ConcurrentMap<K, V>, ? super K> evictionListener) {
        if (evictionListener == null) {
            CollectionFactory.$$$reportNull$$$0(1);
        }
        return new ConcurrentWeakValueHashMap(evictionListener);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftValueMap(@NotNull @NotNull BiConsumer<? super @NotNull ConcurrentMap<K, V>, ? super K> evictionListener) {
        if (evictionListener == null) {
            CollectionFactory.$$$reportNull$$$0(2);
        }
        return new ConcurrentSoftValueHashMap(evictionListener);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakIdentityMap() {
        return CollectionFactory.createConcurrentWeakMap(HashingStrategy.identity());
    }

    @Deprecated
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakMap() {
        return new java.util.WeakHashMap();
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(3);
        }
        return new WeakHashMap(initialCapacity, loadFactor, hashingStrategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakKeySoftValueMap() {
        return new WeakKeySoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakKeyWeakValueMap() {
        return new WeakKeyWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftKeySoftValueMap() {
        return new SoftKeySoftValueHashMap();
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueIdentityMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.identity());
    }

    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakIdentityMap(int initialCapacity, float loadFactor) {
        return CollectionFactory.createWeakMap(initialCapacity, loadFactor, HashingStrategy.identity());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueMap() {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(4);
        }
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueIdentityMap() {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.identity());
    }

    @Contract(value="_,_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(5);
        }
        return new ConcurrentWeakHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy, null);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueMap() {
        return CollectionFactory.createConcurrentWeakKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @Contract(value="_,_,_,_-> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(6);
        }
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new Object2ObjectOpenCustomHashMap(expectedSize, loadFactor, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new ObjectOpenCustomHashSet(expectedSize, loadFactor, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(@NotNull List<? extends CharSequence> items) {
        if (items == null) {
            CollectionFactory.$$$reportNull$$$0(7);
        }
        return new ObjectOpenCustomHashSet(items, FastUtilHashingStrategies.getCharSequenceStrategy(true));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize) {
        return new ObjectOpenCustomHashSet(expectedSize, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive) {
        return new ObjectOpenCustomHashSet(FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(int capacity, float loadFactory, boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap(capacity, loadFactory, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet() {
        return new ObjectOpenCustomHashSet(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet(@NotNull Collection<String> items) {
        if (items == null) {
            CollectionFactory.$$$reportNull$$$0(8);
        }
        return new ObjectOpenCustomHashSet(items, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet(int initialSize) {
        return new ObjectOpenCustomHashSet(initialSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap() {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap(int expectedSize) {
        return new Object2ObjectOpenCustomHashMap(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap(@NotNull Map<String, V> source) {
        if (source == null) {
            CollectionFactory.$$$reportNull$$$0(9);
        }
        return new Object2ObjectOpenCustomHashMap(source, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.canonical());
    }

    @ApiStatus.Internal
    @VisibleForTesting
    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftKeySoftValueIdentityMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.identity());
    }

    @NotNull
    public static Set<String> createFilePathSet() {
        return SystemInfoRt.isFileSystemCaseSensitive ? new HashSet() : CollectionFactory.createCaseInsensitiveStringSet();
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize) {
        return CollectionFactory.createFilePathSet(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize, boolean isFileSystemCaseSensitive) {
        return isFileSystemCaseSensitive ? new HashSet<String>(expectedSize) : new ObjectOpenCustomHashSet(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths, boolean isFileSystemCaseSensitive) {
        if (paths == null) {
            CollectionFactory.$$$reportNull$$$0(10);
        }
        return isFileSystemCaseSensitive ? new HashSet<String>(paths) : new ObjectOpenCustomHashSet(paths, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(String @NotNull [] paths, boolean isFileSystemCaseSensitive) {
        if (paths == null) {
            CollectionFactory.$$$reportNull$$$0(11);
        }
        return isFileSystemCaseSensitive ? new HashSet<String>(Arrays.asList(paths)) : new ObjectOpenCustomHashSet((Object[])paths, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths) {
        if (paths == null) {
            CollectionFactory.$$$reportNull$$$0(12);
        }
        return CollectionFactory.createFilePathSet(paths, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap() {
        return SystemInfoRt.isFileSystemCaseSensitive ? new HashMap() : CollectionFactory.createCaseInsensitiveStringMap();
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize) {
        return CollectionFactory.createFilePathMap(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize, boolean isFileSystemCaseSensitive) {
        return isFileSystemCaseSensitive ? new HashMap(expectedSize) : new Object2ObjectOpenCustomHashMap(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathLinkedSet() {
        return SystemInfoRt.isFileSystemCaseSensitive ? new LinkedHashSet<String>() : new ObjectLinkedOpenCustomHashSet(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathLinkedSet(@NotNull Set<String> source) {
        if (source == null) {
            CollectionFactory.$$$reportNull$$$0(13);
        }
        return SystemInfoRt.isFileSystemCaseSensitive ? new LinkedHashSet<String>(source) : new ObjectLinkedOpenCustomHashSet(source, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createFilePathLinkedMap() {
        return SystemInfoRt.isFileSystemCaseSensitive ? new LinkedHashMap() : new Object2ObjectLinkedOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintLinkedMap() {
        return new Object2ObjectLinkedOpenHashMap();
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap() {
        return new Object2ObjectOpenHashMap();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(int expected) {
        return new Object2ObjectOpenHashMap(expected);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            CollectionFactory.$$$reportNull$$$0(14);
        }
        return new Object2ObjectOpenHashMap(map);
    }

    @Contract(value="_,_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(int expected, float loadFactor) {
        return new Object2ObjectOpenHashMap(expected, loadFactor);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintLinkedSet() {
        return new ObjectLinkedOpenHashSet();
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet() {
        return new ObjectOpenHashSet();
    }

    @Contract(value="_-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet(int expected) {
        return new ObjectOpenHashSet(expected);
    }

    @Contract(value="_-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet(@NotNull Collection<? extends K> collection) {
        if (collection == null) {
            CollectionFactory.$$$reportNull$$$0(15);
        }
        return new ObjectOpenHashSet(collection);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftMap() {
        return new SoftHashMap(4);
    }

    @Contract(value="_ -> new", pure=true)
    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(16);
        }
        return new SoftHashMap(strategy);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftMap(@Nullable BiConsumer<? super @NotNull Map<K, V>, ? super V> evictionListener) {
        return CollectionFactory.createSoftMap(HashingStrategy.canonical(), evictionListener);
    }

    @Contract(value="_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftMap(@NotNull HashingStrategy<? super K> hashingStrategy, @Nullable BiConsumer<? super @NotNull Map<K, V>, ? super V> evictionListener) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(17);
        }
        return new SoftHashMap<K, V>(10, hashingStrategy, evictionListener);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftMap() {
        return new ConcurrentSoftHashMap(16, 0.75f, ConcurrentRefHashMap.DEFAULT_CONCURRENCY_LEVEL, null, null);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftMap(@NotNull @NotNull BiConsumer<? super @NotNull ConcurrentMap<K, V>, ? super V> evictionListener) {
        if (evictionListener == null) {
            CollectionFactory.$$$reportNull$$$0(18);
        }
        return new ConcurrentSoftHashMap(16, 0.75f, ConcurrentRefHashMap.DEFAULT_CONCURRENCY_LEVEL, null, evictionListener);
    }

    @Contract(value="_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftMap(@NotNull HashingStrategy<? super K> hashingStrategy, @NotNull @NotNull BiConsumer<? super @NotNull ConcurrentMap<K, V>, ? super V> evictionListener) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(19);
        }
        if (evictionListener == null) {
            CollectionFactory.$$$reportNull$$$0(20);
        }
        return new ConcurrentSoftHashMap<K, V>(16, 0.75f, ConcurrentRefHashMap.DEFAULT_CONCURRENCY_LEVEL, hashingStrategy, evictionListener);
    }

    @Contract(value="_,_,_,_-> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(21);
        }
        return new ConcurrentSoftHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy, null);
    }

    public static void trimMap(@NotNull Map<?, ?> map) {
        if (map == null) {
            CollectionFactory.$$$reportNull$$$0(22);
        }
        if (map instanceof Object2ObjectOpenHashMap) {
            ((Object2ObjectOpenHashMap)map).trim();
        } else if (map instanceof Object2ObjectOpenCustomHashMap) {
            ((Object2ObjectOpenCustomHashMap)map).trim();
        }
    }

    public static void trimSet(@NotNull Set<?> set) {
        if (set == null) {
            CollectionFactory.$$$reportNull$$$0(23);
        }
        if (set instanceof ObjectOpenHashSet) {
            ((ObjectOpenHashSet)set).trim();
        } else if (set instanceof ObjectOpenCustomHashSet) {
            ((ObjectOpenCustomHashSet)set).trim();
        }
    }

    @NotNull
    public static <K, V> Map<K, V> createCustomHashingStrategyMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(24);
        }
        return new Object2ObjectOpenCustomHashMap(CollectionFactory.adaptStrategy(strategy));
    }

    @NotNull
    private static <K> Hash.Strategy<K> adaptStrategy(final @NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(25);
        }
        return new FastUtilHashingStrategies.SerializableHashStrategy<K>(){

            public int hashCode(@Nullable K o) {
                return strategy.hashCode(o);
            }

            public boolean equals(@Nullable K a, @Nullable K b) {
                return strategy.equals(a, b);
            }
        };
    }

    @NotNull
    public static <K, V> Map<K, V> createCustomHashingStrategyMap(int expected, @NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(26);
        }
        return new Object2ObjectOpenCustomHashMap(expected, CollectionFactory.adaptStrategy(strategy));
    }

    @NotNull
    public static <K> Set<K> createCustomHashingStrategySet(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(27);
        }
        return new ObjectOpenCustomHashSet(CollectionFactory.adaptStrategy(strategy));
    }

    @NotNull
    public static <K, V> Map<K, V> createLinkedCustomHashingStrategyMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(28);
        }
        return new Object2ObjectLinkedOpenCustomHashMap(CollectionFactory.adaptStrategy(strategy));
    }

    @NotNull
    public static <K> Set<K> createLinkedCustomHashingStrategySet(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(29);
        }
        return new ObjectLinkedOpenCustomHashSet(CollectionFactory.adaptStrategy(strategy));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: 
            case 2: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evictionListener";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/CollectionFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentWeakMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentWeakValueMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentSoftValueMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createWeakMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createCharSequenceSet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createCaseInsensitiveStringSet";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createCaseInsensitiveStringMap";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createFilePathSet";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createFilePathLinkedSet";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "createSmallMemoryFootprintMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createSmallMemoryFootprintSet";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "createSoftMap";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentSoftMap";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "trimMap";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "trimSet";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomHashingStrategyMap";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "adaptStrategy";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomHashingStrategySet";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "createLinkedCustomHashingStrategyMap";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "createLinkedCustomHashingStrategySet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

