/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.ChunkOptimizer;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeLineFragmentImpl;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.util.fastutil.ints.IntArrayList;
import com.intellij.util.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007JH\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007JH\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J9\u0010\u0011\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u0013JU\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b\u0013JJ\u0010\u0016\u001a\u00020\u00152\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J,\u0010\u001b\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J4\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007H\u0002J4\u0010\"\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010#\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J,\u0010$\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010%\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0007\u0012\u0004\u0012\u00020 0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010(\u001a\u00020\u0018H\u0002J,\u0010)\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010#\u001a\u00020\u0005H\u0002J$\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00072\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0007J$\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00072\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\u0006\u00101\u001a\u00020\u000eH\u0007\u00a8\u00063"}, d2={"Lcom/intellij/diff/comparison/ByLineRt;", "", "<init>", "()V", "compare", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "lines1", "", "", "lines2", "policy", "Lcom/intellij/diff/comparison/ComparisonPolicy;", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "Lcom/intellij/diff/util/MergeRange;", "lines3", "merge", "doCompare", "Lcom/intellij/diff/comparison/ByLineRt$Line;", "doCompare$intellij_platform_util_diff", "keepIgnoredChanges", "", "equalsDefaultPolicy", "index1", "", "index2", "index3", "correctChangesSecondStep", "changes", "getBestMatchingAlignment", "", "subLines1", "Lcom/intellij/util/fastutil/ints/IntList;", "subLines2", "optimizeLineChunks", "iterable", "compareSmart", "getBigLines", "Lkotlin/Pair;", "lines", "threshold", "expandRanges", "getLines", "text", "convertMode", "original", "convertIntoMergeLineFragments", "Lcom/intellij/diff/fragments/MergeLineFragment;", "conflicts", "range", "Line", "intellij.platform.util.diff"})
@SourceDebugExtension(value={"SMAP\nByLineRt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByLineRt.kt\ncom/intellij/diff/comparison/ByLineRt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,457:1\n1563#2:458\n1634#2,3:459\n1563#2:462\n1634#2,3:463\n1563#2:466\n1634#2,3:467\n*S KotlinDebug\n*F\n+ 1 ByLineRt.kt\ncom/intellij/diff/comparison/ByLineRt\n*L\n384#1:458\n384#1:459,3\n401#1:462\n401#1:463,3\n410#1:466\n410#1:467,3\n*E\n"})
public final class ByLineRt {
    @NotNull
    public static final ByLineRt INSTANCE = new ByLineRt();

    private ByLineRt() {
    }

    @JvmStatic
    @NotNull
    public static final FairDiffIterable compare(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter(lines1, (String)"lines1");
        Intrinsics.checkNotNullParameter(lines2, (String)"lines2");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        return ByLineRt.doCompare$intellij_platform_util_diff(INSTANCE.getLines(lines1, policy), INSTANCE.getLines(lines2, policy), policy, indicator);
    }

    @JvmStatic
    @NotNull
    public static final List<MergeRange> compare(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull List<? extends CharSequence> lines3, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter(lines1, (String)"lines1");
        Intrinsics.checkNotNullParameter(lines2, (String)"lines2");
        Intrinsics.checkNotNullParameter(lines3, (String)"lines3");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        return ByLineRt.doCompare$intellij_platform_util_diff(INSTANCE.getLines(lines1, policy), INSTANCE.getLines(lines2, policy), INSTANCE.getLines(lines3, policy), policy, indicator, false);
    }

    @JvmStatic
    @NotNull
    public static final List<MergeRange> merge(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull List<? extends CharSequence> lines3, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter(lines1, (String)"lines1");
        Intrinsics.checkNotNullParameter(lines2, (String)"lines2");
        Intrinsics.checkNotNullParameter(lines3, (String)"lines3");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        return ByLineRt.doCompare$intellij_platform_util_diff(INSTANCE.getLines(lines1, policy), INSTANCE.getLines(lines2, policy), INSTANCE.getLines(lines3, policy), policy, indicator, true);
    }

    @JvmStatic
    @NotNull
    public static final FairDiffIterable doCompare$intellij_platform_util_diff(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter(lines1, (String)"lines1");
        Intrinsics.checkNotNullParameter(lines2, (String)"lines2");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            FairDiffIterable changes = INSTANCE.compareSmart(lines1, lines2, indicator);
            changes = INSTANCE.optimizeLineChunks(lines1, lines2, changes, indicator);
            return INSTANCE.expandRanges(lines1, lines2, changes);
        }
        List<Line> iwLines1 = INSTANCE.convertMode(lines1, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines2 = INSTANCE.convertMode(lines2, ComparisonPolicy.IGNORE_WHITESPACES);
        FairDiffIterable iwChanges = INSTANCE.compareSmart(iwLines1, iwLines2, indicator);
        iwChanges = INSTANCE.optimizeLineChunks(lines1, lines2, iwChanges, indicator);
        return INSTANCE.correctChangesSecondStep(lines1, lines2, iwChanges);
    }

    @JvmStatic
    @NotNull
    public static final List<MergeRange> doCompare$intellij_platform_util_diff(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull List<Line> lines3, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator, boolean keepIgnoredChanges) {
        Intrinsics.checkNotNullParameter(lines1, (String)"lines1");
        Intrinsics.checkNotNullParameter(lines2, (String)"lines2");
        Intrinsics.checkNotNullParameter(lines3, (String)"lines3");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        List<Line> iwLines1 = INSTANCE.convertMode(lines1, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines2 = INSTANCE.convertMode(lines2, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines3 = INSTANCE.convertMode(lines3, ComparisonPolicy.IGNORE_WHITESPACES);
        FairDiffIterable iwChanges1 = INSTANCE.compareSmart(iwLines2, iwLines1, indicator);
        iwChanges1 = INSTANCE.optimizeLineChunks(lines2, lines1, iwChanges1, indicator);
        FairDiffIterable iterable1 = INSTANCE.correctChangesSecondStep(lines2, lines1, iwChanges1);
        FairDiffIterable iwChanges2 = INSTANCE.compareSmart(iwLines2, iwLines3, indicator);
        iwChanges2 = INSTANCE.optimizeLineChunks(lines2, lines3, iwChanges2, indicator);
        FairDiffIterable iterable2 = INSTANCE.correctChangesSecondStep(lines2, lines3, iwChanges2);
        return keepIgnoredChanges && policy != ComparisonPolicy.DEFAULT ? ComparisonMergeUtil.INSTANCE.buildMerge$intellij_platform_util_diff(iterable1, iterable2, (arg_0, arg_1, arg_2) -> ByLineRt.doCompare$lambda$0(lines1, lines2, lines3, arg_0, arg_1, arg_2), indicator) : ComparisonMergeUtil.buildSimple(iterable1, iterable2, indicator);
    }

    private final boolean equalsDefaultPolicy(List<Line> lines1, List<Line> lines2, List<Line> lines3, int index1, int index2, int index3) {
        CharSequence content1 = lines1.get(index1).getContent();
        CharSequence content2 = lines2.get(index2).getContent();
        CharSequence content3 = lines3.get(index3).getContent();
        return ComparisonUtil.isEquals(content2, content1, ComparisonPolicy.DEFAULT) && ComparisonUtil.isEquals(content2, content3, ComparisonPolicy.DEFAULT);
    }

    private final FairDiffIterable correctChangesSecondStep(List<Line> lines1, List<Line> lines2, FairDiffIterable changes) {
        DiffIterableUtil.ExpandChangeBuilder builder = new DiffIterableUtil.ExpandChangeBuilder(lines1, lines2);
        new Object(changes, lines1, lines2, builder){
            private CharSequence sample;
            private int last1;
            private int last2;
            final /* synthetic */ FairDiffIterable $changes;
            final /* synthetic */ List<Line> $lines1;
            final /* synthetic */ List<Line> $lines2;
            final /* synthetic */ DiffIterableUtil.ExpandChangeBuilder $builder;
            {
                this.$changes = $changes;
                this.$lines1 = $lines1;
                this.$lines2 = $lines2;
                this.$builder = $builder;
            }

            public final void run() {
                for (Range range : this.$changes.iterateUnchanged()) {
                    int count = range.end1 - range.start1;
                    for (int i = 0; i < count; ++i) {
                        int index1 = range.start1 + i;
                        int index2 = range.start2 + i;
                        Line line1 = this.$lines1.get(index1);
                        Line line2 = this.$lines2.get(index2);
                        if (ComparisonUtil.isEquals(this.sample, line1.getContent(), ComparisonPolicy.IGNORE_WHITESPACES)) continue;
                        if (Intrinsics.areEqual((Object)line1, (Object)line2)) {
                            this.flush(index1, index2);
                            this.$builder.markEqual(index1, index2);
                            continue;
                        }
                        this.flush(index1, index2);
                        this.sample = line1.getContent();
                    }
                }
                this.flush(this.$changes.getLength1(), this.$changes.getLength2());
            }

            public final void flush(int line1, int line2) {
                int i;
                if (this.sample == null) {
                    return;
                }
                int start1 = Math.max(this.last1, this.$builder.getIndex1());
                int start2 = Math.max(this.last2, this.$builder.getIndex2());
                IntArrayList subLines1 = new IntArrayList();
                IntArrayList subLines2 = new IntArrayList();
                for (i = start1; i < line1; ++i) {
                    if (!ComparisonUtil.isEquals(this.sample, this.$lines1.get(i).getContent(), ComparisonPolicy.IGNORE_WHITESPACES)) continue;
                    subLines1.add(i);
                    this.last1 = i + 1;
                }
                for (i = start2; i < line2; ++i) {
                    if (!ComparisonUtil.isEquals(this.sample, this.$lines2.get(i).getContent(), ComparisonPolicy.IGNORE_WHITESPACES)) continue;
                    subLines2.add(i);
                    this.last2 = i + 1;
                }
                if (!(subLines1.getSize() > 0 && subLines2.getSize() > 0)) {
                    throw new IllegalStateException("Check failed.");
                }
                this.alignExactMatching((IntList)subLines1, (IntList)subLines2);
                this.sample = null;
            }

            public final void alignExactMatching(IntList subLines1, IntList subLines2) {
                boolean skipAligning;
                Intrinsics.checkNotNullParameter((Object)subLines1, (String)"subLines1");
                Intrinsics.checkNotNullParameter((Object)subLines2, (String)"subLines2");
                int n = Math.max(subLines1.getSize(), subLines2.getSize());
                boolean bl = skipAligning = n > 10 || subLines1.getSize() == subLines2.getSize();
                if (skipAligning) {
                    int count = Math.min(subLines1.getSize(), subLines2.getSize());
                    for (int i = 0; i < count; ++i) {
                        int index1 = subLines1.get(i);
                        int index2 = subLines2.get(i);
                        if (!Intrinsics.areEqual((Object)this.$lines1.get(index1), (Object)this.$lines2.get(index2))) continue;
                        this.$builder.markEqual(index1, index2);
                    }
                    return;
                }
                if (subLines1.getSize() < subLines2.getSize()) {
                    int[] matching = ByLineRt.access$getBestMatchingAlignment(ByLineRt.INSTANCE, subLines1, subLines2, this.$lines1, this.$lines2);
                    int i = 0;
                    int n2 = subLines1.getSize() - 1;
                    if (i <= n2) {
                        while (true) {
                            int index1 = subLines1.get(i);
                            int index2 = subLines2.get(matching[i]);
                            if (Intrinsics.areEqual((Object)this.$lines1.get(index1), (Object)this.$lines2.get(index2))) {
                                this.$builder.markEqual(index1, index2);
                            }
                            if (i != n2) {
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    int[] matching = ByLineRt.access$getBestMatchingAlignment(ByLineRt.INSTANCE, subLines2, subLines1, this.$lines2, this.$lines1);
                    int i = 0;
                    int n3 = subLines2.getSize() - 1;
                    if (i <= n3) {
                        while (true) {
                            int index1 = subLines1.get(matching[i]);
                            int index2 = subLines2.get(i);
                            if (Intrinsics.areEqual((Object)this.$lines1.get(index1), (Object)this.$lines2.get(index2))) {
                                this.$builder.markEqual(index1, index2);
                            }
                            if (i == n3) break;
                            ++i;
                        }
                    }
                }
            }
        }.run();
        return DiffIterableUtil.fair(builder.finish());
    }

    private final int[] getBestMatchingAlignment(IntList subLines1, IntList subLines2, List<Line> lines1, List<Line> lines2) {
        if (!(subLines1.getSize() < subLines2.getSize())) {
            throw new IllegalStateException("Check failed.");
        }
        int size = subLines1.getSize();
        int[] comb = new int[size];
        int[] best = new int[size];
        for (int i = 0; i < size; ++i) {
            best[i] = i;
        }
        new Object(subLines2, size, comb, subLines1, lines1, lines2, best){
            private int bestWeight;
            final /* synthetic */ IntList $subLines2;
            final /* synthetic */ int $size;
            final /* synthetic */ int[] $comb;
            final /* synthetic */ IntList $subLines1;
            final /* synthetic */ List<Line> $lines1;
            final /* synthetic */ List<Line> $lines2;
            final /* synthetic */ int[] $best;
            {
                this.$subLines2 = $subLines2;
                this.$size = $size;
                this.$comb = $comb;
                this.$subLines1 = $subLines1;
                this.$lines1 = $lines1;
                this.$lines2 = $lines2;
                this.$best = $best;
            }

            public final int getBestWeight() {
                return this.bestWeight;
            }

            public final void setBestWeight(int n) {
                this.bestWeight = n;
            }

            public final void run() {
                this.combinations(0, this.$subLines2.getSize() - 1, 0);
            }

            public final void combinations(int start, int n, int k) {
                if (k == this.$size) {
                    this.processCombination();
                    return;
                }
                int i = start;
                if (i <= n) {
                    do {
                        this.$comb[k] = ++i;
                        this.combinations(i + 1, n, k + 1);
                    } while (i != n);
                }
            }

            public final void processCombination() {
                int weight = 0;
                for (int i = 0; i < this.$size; ++i) {
                    int index1 = this.$subLines1.get(i);
                    int index2 = this.$subLines2.get(this.$comb[i]);
                    if (!Intrinsics.areEqual((Object)this.$lines1.get(index1), (Object)this.$lines2.get(index2))) continue;
                    ++weight;
                }
                if (weight > this.bestWeight) {
                    this.bestWeight = weight;
                    ArraysKt.copyInto((int[])this.$comb, (int[])this.$best, (int)0, (int)0, (int)this.$comb.length);
                }
            }
        }.run();
        return best;
    }

    private final FairDiffIterable optimizeLineChunks(List<Line> lines1, List<Line> lines2, FairDiffIterable iterable, CancellationChecker indicator) {
        return new ChunkOptimizer.LineChunkOptimizer(lines1, lines2, iterable, indicator).build();
    }

    private final FairDiffIterable compareSmart(List<Line> lines1, List<Line> lines2, CancellationChecker indicator) {
        int threshold = ComparisonUtil.getUnimportantLineCharCount();
        if (threshold == 0) {
            return DiffIterableUtil.diff(lines1, lines2, indicator);
        }
        Pair<List<Line>, IntList> bigLines1 = this.getBigLines(lines1, threshold);
        Pair<List<Line>, IntList> bigLines2 = this.getBigLines(lines2, threshold);
        FairDiffIterable changes = DiffIterableUtil.diff((List)bigLines1.getFirst(), (List)bigLines2.getFirst(), indicator);
        return new ChangeCorrector.SmartLineChangeCorrector((IntList)bigLines1.getSecond(), (IntList)bigLines2.getSecond(), lines1, lines2, changes, indicator).build();
    }

    private final Pair<List<Line>, IntList> getBigLines(List<Line> lines, int threshold) {
        List bigLines = new ArrayList(lines.size());
        IntArrayList indexes = new IntArrayList(lines.size());
        int n = ((Collection)lines).size();
        for (int i = 0; i < n; ++i) {
            Line line = lines.get(i);
            if (line.getNonSpaceChars() <= threshold) continue;
            bigLines.add(line);
            indexes.add(i);
        }
        return new Pair((Object)bigLines, (Object)indexes);
    }

    private final FairDiffIterable expandRanges(List<Line> lines1, List<Line> lines2, FairDiffIterable iterable) {
        ArrayList<Range> changes = new ArrayList<Range>();
        for (Range ch : iterable.iterateChanges()) {
            Range expanded = TrimUtil.expand(lines1, lines2, ch.start1, ch.start2, ch.end1, ch.end2);
            if (expanded.isEmpty()) continue;
            changes.add(expanded);
        }
        return DiffIterableUtil.fair(DiffIterableUtil.create((List<? extends Range>)changes, lines1.size(), lines2.size()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Line> getLines(List<? extends CharSequence> text, ComparisonPolicy policy) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = text;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void line;
            CharSequence charSequence = (CharSequence)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Line((CharSequence)line, policy));
        }
        return (List)destination$iv$iv;
    }

    private final List<Line> convertMode(List<Line> original, ComparisonPolicy policy) {
        ArrayList<Line> result = new ArrayList<Line>(original.size());
        for (Line line : original) {
            Line newLine = line.getPolicy() != policy ? new Line(line.getContent(), policy) : line;
            result.add(newLine);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<MergeLineFragment> convertIntoMergeLineFragments(@NotNull List<? extends MergeRange> conflicts) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        Iterable $this$map$iv = conflicts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MergeRange mergeRange = (MergeRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MergeLineFragmentImpl((MergeRange)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final List<MergeLineFragment> convertIntoMergeLineFragments(@NotNull List<? extends MergeRange> conflicts, @NotNull MergeRange range) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Iterable $this$map$iv = conflicts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void conflict;
            MergeRange mergeRange = (MergeRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MergeLineFragmentImpl(conflict.start1 + range.start1, conflict.end1 + range.start1, conflict.start2 + range.start2, conflict.end2 + range.start2, conflict.start3 + range.start3, conflict.end3 + range.start3));
        }
        return (List)destination$iv$iv;
    }

    private static final boolean doCompare$lambda$0(List $lines1, List $lines2, List $lines3, int index1, int index2, int index3) {
        return INSTANCE.equalsDefaultPolicy($lines1, $lines2, $lines3, index1, index2, index3);
    }

    public static final /* synthetic */ int[] access$getBestMatchingAlignment(ByLineRt $this, IntList subLines1, IntList subLines2, List lines1, List lines2) {
        return $this.getBestMatchingAlignment(subLines1, subLines2, lines1, lines2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/intellij/diff/comparison/ByLineRt$Line;", "", "content", "", "policy", "Lcom/intellij/diff/comparison/ComparisonPolicy;", "<init>", "(Ljava/lang/CharSequence;Lcom/intellij/diff/comparison/ComparisonPolicy;)V", "getContent", "()Ljava/lang/CharSequence;", "getPolicy", "()Lcom/intellij/diff/comparison/ComparisonPolicy;", "hash", "", "nonSpaceChars", "getNonSpaceChars", "()I", "equals", "", "other", "hashCode", "Companion", "intellij.platform.util.diff"})
    @ApiStatus.Internal
    public static final class Line {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final CharSequence content;
        @NotNull
        private final ComparisonPolicy policy;
        private final int hash;
        private final int nonSpaceChars;

        public Line(@NotNull CharSequence content, @NotNull ComparisonPolicy policy) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
            this.content = content;
            this.policy = policy;
            this.hash = ComparisonUtil.hashCode(this.content, this.policy);
            this.nonSpaceChars = Line.Companion.countNonSpaceChars(this.content);
        }

        @NotNull
        public final CharSequence getContent() {
            return this.content;
        }

        @NotNull
        public final ComparisonPolicy getPolicy() {
            return this.policy;
        }

        public final int getNonSpaceChars() {
            return this.nonSpaceChars;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Line line = (Line)other;
            if (!(this.policy == line.policy)) {
                throw new IllegalStateException("Check failed.");
            }
            if (this.hashCode() != line.hashCode()) {
                return false;
            }
            return ComparisonUtil.isEquals(this.content, line.content, this.policy);
        }

        public int hashCode() {
            return this.hash;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/diff/comparison/ByLineRt$Line$Companion;", "", "<init>", "()V", "countNonSpaceChars", "", "text", "", "intellij.platform.util.diff"})
        public static final class Companion {
            private Companion() {
            }

            private final int countNonSpaceChars(CharSequence text) {
                int nonSpace = 0;
                int len = text.length();
                for (int offset = 0; offset < len; ++offset) {
                    char c = text.charAt(offset);
                    if (TrimUtil.isSpaceEnterOrTab(c)) continue;
                    ++nonSpace;
                }
                return nonSpace;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

