/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.util.diff.BitSet;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.diff.MyersLCS;
import com.intellij.util.diff.UniqueLCS;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001BI\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000fJ\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J(\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J(\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J(\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/diff/PatienceIntLCS;", "", "first", "", "second", "start1", "", "count1", "start2", "count2", "changes1", "Lcom/intellij/util/diff/BitSet;", "changes2", "<init>", "([I[IIIIILcom/intellij/util/diff/BitSet;Lcom/intellij/util/diff/BitSet;)V", "([I[I)V", "execute", "", "failOnSmallReduction", "", "thresholdCheckCounter", "matchForward", "matchBackward", "addChange", "changes", "", "getChanges", "()[Lcom/intellij/util/diff/BitSet;", "checkReduction", "intellij.platform.util.diff"})
@ApiStatus.Internal
public final class PatienceIntLCS {
    @NotNull
    private final int[] first;
    @NotNull
    private final int[] second;
    private final int start1;
    private final int count1;
    private final int start2;
    private final int count2;
    @NotNull
    private final BitSet changes1;
    @NotNull
    private final BitSet changes2;

    @VisibleForTesting
    public PatienceIntLCS(@NotNull int[] first, @NotNull int[] second, int start1, int count1, int start2, int count2, @NotNull BitSet changes1, @NotNull BitSet changes2) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        Intrinsics.checkNotNullParameter((Object)changes1, (String)"changes1");
        Intrinsics.checkNotNullParameter((Object)changes2, (String)"changes2");
        this.first = first;
        this.second = second;
        this.start1 = start1;
        this.count1 = count1;
        this.start2 = start2;
        this.count2 = count2;
        this.changes1 = changes1;
        this.changes2 = changes2;
    }

    public PatienceIntLCS(@NotNull int[] first, @NotNull int[] second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        this(first, second, 0, first.length, 0, second.length, new BitSet(first.length), new BitSet(second.length));
    }

    @JvmOverloads
    public final void execute(boolean failOnSmallReduction) throws FilesTooBigForDiffException {
        int thresholdCheckCounter = failOnSmallReduction ? 2 : -1;
        this.execute(this.start1, this.count1, this.start2, this.count2, thresholdCheckCounter);
    }

    public static /* synthetic */ void execute$default(PatienceIntLCS patienceIntLCS, boolean bl, int n, Object object) throws FilesTooBigForDiffException {
        if ((n & 1) != 0) {
            bl = false;
        }
        patienceIntLCS.execute(bl);
    }

    private final void execute(int start1, int count1, int start2, int count2, int thresholdCheckCounter) throws FilesTooBigForDiffException {
        int startOffset;
        int endOffset;
        int start12 = start1;
        int count12 = count1;
        int start22 = start2;
        int count22 = count2;
        int thresholdCheckCounter2 = thresholdCheckCounter;
        if (count12 == 0 && count22 == 0) {
            return;
        }
        if (count12 == 0 || count22 == 0) {
            this.addChange(start12, count12, start22, count22);
            return;
        }
        if ((count12 -= (endOffset = this.matchBackward(start12 += (startOffset = this.matchForward(start12, count12, start22, count22)), count12 -= startOffset, start22 += startOffset, count22 -= startOffset))) == 0 || (count22 -= endOffset) == 0) {
            this.addChange(start12, count12, start22, count22);
        } else {
            if (thresholdCheckCounter2 == 0) {
                this.checkReduction(count12, count22);
            }
            thresholdCheckCounter2 = Math.max(-1, thresholdCheckCounter2 - 1);
            UniqueLCS uniqueLCS = new UniqueLCS(this.first, this.second, start12, count12, start22, count22);
            int[][] matching = uniqueLCS.execute();
            if (matching == null) {
                if (thresholdCheckCounter2 >= 0) {
                    this.checkReduction(count12, count22);
                }
                MyersLCS intLCS = new MyersLCS(this.first, this.second, start12, count12, start22, count22, this.changes1, this.changes2);
                intLCS.executeLinear();
            } else {
                int s1 = 0;
                int s2 = 0;
                int c1 = 0;
                int c2 = 0;
                int matched = matching[0].length;
                if (!(matched > 0)) {
                    throw new IllegalStateException("Check failed.");
                }
                c1 = matching[0][0];
                c2 = matching[1][0];
                this.execute(start12, c1, start22, c2, thresholdCheckCounter2);
                int n = matching[0].length;
                for (int i = 1; i < n; ++i) {
                    s1 = matching[0][i - 1] + 1;
                    s2 = matching[1][i - 1] + 1;
                    c1 = matching[0][i] - s1;
                    c2 = matching[1][i] - s2;
                    if (c1 <= 0 && c2 <= 0) continue;
                    this.execute(start12 + s1, c1, start22 + s2, c2, thresholdCheckCounter2);
                }
                if (matching[0][matched - 1] == count12 - 1) {
                    s1 = count12 - 1;
                    c1 = 0;
                } else {
                    s1 = matching[0][matched - 1] + 1;
                    c1 = count12 - s1;
                }
                if (matching[1][matched - 1] == count22 - 1) {
                    s2 = count22 - 1;
                    c2 = 0;
                } else {
                    s2 = matching[1][matched - 1] + 1;
                    c2 = count22 - s2;
                }
                this.execute(start12 + s1, c1, start22 + s2, c2, thresholdCheckCounter2);
            }
        }
    }

    private final int matchForward(int start1, int count1, int start2, int count2) {
        int size = Math.min(count1, count2);
        int idx = 0;
        for (int i = 0; i < size && this.first[start1 + i] == this.second[start2 + i]; ++i) {
            ++idx;
        }
        return idx;
    }

    private final int matchBackward(int start1, int count1, int start2, int count2) {
        int size = Math.min(count1, count2);
        int idx = 0;
        int i = 1;
        if (i <= size) {
            while (this.first[start1 + count1 - i] == this.second[start2 + count2 - i]) {
                ++idx;
                if (i == size) break;
                ++i;
            }
        }
        return idx;
    }

    private final void addChange(int start1, int count1, int start2, int count2) {
        BitSet.set$default(this.changes1, start1, start1 + count1, false, 4, null);
        BitSet.set$default(this.changes2, start2, start2 + count2, false, 4, null);
    }

    @NotNull
    public final BitSet[] getChanges() {
        BitSet[] bitSetArray = new BitSet[]{this.changes1, this.changes2};
        return bitSetArray;
    }

    private final void checkReduction(int count1, int count2) throws FilesTooBigForDiffException {
        if (count1 * 2 < this.count1) {
            return;
        }
        if (count2 * 2 < this.count2) {
            return;
        }
        throw new FilesTooBigForDiffException();
    }

    @JvmOverloads
    public final void execute() throws FilesTooBigForDiffException {
        PatienceIntLCS.execute$default(this, false, 1, null);
    }
}

