/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.MergeResolveUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.util.containers.PeekableIterator;
import com.intellij.util.containers.PeekableIteratorWrapper;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J3\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u000fJ\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/diff/comparison/ComparisonMergeUtil;", "", "<init>", "()V", "buildSimple", "", "Lcom/intellij/diff/util/MergeRange;", "fragments1", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "fragments2", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "buildMerge", "trueEquality", "Lcom/intellij/diff/comparison/ComparisonMergeUtil$SideEquality;", "buildMerge$intellij_platform_util_diff", "tryResolveConflict", "", "leftText", "baseText", "rightText", "FairMergeBuilder", "ChangeBuilder", "IgnoringChangeBuilder", "SideEquality", "intellij.platform.util.diff"})
public final class ComparisonMergeUtil {
    @NotNull
    public static final ComparisonMergeUtil INSTANCE = new ComparisonMergeUtil();

    private ComparisonMergeUtil() {
    }

    @JvmStatic
    @NotNull
    public static final List<MergeRange> buildSimple(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter((Object)fragments1, (String)"fragments1");
        Intrinsics.checkNotNullParameter((Object)fragments2, (String)"fragments2");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!(fragments1.getLength1() == fragments2.getLength1())) {
            throw new IllegalStateException("Check failed.");
        }
        return new FairMergeBuilder().execute(fragments1, fragments2);
    }

    @NotNull
    public final List<MergeRange> buildMerge$intellij_platform_util_diff(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2, @NotNull SideEquality trueEquality, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter((Object)fragments1, (String)"fragments1");
        Intrinsics.checkNotNullParameter((Object)fragments2, (String)"fragments2");
        Intrinsics.checkNotNullParameter((Object)trueEquality, (String)"trueEquality");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!(fragments1.getLength1() == fragments2.getLength1())) {
            throw new IllegalStateException("Check failed.");
        }
        return new FairMergeBuilder(trueEquality).execute(fragments1, fragments2);
    }

    @JvmStatic
    @Nullable
    public static final CharSequence tryResolveConflict(@NotNull CharSequence leftText, @NotNull CharSequence baseText, @NotNull CharSequence rightText) {
        Intrinsics.checkNotNullParameter((Object)leftText, (String)"leftText");
        Intrinsics.checkNotNullParameter((Object)baseText, (String)"baseText");
        Intrinsics.checkNotNullParameter((Object)rightText, (String)"rightText");
        return MergeResolveUtil.tryResolve(leftText, baseText, rightText);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\b\u0012\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0004J6\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nJ8\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/diff/comparison/ComparisonMergeUtil$ChangeBuilder;", "", "<init>", "()V", "myChanges", "", "Lcom/intellij/diff/util/MergeRange;", "getMyChanges", "()Ljava/util/List;", "myIndex1", "", "myIndex2", "myIndex3", "addChange", "", "start1", "start2", "start3", "end1", "end2", "end3", "markEqual", "finish", "length1", "length2", "length3", "processChange", "intellij.platform.util.diff"})
    private static class ChangeBuilder {
        @NotNull
        private final List<MergeRange> myChanges = new ArrayList();
        private int myIndex1;
        private int myIndex2;
        private int myIndex3;

        @NotNull
        protected final List<MergeRange> getMyChanges() {
            return this.myChanges;
        }

        protected final void addChange(int start1, int start2, int start3, int end1, int end2, int end3) {
            if (start1 == end1 && start2 == end2 && start3 == end3) {
                return;
            }
            this.myChanges.add(new MergeRange(start1, end1, start2, end2, start3, end3));
        }

        public final void markEqual(int start1, int start2, int start3, int end1, int end2, int end3) {
            if (!(this.myIndex1 <= start1)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(this.myIndex2 <= start2)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(this.myIndex3 <= start3)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(start1 <= end1)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(start2 <= end2)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(start3 <= end3)) {
                throw new IllegalStateException("Check failed.");
            }
            this.processChange(this.myIndex1, this.myIndex2, this.myIndex3, start1, start2, start3);
            this.myIndex1 = end1;
            this.myIndex2 = end2;
            this.myIndex3 = end3;
        }

        @NotNull
        public final List<MergeRange> finish(int length1, int length2, int length3) {
            if (!(this.myIndex1 <= length1)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(this.myIndex2 <= length2)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(this.myIndex3 <= length3)) {
                throw new IllegalStateException("Check failed.");
            }
            this.processChange(this.myIndex1, this.myIndex2, this.myIndex3, length1, length2, length3);
            return this.myChanges;
        }

        protected void processChange(int start1, int start2, int start3, int end1, int end2, int end3) {
            this.addChange(start1, start2, start3, end1, end2, end3);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/diff/comparison/ComparisonMergeUtil$FairMergeBuilder;", "", "<init>", "()V", "trueEquality", "Lcom/intellij/diff/comparison/ComparisonMergeUtil$SideEquality;", "(Lcom/intellij/diff/comparison/ComparisonMergeUtil$SideEquality;)V", "myChangesBuilder", "Lcom/intellij/diff/comparison/ComparisonMergeUtil$ChangeBuilder;", "execute", "", "Lcom/intellij/diff/util/MergeRange;", "fragments1", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "fragments2", "add", "Lcom/intellij/diff/util/Side;", "range1", "Lcom/intellij/diff/util/Range;", "range2", "intellij.platform.util.diff"})
    private static final class FairMergeBuilder {
        @NotNull
        private final ChangeBuilder myChangesBuilder;

        public FairMergeBuilder() {
            this.myChangesBuilder = new ChangeBuilder();
        }

        public FairMergeBuilder(@NotNull SideEquality trueEquality) {
            Intrinsics.checkNotNullParameter((Object)trueEquality, (String)"trueEquality");
            this.myChangesBuilder = new IgnoringChangeBuilder(trueEquality);
        }

        @NotNull
        public final List<MergeRange> execute(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2) {
            Intrinsics.checkNotNullParameter((Object)fragments1, (String)"fragments1");
            Intrinsics.checkNotNullParameter((Object)fragments2, (String)"fragments2");
            PeekableIterator unchanged1 = (PeekableIterator)new PeekableIteratorWrapper(fragments1.unchanged());
            PeekableIterator unchanged2 = (PeekableIterator)new PeekableIteratorWrapper(fragments2.unchanged());
            while (unchanged1.hasNext() && unchanged2.hasNext()) {
                Side side = this.add((Range)unchanged1.peek(), (Range)unchanged2.peek());
                side.selectNotNull(unchanged1, unchanged2).next();
            }
            return this.myChangesBuilder.finish(fragments1.getLength2(), fragments1.getLength1(), fragments2.getLength2());
        }

        @NotNull
        public final Side add(@NotNull Range range1, @NotNull Range range2) {
            Intrinsics.checkNotNullParameter((Object)range1, (String)"range1");
            Intrinsics.checkNotNullParameter((Object)range2, (String)"range2");
            int start1 = range1.start1;
            int end1 = range1.end1;
            int start2 = range2.start1;
            int end2 = range2.end1;
            if (end1 <= start2) {
                return Side.LEFT;
            }
            if (end2 <= start1) {
                return Side.RIGHT;
            }
            int startBase = Math.max(start1, start2);
            int endBase = Math.min(end1, end2);
            int count = endBase - startBase;
            int startShift1 = startBase - start1;
            int startShift2 = startBase - start2;
            int startLeft = range1.start2 + startShift1;
            int endLeft = startLeft + count;
            int startRight = range2.start2 + startShift2;
            int endRight = startRight + count;
            this.myChangesBuilder.markEqual(startLeft, startBase, startRight, endLeft, endBase, endRight);
            return Side.Companion.fromLeft(end1 <= end2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0014J6\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diff/comparison/ComparisonMergeUtil$IgnoringChangeBuilder;", "Lcom/intellij/diff/comparison/ComparisonMergeUtil$ChangeBuilder;", "myTrueEquality", "Lcom/intellij/diff/comparison/ComparisonMergeUtil$SideEquality;", "<init>", "(Lcom/intellij/diff/comparison/ComparisonMergeUtil$SideEquality;)V", "processChange", "", "start1", "", "start2", "start3", "end1", "end2", "end3", "addIgnoredChanges", "intellij.platform.util.diff"})
    private static final class IgnoringChangeBuilder
    extends ChangeBuilder {
        @NotNull
        private final SideEquality myTrueEquality;

        public IgnoringChangeBuilder(@NotNull SideEquality myTrueEquality) {
            Intrinsics.checkNotNullParameter((Object)myTrueEquality, (String)"myTrueEquality");
            this.myTrueEquality = myTrueEquality;
        }

        @Override
        protected void processChange(int start1, int start2, int start3, int end1, int end2, int end3) {
            MergeRange lastChange;
            MergeRange mergeRange = lastChange = this.getMyChanges().isEmpty() ? null : this.getMyChanges().get(this.getMyChanges().size() - 1);
            int unchangedStart1 = mergeRange != null ? mergeRange.end1 : 0;
            MergeRange mergeRange2 = lastChange;
            int unchangedStart2 = mergeRange2 != null ? mergeRange2.end2 : 0;
            MergeRange mergeRange3 = lastChange;
            int unchangedStart3 = mergeRange3 != null ? mergeRange3.end3 : 0;
            this.addIgnoredChanges(unchangedStart1, unchangedStart2, unchangedStart3, start1, start2, start3);
            this.addChange(start1, start2, start3, end1, end2, end3);
        }

        public final void addIgnoredChanges(int start1, int start2, int start3, int end1, int end2, int end3) {
            int count = end2 - start2;
            if (!(end1 - start1 == count)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(end3 - start3 == count)) {
                throw new IllegalStateException("Check failed.");
            }
            int firstIgnoredCount = -1;
            for (int i = 0; i < count; ++i) {
                boolean previousAreIgnored;
                boolean isIgnored = !this.myTrueEquality.equals(start1 + i, start2 + i, start3 + i);
                boolean bl = previousAreIgnored = firstIgnoredCount != -1;
                if (isIgnored && !previousAreIgnored) {
                    firstIgnoredCount = i;
                }
                if (isIgnored || !previousAreIgnored) continue;
                this.addChange(start1 + firstIgnoredCount, start2 + firstIgnoredCount, start3 + firstIgnoredCount, start1 + i, start2 + i, start3 + i);
                firstIgnoredCount = -1;
            }
            if (firstIgnoredCount != -1) {
                this.addChange(start1 + firstIgnoredCount, start2 + firstIgnoredCount, start3 + firstIgnoredCount, start1 + count, start2 + count, start3 + count);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/diff/comparison/ComparisonMergeUtil$SideEquality;", "", "equals", "", "leftIndex", "", "baseIndex", "rightIndex", "intellij.platform.util.diff"})
    public static interface SideEquality {
        public boolean equals(int var1, int var2, int var3);
    }
}

