/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.util.diff.ReindexerKt;
import com.intellij.util.fastutil.ints.IntArrayList;
import com.intellij.util.fastutil.ints.IntList;
import com.intellij.util.fastutil.ints.IntListExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/diff/tools/util/text/LineOffsetsImpl;", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "myLineEnds", "", "textLength", "", "<init>", "([II)V", "getTextLength", "()I", "getLineStart", "line", "getLineEnd", "includeNewline", "", "getLineNumber", "offset", "lineCount", "getLineCount", "checkLineIndex", "", "index", "Companion", "intellij.platform.util.diff"})
public final class LineOffsetsImpl
implements LineOffsets {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] myLineEnds;
    private final int textLength;

    private LineOffsetsImpl(int[] myLineEnds, int textLength) {
        this.myLineEnds = myLineEnds;
        this.textLength = textLength;
    }

    @Override
    public int getTextLength() {
        return this.textLength;
    }

    @Override
    public int getLineStart(int line) {
        this.checkLineIndex(line);
        if (line == 0) {
            return 0;
        }
        return this.myLineEnds[line - 1] + 1;
    }

    @Override
    public int getLineEnd(int line) {
        this.checkLineIndex(line);
        return this.myLineEnds[line];
    }

    @Override
    public int getLineEnd(int line, boolean includeNewline) {
        this.checkLineIndex(line);
        return this.myLineEnds[line] + (includeNewline && line != this.myLineEnds.length - 1 ? 1 : 0);
    }

    @Override
    public int getLineNumber(int offset) {
        if (offset < 0 || offset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + ". Available text length: " + this.getTextLength());
        }
        if (offset == 0) {
            return 0;
        }
        if (offset == this.getTextLength()) {
            return this.getLineCount() - 1;
        }
        int bsResult = ReindexerKt.binarySearch$default(this.myLineEnds, offset, 0, 0, 6, null);
        return bsResult >= 0 ? bsResult : -bsResult - 1;
    }

    @Override
    public int getLineCount() {
        return this.myLineEnds.length;
    }

    private final void checkLineIndex(int index) {
        if (index < 0 || index >= this.getLineCount()) {
            throw new IndexOutOfBoundsException("Wrong line: " + index + ". Available lines count: " + this.getLineCount());
        }
    }

    @JvmStatic
    @NotNull
    public static final LineOffsets create(@NotNull CharSequence text) {
        return Companion.create(text);
    }

    public /* synthetic */ LineOffsetsImpl(int[] myLineEnds, int textLength, DefaultConstructorMarker $constructor_marker) {
        this(myLineEnds, textLength);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/diff/tools/util/text/LineOffsetsImpl$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "text", "", "intellij.platform.util.diff"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LineOffsets create(@NotNull CharSequence text) {
            int lineEnd;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            IntArrayList ends = new IntArrayList();
            int index = 0;
            while ((lineEnd = StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)index, (boolean)false, (int)4, null)) != -1) {
                ends.add(lineEnd);
                index = lineEnd + 1;
            }
            ends.add(text.length());
            return new LineOffsetsImpl(IntListExtensionsKt.toArray((IntList)((IntList)ends)), text.length(), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

