/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtilKt;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.openapi.util.text.StringsKmp;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0007J\b\u0010\u0012\u001a\u00020\fH\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/diff/comparison/ComparisonUtil;", "", "<init>", "()V", "isEquals", "", "text1", "", "text2", "policy", "Lcom/intellij/diff/comparison/ComparisonPolicy;", "hashCode", "", "text", "isEqualTexts", "equalsTrimWhitespaces", "s1", "s2", "getUnimportantLineCharCount", "intellij.platform.util.diff"})
public final class ComparisonUtil {
    @NotNull
    public static final ComparisonUtil INSTANCE = new ComparisonUtil();

    private ComparisonUtil() {
    }

    @JvmStatic
    public static final boolean isEquals(@Nullable CharSequence text1, @Nullable CharSequence text2, @NotNull ComparisonPolicy policy) {
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        if (text1 == text2) {
            return true;
        }
        if (text1 == null || text2 == null) {
            return false;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 1: {
                return ComparisonUtilKt.access$equalsByContents(text1, text2);
            }
            case 2: {
                return StringsKmp.equalsTrimWhitespaces((CharSequence)text1, (CharSequence)text2);
            }
            case 3: {
                return StringsKmp.equalsIgnoreWhitespaces((CharSequence)text1, (CharSequence)text2);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @JvmStatic
    public static final int hashCode(@NotNull CharSequence text, @NotNull ComparisonPolicy policy) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 1: {
                return StringsKmp.stringHashCode((CharSequence)text);
            }
            case 2: {
                int offset1 = TrimUtil.trimStart(text, 0, text.length());
                int offset2 = TrimUtil.trimEnd(text, offset1, text.length());
                return StringsKmp.stringHashCode$default((CharSequence)text, (int)offset1, (int)offset2, (int)0, (int)4, null);
            }
            case 3: {
                return StringsKmp.stringHashCodeIgnoreWhitespaces((CharSequence)text);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @JvmStatic
    @Contract(pure=true)
    public static final boolean isEqualTexts(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 1: {
                return ComparisonUtilKt.access$equalsByContents(text1, text2);
            }
            case 2: {
                return ComparisonUtil.equalsTrimWhitespaces(text1, text2);
            }
            case 3: {
                return StringsKmp.equalsIgnoreWhitespaces((CharSequence)text1, (CharSequence)text2);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @JvmStatic
    @Contract(pure=true)
    public static final boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        boolean lastLine1;
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        int index1 = 0;
        int index2 = 0;
        do {
            CharSequence line2;
            lastLine1 = false;
            boolean lastLine2 = false;
            int end1 = StringsKt.indexOf$default((CharSequence)s1, (char)'\n', (int)index1, (boolean)false, (int)4, null) + 1;
            int end2 = StringsKt.indexOf$default((CharSequence)s2, (char)'\n', (int)index2, (boolean)false, (int)4, null) + 1;
            if (end1 == 0) {
                end1 = s1.length();
                lastLine1 = true;
            }
            if (end2 == 0) {
                end2 = s2.length();
                lastLine2 = true;
            }
            if (lastLine1 ^ lastLine2) {
                return false;
            }
            CharSequence line1 = s1.subSequence(index1, end1);
            if (!StringsKmp.equalsTrimWhitespaces((CharSequence)line1, (CharSequence)(line2 = s2.subSequence(index2, end2)))) {
                return false;
            }
            index1 = end1;
            index2 = end2;
        } while (!lastLine1);
        return true;
    }

    @JvmStatic
    public static final int getUnimportantLineCharCount() {
        return 3;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComparisonPolicy.values().length];
            try {
                nArray[ComparisonPolicy.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparisonPolicy.TRIM_WHITESPACES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparisonPolicy.IGNORE_WHITESPACES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

