/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.mvstore;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.mvstore.StoreErrorHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001aR\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007\u001a*\u0010\u0011\u001a\u00020\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007\u001a\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a(\u0010\u0015\u001a\u00020\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a8\u0006\u0016"}, d2={"markMvStoreDbAsInvalid", "", "file", "Ljava/nio/file/Path;", "openOrResetMap", "Lorg/h2/mvstore/MVMap;", "K", "V", "store", "Lorg/h2/mvstore/MVStore;", "name", "", "mapBuilder", "Lorg/h2/mvstore/MVMap$Builder;", "logSupplier", "Lkotlin/Function0;", "Lcom/intellij/openapi/diagnostic/Logger;", "createOrResetMvStore", "readOnly", "", "getInvalidateMarkerFile", "tryOpenMvStore", "intellij.platform.util.ex"})
@SourceDebugExtension(value={"SMAP\nMvStoreHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MvStoreHelper.kt\ncom/intellij/util/io/mvstore/MvStoreHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class MvStoreHelperKt {
    @ApiStatus.Internal
    public static final void markMvStoreDbAsInvalid(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Files.exists(file, new LinkOption[0])) {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE};
            Files.write(MvStoreHelperKt.getInvalidateMarkerFile(file), ArrayUtilRt.EMPTY_BYTE_ARRAY, openOptionArray);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final <K, V> MVMap<K, V> openOrResetMap(@NotNull MVStore store, @NotNull String name, @NotNull MVMap.Builder<K, V> mapBuilder, @NotNull Function0<? extends Logger> logSupplier) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(mapBuilder, (String)"mapBuilder");
        Intrinsics.checkNotNullParameter(logSupplier, (String)"logSupplier");
        try {
            MVMap mVMap = store.openMap(name, (MVMap.MapBuilder)mapBuilder);
            Intrinsics.checkNotNullExpressionValue((Object)mVMap, (String)"openMap(...)");
            return mVMap;
        }
        catch (Throwable e) {
            ((Logger)logSupplier.invoke()).error("Cannot open map " + name + ", map will be removed", e);
            try {
                store.removeMap(name);
            }
            catch (Throwable e2) {
                ExceptionsKt.addSuppressed((Throwable)e, (Throwable)e2);
            }
            MVMap mVMap = store.openMap(name, (MVMap.MapBuilder)mapBuilder);
            Intrinsics.checkNotNullExpressionValue((Object)mVMap, (String)"openMap(...)");
            return mVMap;
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final MVStore createOrResetMvStore(@Nullable Path file, boolean readOnly, @NotNull Function0<? extends Logger> logSupplier) {
        Intrinsics.checkNotNullParameter(logSupplier, (String)"logSupplier");
        if (file == null || readOnly && Files.notExists(file, new LinkOption[0])) {
            return MvStoreHelperKt.tryOpenMvStore(null, readOnly, logSupplier);
        }
        Path markerFile = MvStoreHelperKt.getInvalidateMarkerFile(file);
        if (Files.exists(markerFile, new LinkOption[0])) {
            Files.deleteIfExists(file);
            Files.deleteIfExists(markerFile);
        }
        Path path = file.getParent();
        if (path != null) {
            Path it = path;
            boolean bl = false;
            Files.createDirectories(it, new FileAttribute[0]);
        }
        try {
            return MvStoreHelperKt.tryOpenMvStore(file, readOnly, logSupplier);
        }
        catch (Throwable e) {
            ((Logger)logSupplier.invoke()).warn("Cannot open cache state storage, will be recreated", e);
            Files.deleteIfExists(file);
            return MvStoreHelperKt.tryOpenMvStore(file, readOnly, logSupplier);
        }
    }

    public static /* synthetic */ MVStore createOrResetMvStore$default(Path path, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return MvStoreHelperKt.createOrResetMvStore(path, bl, (Function0<? extends Logger>)function0);
    }

    private static final Path getInvalidateMarkerFile(Path file) {
        Path path = file.resolveSibling(file.getFileName() + ".invalidated");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
        return path;
    }

    private static final MVStore tryOpenMvStore(Path file, boolean readOnly, Function0<? extends Logger> logSupplier) {
        StoreErrorHandler storeErrorHandler = new StoreErrorHandler(file, logSupplier);
        Path path = file;
        MVStore.Builder it = new MVStore.Builder().fileName(path != null && (path = path.toAbsolutePath()) != null ? ((Object)path).toString() : null).backgroundExceptionHandler((Thread.UncaughtExceptionHandler)storeErrorHandler).autoCommitDisabled().cacheSize(8);
        boolean bl = false;
        MVStore store = (readOnly ? it.readOnly() : it).open();
        storeErrorHandler.isStoreOpened = true;
        store.setVersionsToKeep(0);
        Intrinsics.checkNotNull((Object)store);
        return store;
    }
}

