/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.io.IoKt;
import com.intellij.util.text.CharArrayCharSequence;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u000b\u00a2\u0006\u0004\b\t\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\b\b\u0002\u0010\u0013\u001a\u00020\bJ\u0012\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0013\u001a\u00020\bH\u0007J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u0012\u0010\u0016\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\bH\u0007J\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\u0013\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\u0012\u0010\u001b\u001a\u00020\u00102\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/credentialStore/OneTimeString;", "Lcom/intellij/util/text/CharArrayCharSequence;", "value", "", "offset", "", "length", "clearable", "", "<init>", "([CIIZ)V", "", "(Ljava/lang/String;)V", "consumed", "Ljava/util/concurrent/atomic/AtomicReference;", "consume", "", "willBeCleared", "toString", "clear", "toByteArray", "", "toCharArray", "clone", "equals", "other", "", "appendTo", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.platform.util.ex"})
@SourceDebugExtension(value={"SMAP\nOneTimeString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OneTimeString.kt\ncom/intellij/credentialStore/OneTimeString\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class OneTimeString
extends CharArrayCharSequence {
    private boolean clearable;
    @NotNull
    private final AtomicReference<String> consumed;

    @JvmOverloads
    public OneTimeString(@NotNull char[] value, int offset, int length, boolean clearable) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(value, offset, offset + length);
        this.clearable = clearable;
        this.consumed = new AtomicReference();
    }

    public /* synthetic */ OneTimeString(char[] cArray, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = cArray.length;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        this(cArray, n, n2, bl);
    }

    public OneTimeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        char[] cArray = value.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        this(cArray, 0, 0, false, 14, null);
    }

    private final void consume(boolean willBeCleared) {
        if (!this.clearable) {
            return;
        }
        if (!willBeCleared) {
            String string = this.consumed.get();
            if (string != null) {
                String it = string;
                boolean bl = false;
                throw new IllegalStateException("Already consumed: " + it + "\n---\n");
            }
        } else if (!this.consumed.compareAndSet(null, ExceptionUtil.currentStackTrace())) {
            throw new IllegalStateException("Already consumed at " + this.consumed.get());
        }
    }

    @NotNull
    public final String toString(boolean clear) {
        this.consume(clear);
        String result = super.toString();
        this.clear();
        return result;
    }

    public static /* synthetic */ String toString$default(OneTimeString oneTimeString, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return oneTimeString.toString(bl);
    }

    @JvmOverloads
    @NotNull
    public final byte[] toByteArray(boolean clear) {
        this.consume(clear);
        ByteBuffer result = Charsets.UTF_8.encode(CharBuffer.wrap(this.myChars, this.myStart, this.length()));
        if (clear) {
            this.clear();
        }
        Intrinsics.checkNotNull((Object)result);
        return IoKt.toByteArray$default((ByteBuffer)result, (boolean)false, (int)1, null);
    }

    public static /* synthetic */ byte[] toByteArray$default(OneTimeString oneTimeString, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return oneTimeString.toByteArray(bl);
    }

    private final void clear() {
        if (this.clearable) {
            ArraysKt.fill((char[])this.myChars, (char)'\u0000', (int)this.myStart, (int)this.myEnd);
        }
    }

    @JvmOverloads
    @NotNull
    public final char[] toCharArray(boolean clear) {
        this.consume(clear);
        if (clear) {
            char[] result = new char[this.length()];
            this.getChars(result, 0);
            this.clear();
            return result;
        }
        return this.getChars();
    }

    public static /* synthetic */ char[] toCharArray$default(OneTimeString oneTimeString, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return oneTimeString.toCharArray(bl);
    }

    @NotNull
    public final OneTimeString clone(boolean clear, boolean clearable) {
        return new OneTimeString(this.toCharArray(clear), 0, 0, clearable, 6, null);
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof CharSequence) {
            return StringUtil.equals((CharSequence)((CharSequence)((Object)this)), (CharSequence)((CharSequence)other));
        }
        return super.equals(other);
    }

    public final void appendTo(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.consume(false);
        StringBuilder stringBuilder = builder;
        char[] cArray = this.myChars;
        int n = this.myStart;
        int n2 = this.myStart + this.length();
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(cArray, n, n2 - n), (String)"append(...)");
    }

    @JvmOverloads
    public OneTimeString(@NotNull char[] value, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this(value, offset, length, false, 8, null);
    }

    @JvmOverloads
    public OneTimeString(@NotNull char[] value, int offset) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this(value, offset, 0, false, 12, null);
    }

    @JvmOverloads
    public OneTimeString(@NotNull char[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this(value, 0, 0, false, 14, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] toByteArray() {
        return OneTimeString.toByteArray$default(this, false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final char[] toCharArray() {
        return OneTimeString.toCharArray$default(this, false, 1, null);
    }
}

