/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.Base62;
import com.intellij.util.io.DigestUtil;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public final class Ksuid {
    private static final int EPOCH = 1400000000;
    private static final int TIMESTAMP_LENGTH = 4;
    private static final int PAYLOAD_LENGTH = 16;
    public static final int MAX_ENCODED_LENGTH = 27;

    @NotNull
    public static String generate() {
        ByteBuffer byteBuffer = Ksuid.generateCustom(16, DigestUtil.getRandom());
        String uid = new String(Base62.encode(byteBuffer.array()), StandardCharsets.UTF_8);
        String string = uid.length() > 27 ? uid.substring(0, 27) : uid;
        if (string == null) {
            Ksuid.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static ByteBuffer generateCustom(int payloadLength, @NotNull Random random) {
        if (random == null) {
            Ksuid.$$$reportNull$$$0(1);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + payloadLength);
        long utc = ZonedDateTime.now(ZoneOffset.UTC).toInstant().toEpochMilli() / 1000L;
        int timestamp = (int)(utc - 1400000000L);
        byteBuffer.putInt(timestamp);
        byte[] bytes = new byte[payloadLength];
        random.nextBytes(bytes);
        byteBuffer.put(bytes);
        ByteBuffer byteBuffer2 = byteBuffer;
        if (byteBuffer2 == null) {
            Ksuid.$$$reportNull$$$0(2);
        }
        return byteBuffer2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/Ksuid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "random";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/Ksuid";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCustom";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateCustom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

