/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.blobstorage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IntRef;
import com.intellij.platform.util.io.storages.blobstorage.RecordAlreadyDeletedException;
import com.intellij.platform.util.io.storages.blobstorage.RecordLayout;
import com.intellij.platform.util.io.storages.blobstorage.StreamlinedBlobStorageHelper;
import com.intellij.util.io.ClosedStorageException;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PagedFileStorageWithRWLockedPageContent;
import com.intellij.util.io.blobstorage.ByteBufferReader;
import com.intellij.util.io.blobstorage.ByteBufferWriter;
import com.intellij.util.io.blobstorage.SpaceAllocationStrategy;
import com.intellij.util.io.blobstorage.StreamlinedBlobStorage;
import com.intellij.util.io.pagecache.Page;
import com.intellij.util.io.pagecache.PageUnsafe;
import io.opentelemetry.api.metrics.BatchCallback;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StreamlinedBlobStorageOverLockFreePagedStorage
extends StreamlinedBlobStorageHelper
implements StreamlinedBlobStorage {
    private static final Logger LOG = Logger.getInstance(StreamlinedBlobStorageOverLockFreePagedStorage.class);
    public static final int STORAGE_VERSION_CURRENT = 1;
    @NotNull
    private final PagedFileStorageWithRWLockedPageContent pagedStorage;
    private final BatchCallback openTelemetryCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamlinedBlobStorageOverLockFreePagedStorage(@NotNull PagedFileStorageWithRWLockedPageContent pagedStorage, @NotNull SpaceAllocationStrategy allocationStrategy) throws IOException {
        if (pagedStorage == null) {
            StreamlinedBlobStorageOverLockFreePagedStorage.$$$reportNull$$$0(0);
        }
        if (allocationStrategy == null) {
            StreamlinedBlobStorageOverLockFreePagedStorage.$$$reportNull$$$0(1);
        }
        super(allocationStrategy, pagedStorage.getPageSize(), pagedStorage.isNativeBytesOrder() ? ByteOrder.nativeOrder() : ByteOrder.BIG_ENDIAN);
        this.pagedStorage = pagedStorage;
        int pageSize = pagedStorage.getPageSize();
        try (Page headerPage = pagedStorage.pageByIndex(0, true);){
            headerPage.lockPageForWrite();
            try {
                long length = pagedStorage.length();
                if (length > 0x3FFFFFFF8L) {
                    throw new IOException("Can't read file[" + String.valueOf(pagedStorage) + "]: too big, " + length + "b > max(Integer.MAX_VALUE * 8)");
                }
                if (length == 0L) {
                    this.putHeaderInt(0, MAGIC_WORD);
                    this.putHeaderInt(4, 1);
                    this.putHeaderInt(8, pageSize);
                    ((PageUnsafe)headerPage).regionModified(0, this.headerSize());
                    this.updateNextRecordId(this.offsetToId(this.recordsStartOffset()));
                    this.wasClosedProperly.set(true);
                } else {
                    int magicWord = this.readHeaderInt(0);
                    if (magicWord != MAGIC_WORD) {
                        throw new IOException("[" + String.valueOf(pagedStorage.getFile()) + "] is of incorrect type: .magicWord(=" + magicWord + ", '" + IOUtil.magicWordToASCII((int)magicWord) + "') != " + MAGIC_WORD + " expected");
                    }
                    int version = this.getStorageVersion();
                    if (version != 1) {
                        throw new IOException("[" + String.valueOf(pagedStorage.getFile()) + "]: file version(" + version + ") != current impl version (1)");
                    }
                    int filePageSize = this.readHeaderInt(8);
                    if (pageSize != filePageSize) {
                        throw new IOException("[" + String.valueOf(pagedStorage.getFile()) + "]: file created with pageSize=" + filePageSize + " but current storage.pageSize=" + pageSize);
                    }
                    int nextRecordId = this.readHeaderInt(16);
                    this.updateNextRecordId(nextRecordId);
                    this.recordsAllocated.set(this.readHeaderInt(20));
                    this.recordsRelocated.set(this.readHeaderInt(24));
                    this.recordsDeleted.set(this.readHeaderInt(28));
                    this.totalLiveRecordsPayloadBytes.set(this.readHeaderLong(32));
                    this.totalLiveRecordsCapacityBytes.set(this.readHeaderLong(40));
                    boolean wasClosedProperly = this.readHeaderInt(12) == 1;
                    this.wasClosedProperly.set(wasClosedProperly);
                }
                this.putHeaderInt(12, 0);
            }
            finally {
                headerPage.unlockPageForWrite();
            }
        }
        this.openTelemetryCallback = StreamlinedBlobStorageOverLockFreePagedStorage.setupReportingToOpenTelemetry(pagedStorage.getFile().getFileName(), this);
    }

    public int getStorageVersion() throws IOException {
        return this.readHeaderInt(4);
    }

    public int getDataFormatVersion() throws IOException {
        return this.readHeaderInt(48);
    }

    public void setDataFormatVersion(int expectedVersion) throws IOException {
        this.putHeaderInt(48, expectedVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRecord(int recordId, @Nullable IntRef redirectToIdRef) throws IOException {
        if (recordId == 0) {
            return false;
        }
        StreamlinedBlobStorageOverLockFreePagedStorage.checkRecordIdValid(recordId);
        if (!this.isRecordIdAllocated(recordId)) {
            return false;
        }
        int currentRecordId = recordId;
        for (int i = 0; i < 256; ++i) {
            long recordOffset = this.idToOffset(currentRecordId);
            try (PageUnsafe page = (PageUnsafe)this.pagedStorage.pageByOffset(recordOffset, false);){
                int offsetOnPage = this.pagedStorage.toOffsetInPage(recordOffset);
                page.lockPageForRead();
                try {
                    ByteBuffer buffer = page.rawPageBuffer();
                    RecordLayout recordLayout = RecordLayout.recordLayout(buffer, offsetOnPage);
                    byte recordType = recordLayout.recordType();
                    if (redirectToIdRef != null) {
                        redirectToIdRef.set(currentRecordId);
                    }
                    if (recordType == 0) {
                        boolean bl = true;
                        return bl;
                    }
                    if (recordType == 64) {
                        int redirectToId = recordLayout.redirectToId(buffer, offsetOnPage);
                        if (redirectToId == 0) {
                            boolean bl = false;
                            return bl;
                        }
                        this.checkRedirectToId(recordId, currentRecordId, redirectToId);
                        currentRecordId = redirectToId;
                        continue;
                    }
                    throw new AssertionError((Object)("RecordType(" + recordType + ") should not appear in the chain: it is either not implemented yet, or all wrong"));
                }
                finally {
                    page.unlockPageForRead();
                }
            }
        }
        throw new IOException("record[" + recordId + "].redirectTo chain is too long (>=256): circular reference?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Out> Out readRecord(int recordId, @NotNull ByteBufferReader<Out> reader, @Nullable IntRef redirectToIdRef) throws IOException {
        if (reader == null) {
            StreamlinedBlobStorageOverLockFreePagedStorage.$$$reportNull$$$0(2);
        }
        this.checkRecordIdExists(recordId);
        int currentRecordId = recordId;
        int i = 0;
        while (i < 256) {
            long recordOffset = this.idToOffset(currentRecordId);
            try (PageUnsafe page = (PageUnsafe)this.pagedStorage.pageByOffset(recordOffset, false);){
                int offsetOnPage = this.pagedStorage.toOffsetInPage(recordOffset);
                page.lockPageForRead();
                try {
                    ByteBuffer buffer = page.rawPageBuffer();
                    RecordLayout recordLayout = RecordLayout.recordLayout(buffer, offsetOnPage);
                    byte recordType = recordLayout.recordType();
                    if (redirectToIdRef != null) {
                        redirectToIdRef.set(currentRecordId);
                    }
                    if (recordType == 0) {
                        int recordPayloadLength = recordLayout.length(buffer, offsetOnPage);
                        ByteBuffer slice = buffer.slice(offsetOnPage + recordLayout.headerSize(), recordPayloadLength).asReadOnlyBuffer().order(buffer.order());
                        Object object = reader.read(slice);
                        return (Out)object;
                    }
                    if (recordType != 64) throw new AssertionError((Object)("RecordType(" + recordType + ") should not appear in the chain: it is either not implemented yet, or all wrong"));
                    int redirectToId = recordLayout.redirectToId(buffer, offsetOnPage);
                    this.checkRedirectToId(recordId, currentRecordId, redirectToId);
                    currentRecordId = redirectToId;
                }
                finally {
                    page.unlockPageForRead();
                }
            }
            ++i;
        }
        throw new IOException("record[" + recordId + "].redirectTo chain is too long (>=256): circular reference?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int writeToRecord(int recordId, @NotNull ByteBufferWriter writer, int expectedRecordSizeHint, boolean leaveRedirectOnRecordRelocation) throws IOException {
        if (writer == null) {
            StreamlinedBlobStorageOverLockFreePagedStorage.$$$reportNull$$$0(3);
        }
        if (!StreamlinedBlobStorageOverLockFreePagedStorage.isValidRecordId(recordId)) {
            temp = this.acquireTemporaryBuffer(expectedRecordSizeHint);
            try {
                bufferWithData = writer.write(temp);
                bufferWithData.flip();
                recordLength = bufferWithData.limit();
                StreamlinedBlobStorageOverLockFreePagedStorage.checkLengthHardLimit(recordLength);
                if (recordLength > this.maxCapacityForPageSize) {
                    throw new IllegalStateException("recordLength(=" + recordLength + ") > maxCapacityForPageSize(=" + this.maxCapacityForPageSize + ") -- can't fit");
                }
                capacity = bufferWithData.capacity();
                requestedRecordCapacity = this.allocationStrategy.capacity(recordLength, capacity);
                if (requestedRecordCapacity < recordLength) {
                    throw new IllegalStateException("Allocation strategy " + String.valueOf(this.allocationStrategy) + "(" + recordLength + ", " + capacity + ") returns " + requestedRecordCapacity + " < length(=" + recordLength + ")");
                }
                var10_14 = this.writeToNewlyAllocatedRecord(bufferWithData, requestedRecordCapacity);
                return var10_14;
            }
            finally {
                this.releaseTemporaryBuffer(temp);
            }
        }
        currentRecordId = recordId;
        for (i = 0; i < 256; ++i) {
            recordOffset = this.idToOffset(currentRecordId);
            offsetOnPage = this.pagedStorage.toOffsetInPage(recordOffset);
            page = (PageUnsafe)this.pagedStorage.pageByOffset(recordOffset, true);
            try {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                page.lockPageForWrite();
                                try {
                                    buffer = page.rawPageBuffer();
                                    recordLayout = RecordLayout.recordLayout(buffer, offsetOnPage);
                                    recordType = recordLayout.recordType();
                                    if (recordType != 64) break block28;
                                    redirectToId = recordLayout.redirectToId(buffer, offsetOnPage);
                                    this.checkRedirectToId(recordId, currentRecordId, redirectToId);
                                    currentRecordId = redirectToId;
                                }
                                catch (Throwable var26_35) {
                                    page.unlockPageForWrite();
                                    throw var26_35;
                                }
                                page.unlockPageForWrite();
                                continue;
                            }
                            if (recordType != 0) {
                                throw new AssertionError((Object)("RecordType(" + recordType + ") should not appear in the chain: it is either not implemented yet, or all wrong"));
                            }
                            recordCapacity = recordLayout.capacity(buffer, offsetOnPage);
                            recordActualLength = recordLayout.length(buffer, offsetOnPage);
                            recordPayloadOffset = offsetOnPage + recordLayout.headerSize();
                            recordContent = buffer.slice(recordPayloadOffset, recordCapacity).limit(recordActualLength).order(buffer.order());
                            newRecordContent = writer.write(recordContent);
                            if (newRecordContent != null) break block29;
                            var19_27 = currentRecordId;
                            page.unlockPageForWrite();
                            return var19_27;
                        }
                        if (newRecordContent == recordContent) ** GOTO lbl93
                        newRecordContent.flip();
                        newRecordLength = newRecordContent.remaining();
                        if (newRecordLength <= recordCapacity) {
                            recordLayout.putRecord(buffer, offsetOnPage, recordCapacity, newRecordLength, 0, newRecordContent);
                            page.regionModified(offsetOnPage, recordLayout.headerSize() + newRecordLength);
                            this.totalLiveRecordsPayloadBytes.addAndGet(newRecordLength - recordActualLength);
                            break block30;
                        }
                        newRecordCapacity = this.allocationStrategy.capacity(newRecordLength, newRecordContent.capacity());
                        newRecordId = this.writeToNewlyAllocatedRecord(newRecordContent, newRecordCapacity);
                        movedRecordLayout = RecordLayout.MovedRecord.INSTANCE;
                        redirectToId = leaveRedirectOnRecordRelocation != false ? newRecordId : 0;
                        movedRecordCapacity = recordLayout.fullRecordSize(recordCapacity) - movedRecordLayout.headerSize();
                        movedRecordLayout.putRecord(buffer, offsetOnPage, movedRecordCapacity, 0, redirectToId, null);
                        page.regionModified(offsetOnPage, movedRecordLayout.headerSize());
                        this.totalLiveRecordsPayloadBytes.addAndGet(-recordActualLength);
                        this.totalLiveRecordsCapacityBytes.addAndGet(-recordCapacity);
                        if (leaveRedirectOnRecordRelocation) {
                            this.recordsRelocated.incrementAndGet();
                        } else {
                            this.recordsDeleted.incrementAndGet();
                        }
                        var25_34 = newRecordId;
                        page.unlockPageForWrite();
                        return var25_34;
                    }
                    break block31;
lbl93:
                    // 1 sources

                    recordContent.flip();
                    newRecordLength = recordContent.remaining();
                    if (!StreamlinedBlobStorageOverLockFreePagedStorage.$assertionsDisabled && newRecordLength > recordCapacity) {
                        throw new AssertionError((Object)(newRecordLength + " > " + recordCapacity + ": can't be, since recordContent.capacity()==recordCapacity!"));
                    }
                    recordLayout.putLength(buffer, offsetOnPage, newRecordLength);
                    page.regionModified(offsetOnPage, recordLayout.headerSize() + newRecordLength);
                    this.totalLiveRecordsPayloadBytes.addAndGet(newRecordLength - recordActualLength);
                }
                var19_28 = currentRecordId;
                page.unlockPageForWrite();
                return var19_28;
            }
            finally {
                if (page != null) {
                    page.close();
                }
            }
        }
        throw new IOException("record[" + recordId + "].redirectTo chain is too long (>=256): circular reference?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(int recordId) throws IOException {
        this.checkRecordIdExists(recordId);
        long recordOffset = this.idToOffset(recordId);
        try (PageUnsafe page = (PageUnsafe)this.pagedStorage.pageByOffset(recordOffset, true);){
            int offsetOnPage = this.pagedStorage.toOffsetInPage(recordOffset);
            page.lockPageForWrite();
            try {
                ByteBuffer buffer = page.rawPageBuffer();
                RecordLayout recordLayout = RecordLayout.recordLayout(buffer, offsetOnPage);
                int recordCapacity = recordLayout.capacity(buffer, offsetOnPage);
                int recordActualLength = recordLayout.length(buffer, offsetOnPage);
                byte recordType = recordLayout.recordType();
                switch (recordType) {
                    case 64: {
                        int redirectToId = recordLayout.redirectToId(buffer, offsetOnPage);
                        if (!StreamlinedBlobStorageOverLockFreePagedStorage.isValidRecordId(redirectToId)) {
                            throw new RecordAlreadyDeletedException("Can't delete record[" + recordId + "]: it was already deleted (wasClosedProperly: " + this.wasClosedProperly() + ")");
                        }
                        ((RecordLayout.MovedRecord)recordLayout).putRedirectTo(buffer, offsetOnPage, 0);
                        page.regionModified(offsetOnPage, recordLayout.headerSize());
                        break;
                    }
                    case 0: {
                        RecordLayout.MovedRecord movedRecordLayout = RecordLayout.MovedRecord.INSTANCE;
                        int deletedRecordCapacity = recordLayout.fullRecordSize(recordCapacity) - movedRecordLayout.headerSize();
                        movedRecordLayout.putRecord(buffer, offsetOnPage, deletedRecordCapacity, 0, 0, null);
                        page.regionModified(offsetOnPage, movedRecordLayout.headerSize());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("RecordType(" + recordType + ") should not appear in the chain: it is either not implemented yet, or all wrong"));
                    }
                }
                this.recordsDeleted.incrementAndGet();
                this.totalLiveRecordsPayloadBytes.addAndGet(-recordActualLength);
                this.totalLiveRecordsCapacityBytes.addAndGet(-recordCapacity);
            }
            finally {
                page.unlockPageForWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <E extends Exception> int forEach(@NotNull StreamlinedBlobStorage.Processor<E> processor) throws IOException, E {
        if (processor == null) {
            StreamlinedBlobStorageOverLockFreePagedStorage.$$$reportNull$$$0(4);
        }
        long storageLength = this.pagedStorage.length();
        int currentId = this.offsetToId(this.recordsStartOffset());
        int recordNo = 0;
        while (true) {
            long recordOffset = this.idToOffset(currentId);
            try (PageUnsafe page = (PageUnsafe)this.pagedStorage.pageByOffset(recordOffset, false);){
                int offsetOnPage = this.pagedStorage.toOffsetInPage(recordOffset);
                page.lockPageForRead();
                try {
                    ByteBuffer buffer = page.rawPageBuffer();
                    RecordLayout recordLayout = RecordLayout.recordLayout(buffer, offsetOnPage);
                    byte recordType = recordLayout.recordType();
                    int recordCapacity = recordLayout.capacity(buffer, offsetOnPage);
                    switch (recordType) {
                        case 0: 
                        case 64: {
                            int headerSize = recordLayout.headerSize();
                            boolean isActual = recordType == 0;
                            int recordActualLength = isActual ? recordLayout.length(buffer, offsetOnPage) : -1;
                            ByteBuffer slice = isActual ? buffer.slice(offsetOnPage + headerSize, recordActualLength).asReadOnlyBuffer().order(buffer.order()) : buffer.slice(offsetOnPage + headerSize, 0).asReadOnlyBuffer().order(buffer.order());
                            boolean ok = processor.processRecord(currentId, recordCapacity, recordActualLength, slice);
                            if (ok) break;
                            int n = recordNo + 1;
                            return n;
                        }
                    }
                    long nextRecordOffset = this.nextRecordOffset(recordOffset, recordLayout, recordCapacity);
                    if (nextRecordOffset >= storageLength) {
                        int n = recordNo;
                        return n;
                    }
                    currentId = this.offsetToId(nextRecordOffset);
                }
                finally {
                    page.unlockPageForRead();
                }
            }
            ++recordNo;
        }
    }

    public long sizeInBytes() throws ClosedStorageException {
        this.checkNotClosed();
        return this.pagedStorage.length();
    }

    public boolean isDirty() {
        return this.pagedStorage.isDirty();
    }

    public void force() throws IOException {
        this.checkNotClosed();
        try (Page headerPage = this.pagedStorage.pageByIndex(0, true);){
            headerPage.lockPageForWrite();
            try {
                this.putHeaderInt(16, this.nextRecordId());
                this.putHeaderInt(20, this.recordsAllocated.get());
                this.putHeaderInt(24, this.recordsRelocated.get());
                this.putHeaderInt(28, this.recordsDeleted.get());
                this.putHeaderLong(32, this.totalLiveRecordsPayloadBytes.get());
                this.putHeaderLong(40, this.totalLiveRecordsCapacityBytes.get());
            }
            finally {
                headerPage.unlockPageForWrite();
            }
        }
        this.pagedStorage.force();
    }

    public void close() throws IOException {
        if (!this.closed.get()) {
            this.putHeaderInt(12, 1);
            this.force();
            this.closed.set(true);
            this.openTelemetryCallback.close();
            this.pagedStorage.close();
        }
    }

    @Override
    @NotNull
    protected Path storagePath() {
        Path path = this.pagedStorage.getFile();
        if (path == null) {
            StreamlinedBlobStorageOverLockFreePagedStorage.$$$reportNull$$$0(5);
        }
        return path;
    }

    private int readHeaderInt(int offset) throws IOException {
        assert (0 <= offset && offset <= 60) : "header offset(=" + offset + ") must be in [0,60]";
        return this.pagedStorage.getInt((long)offset);
    }

    private void putHeaderInt(int offset, int value) throws IOException {
        assert (0 <= offset && offset <= 60) : "header offset(=" + offset + ") must be in [0,60]";
        this.pagedStorage.putInt((long)offset, value);
    }

    private long readHeaderLong(int offset) throws IOException {
        assert (0 <= offset && offset <= 56) : "header offset(=" + offset + ") must be in [0,56]";
        return this.pagedStorage.getLong((long)offset);
    }

    private void putHeaderLong(int offset, long value) throws IOException {
        assert (0 <= offset && offset <= 56) : "header offset(=" + offset + ") must be in [0,56]";
        this.pagedStorage.putLong((long)offset, value);
    }

    private int writeToNewlyAllocatedRecord(ByteBuffer content, int requestedRecordCapacity) throws IOException {
        int pageSize = this.pagedStorage.getPageSize();
        int recordLength = content.limit();
        if (recordLength > this.maxCapacityForPageSize) {
            throw new IllegalStateException("recordLength(=" + recordLength + ") > maxCapacityForPageSize(=" + this.maxCapacityForPageSize + ") -- can't fit");
        }
        int implementableCapacity = Math.min(requestedRecordCapacity, this.maxCapacityForPageSize);
        StreamlinedBlobStorageOverLockFreePagedStorage.checkCapacityHardLimit(implementableCapacity);
        byte recordSizeType = RecordLayout.ActualRecords.recordSizeTypeByCapacity(implementableCapacity);
        RecordLayout recordLayout = RecordLayout.ActualRecords.recordLayoutForType(recordSizeType);
        int fullRecordSize = recordLayout.fullRecordSize(implementableCapacity);
        if (fullRecordSize > pageSize) {
            throw new IllegalArgumentException("record size(header:" + recordLayout.headerSize() + " + capacity:" + implementableCapacity + ") should be <= pageSize(=" + pageSize + ")");
        }
        IntRef actualRecordSizeRef = new IntRef();
        int newRecordId = this.allocateSlotForRecord(pageSize, fullRecordSize, actualRecordSizeRef);
        long newRecordOffset = this.idToOffset(newRecordId);
        int actualRecordSize = actualRecordSizeRef.get();
        int actualRecordCapacity = actualRecordSize - recordLayout.headerSize();
        int newRecordLength = content.remaining();
        StreamlinedBlobStorageOverLockFreePagedStorage.checkCapacityHardLimit(actualRecordCapacity);
        StreamlinedBlobStorageOverLockFreePagedStorage.checkLengthHardLimit(newRecordLength);
        int offsetOnPage = this.pagedStorage.toOffsetInPage(newRecordOffset);
        try {
            int n;
            block11: {
                Page page = this.pagedStorage.pageByOffset(newRecordOffset, true);
                try {
                    page.write(offsetOnPage, actualRecordSize, buffer -> {
                        recordLayout.putRecord((ByteBuffer)buffer, offsetOnPage, actualRecordCapacity, newRecordLength, 0, content);
                        return buffer;
                    });
                    n = newRecordId;
                    if (page == null) break block11;
                }
                catch (Throwable throwable) {
                    if (page != null) {
                        try {
                            page.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                page.close();
            }
            return n;
        }
        finally {
            this.recordsAllocated.incrementAndGet();
            this.totalLiveRecordsCapacityBytes.addAndGet(actualRecordCapacity);
            this.totalLiveRecordsPayloadBytes.addAndGet(newRecordLength);
        }
    }

    @Override
    protected void putSpaceFillerRecord(long recordOffset, int pageSize) throws IOException {
        RecordLayout.PaddingRecord paddingRecord = RecordLayout.PaddingRecord.INSTANCE;
        int offsetInPage = this.pagedStorage.toOffsetInPage(recordOffset);
        int remainingOnPage = pageSize - offsetInPage;
        try (Page page = this.pagedStorage.pageByOffset(recordOffset, true);){
            page.write(offsetInPage, paddingRecord.headerSize(), buffer -> {
                int capacity = remainingOnPage - paddingRecord.headerSize();
                paddingRecord.putRecord((ByteBuffer)buffer, offsetInPage, capacity, 0, 0, null);
                return buffer;
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pagedStorage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocationStrategy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/util/io/storages/blobstorage/StreamlinedBlobStorageOverLockFreePagedStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/util/io/storages/blobstorage/StreamlinedBlobStorageOverLockFreePagedStorage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "storagePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readRecord";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeToRecord";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

