/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.durablemap.dev;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.platform.util.io.storages.DataExternalizerEx;
import com.intellij.platform.util.io.storages.KeyDescriptorEx;
import com.intellij.platform.util.io.storages.appendonlylog.dev.ChunkedAppendOnlyLog;
import com.intellij.platform.util.io.storages.durablemap.Compactable;
import com.intellij.platform.util.io.storages.durablemap.DurableMap;
import com.intellij.platform.util.io.storages.durablemap.dev.AppendableDurableMap;
import com.intellij.platform.util.io.storages.intmultimaps.HashUtils;
import com.intellij.platform.util.io.storages.intmultimaps.extendiblehashmap.ExtendibleHashMap;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.Unmappable;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DurableMapWithAppendableValues<K, VItem>
implements AppendableDurableMap<K, VItem>,
Unmappable {
    private final ChunkedAppendOnlyLog keyValuesLog;
    private final ExtendibleHashMap keyHashToChunkIdMap;
    private final KeyDescriptorEx<K> keyDescriptor;
    private final KeyDescriptorEx<VItem> valueDescriptor;

    public DurableMapWithAppendableValues(@NotNull ChunkedAppendOnlyLog keyValuesLog, @NotNull ExtendibleHashMap keyHashToChunkIdMap, @NotNull KeyDescriptorEx<K> keyDescriptor, @NotNull KeyDescriptorEx<VItem> valueDescriptor) {
        if (keyValuesLog == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(0);
        }
        if (keyHashToChunkIdMap == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(1);
        }
        if (keyDescriptor == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(2);
        }
        if (valueDescriptor == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(3);
        }
        this.keyValuesLog = keyValuesLog;
        this.keyHashToChunkIdMap = keyHashToChunkIdMap;
        this.keyDescriptor = keyDescriptor;
        this.valueDescriptor = valueDescriptor;
    }

    @Override
    public Set<VItem> get(@NotNull K key) throws IOException {
        AppendableDurableMap.Items<VItem> items;
        if (key == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(4);
        }
        if ((items = this.items(key)) == null) {
            return null;
        }
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        items.forEach(item -> result.add(item));
        return result;
    }

    @Override
    public AppendableDurableMap.Items<VItem> items(@NotNull K key) throws IOException {
        if (key == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(5);
        }
        int keyHash = this.keyDescriptor.getHashCode(key);
        int adjustedHash = HashUtils.adjustHash(keyHash);
        Ref resultRef = new Ref();
        this.keyHashToChunkIdMap.lookup(adjustedHash, candidateId -> {
            long candidateChunkId = DurableMapWithAppendableValues.convertStoredIdToChunkId(candidateId);
            Pair<Object, ItemsImpl> entry = this.readEntryIfKeyMatch(candidateChunkId, key);
            if (entry == null) {
                return false;
            }
            resultRef.set(entry);
            return true;
        });
        Pair entry = (Pair)resultRef.get();
        if (entry == null) {
            return null;
        }
        return (AppendableDurableMap.Items)entry.second;
    }

    @Override
    public boolean containsMapping(@NotNull K key) throws IOException {
        int foundRecordId;
        if (key == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(6);
        }
        return (foundRecordId = this.lookupRecordId(key)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@NotNull K key, @Nullable Set<VItem> values) throws IOException {
        if (key == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(7);
        }
        int keyHash = this.keyDescriptor.getHashCode(key);
        int adjustedKeyHash = HashUtils.adjustHash(keyHash);
        DataExternalizerEx.KnownSizeRecordWriter keyWriter = this.keyDescriptor.writerFor(key);
        int keySize = keyWriter.recordSize();
        int keyRecordSize = keySize + 4;
        if (values == null) {
            ChunkedAppendOnlyLog.LogChunk chunk = this.keyValuesLog.append(keyRecordSize, false);
            chunk.append(buffer -> {
                DurableMapWithAppendableValues.putHeader(buffer, keySize, true);
                return keyWriter.write(buffer.slice(4, keySize).order(buffer.order()));
            }, keyRecordSize);
            ExtendibleHashMap extendibleHashMap = this.keyHashToChunkIdMap;
            synchronized (extendibleHashMap) {
                int foundRecordId = this.lookupRecordId(key, adjustedKeyHash);
                if (foundRecordId != 0) {
                    this.keyHashToChunkIdMap.remove(adjustedKeyHash, foundRecordId);
                }
            }
            return;
        }
        int chunkSize = Math.max(keyRecordSize, 512);
        ChunkedAppendOnlyLog.LogChunk chunk = this.keyValuesLog.append(chunkSize, true);
        chunk.append(buffer -> {
            DurableMapWithAppendableValues.putHeader(buffer, keySize, false);
            return keyWriter.write(buffer.slice(4, keySize).order(buffer.order()));
        }, keyRecordSize);
        ItemsImpl items = new ItemsImpl(chunk);
        for (VItem item : values) {
            items.append(item);
        }
        int newRecordId = DurableMapWithAppendableValues.convertChunkIdToStoredId(chunk.id());
        ExtendibleHashMap extendibleHashMap = this.keyHashToChunkIdMap;
        synchronized (extendibleHashMap) {
            int foundRecordId = this.lookupRecordId(key, adjustedKeyHash);
            if (foundRecordId != 0) {
                this.keyHashToChunkIdMap.replace(adjustedKeyHash, foundRecordId, newRecordId);
            } else {
                this.keyHashToChunkIdMap.put(adjustedKeyHash, newRecordId);
            }
        }
    }

    @Override
    public void remove(@NotNull K key) throws IOException {
        if (key == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(8);
        }
        this.put(key, null);
    }

    @Override
    public boolean processKeys(@NotNull Processor<? super K> processor) throws IOException {
        if (processor == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(9);
        }
        return this.forEachEntry((BiPredicate<? super K, ? super Set<VItem>>)((BiPredicate<Object, Set>)(key, value) -> processor.process(key)));
    }

    @Override
    public boolean forEachEntry(@NotNull BiPredicate<? super K, ? super Set<VItem>> processor) throws IOException {
        if (processor == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(10);
        }
        return this.forEach((key, items) -> {
            try {
                ObjectOpenHashSet values = new ObjectOpenHashSet();
                items.forEach(item -> values.add(item));
                return processor.test((Object)key, (Object)values);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public boolean forEach(@NotNull BiPredicate<? super K, AppendableDurableMap.Items<VItem>> processor) throws IOException {
        if (processor == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(11);
        }
        return this.keyHashToChunkIdMap.forEach((int keyHash, int recordId) -> {
            Pair<K, ItemsImpl> entry = this.readEntry(DurableMapWithAppendableValues.convertStoredIdToChunkId(recordId));
            Object key = entry.first;
            ItemsImpl value = (ItemsImpl)entry.second;
            if (value != null) {
                return processor.test((K)key, value);
            }
            return true;
        });
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.keyHashToChunkIdMap.isEmpty();
    }

    @Override
    public int size() throws IOException {
        return this.keyHashToChunkIdMap.size();
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void force() throws IOException {
        this.keyValuesLog.flush();
        this.keyHashToChunkIdMap.flush();
    }

    @Override
    @NotNull
    public Compactable.CompactionScore compactionScore() throws IOException {
        throw new UnsupportedOperationException("Method is not implemented yet");
    }

    @Override
    @NotNull
    public <C1 extends DurableMap<K, Set<VItem>>> C1 compact(@NotNull ThrowableComputable<C1, ? extends IOException> compactedMapFactory) throws IOException {
        if (compactedMapFactory == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException("Method is not implemented yet");
    }

    @Override
    public boolean isClosed() {
        return this.keyHashToChunkIdMap.isClosed();
    }

    @Override
    public void close() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[2];
        throwableRunnableArray[0] = this.keyValuesLog::close;
        throwableRunnableArray[1] = this.keyHashToChunkIdMap::close;
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't close " + String.valueOf(this.keyValuesLog) + "/" + String.valueOf(this.keyHashToChunkIdMap)), (ThrowableRunnable[])throwableRunnableArray);
    }

    public void closeAndUnsafelyUnmap() throws IOException {
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't unmap " + String.valueOf(this.keyValuesLog) + "/" + String.valueOf(this.keyHashToChunkIdMap)), (ThrowableRunnable[])new ThrowableRunnable[]{() -> {
            ChunkedAppendOnlyLog patt0$temp = this.keyValuesLog;
            if (patt0$temp instanceof Unmappable) {
                Unmappable unmappable = (Unmappable)patt0$temp;
                unmappable.closeAndUnsafelyUnmap();
            } else {
                this.keyValuesLog.close();
            }
        }, () -> this.keyHashToChunkIdMap.closeAndUnsafelyUnmap()});
    }

    public void closeAndClean() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[2];
        throwableRunnableArray[0] = () -> ((ChunkedAppendOnlyLog)this.keyValuesLog).closeAndClean();
        throwableRunnableArray[1] = this.keyHashToChunkIdMap::closeAndClean;
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't closeAndClean " + String.valueOf(this.keyValuesLog) + "/" + String.valueOf(this.keyHashToChunkIdMap)), (ThrowableRunnable[])throwableRunnableArray);
    }

    private static int convertChunkIdToStoredId(long logChunkId) {
        int storeId = (int)logChunkId;
        if ((long)storeId != logChunkId) {
            throw new IllegalStateException("logChunkId(=" + logChunkId + ") doesn't fit into int32");
        }
        return storeId;
    }

    private static long convertStoredIdToChunkId(int storedRecordId) {
        return storedRecordId;
    }

    private int lookupRecordId(@NotNull K key) throws IOException {
        if (key == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(13);
        }
        int keyHash = this.keyDescriptor.getHashCode(key);
        int adjustedHash = HashUtils.adjustHash(keyHash);
        return this.lookupRecordId(key, adjustedHash);
    }

    private int lookupRecordId(@NotNull K key, int adjustedKeyHash) throws IOException {
        if (key == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(14);
        }
        return this.keyHashToChunkIdMap.lookup(adjustedKeyHash, recordId -> {
            long logChunkId = DurableMapWithAppendableValues.convertStoredIdToChunkId(recordId);
            ChunkedAppendOnlyLog.LogChunk chunk = this.keyValuesLog.read(logChunkId);
            ByteBuffer recordBuffer = chunk.read();
            int header = recordBuffer.getInt(0);
            if (DurableMapWithAppendableValues.isValueAbsent(header)) {
                return false;
            }
            int keyRecordSize = DurableMapWithAppendableValues.keySize(header);
            ByteBuffer keyRecordSlice = recordBuffer.slice(4, keyRecordSize);
            Object candidateKey = this.keyDescriptor.read(keyRecordSlice);
            return this.keyDescriptor.isEqual(key, candidateKey);
        });
    }

    private Pair<K, ItemsImpl> readEntry(long logChunkId) throws IOException {
        ChunkedAppendOnlyLog.LogChunk chunk = this.keyValuesLog.read(logChunkId);
        ByteBuffer chunkBuffer = chunk.read();
        int header = DurableMapWithAppendableValues.readHeader(chunkBuffer);
        int keyRecordSize = DurableMapWithAppendableValues.keySize(header);
        boolean valueIsAbsent = DurableMapWithAppendableValues.isValueAbsent(header);
        ByteBuffer keyRecordSlice = chunkBuffer.slice(4, keyRecordSize).order(chunkBuffer.order());
        Object key = this.keyDescriptor.read(keyRecordSlice);
        if (valueIsAbsent) {
            return Pair.pair((Object)key, null);
        }
        return Pair.pair((Object)key, (Object)new ItemsImpl(chunk));
    }

    /*
     * WARNING - void declaration
     */
    private Pair<K, ItemsImpl> readEntryIfKeyMatch(long logChunkId, @NotNull K k) throws IOException {
        void expectedKey;
        if (k == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(15);
        }
        ChunkedAppendOnlyLog.LogChunk chunk = this.keyValuesLog.read(logChunkId);
        ByteBuffer chunkBuffer = chunk.read();
        int header = DurableMapWithAppendableValues.readHeader(chunkBuffer);
        int keyRecordSize = DurableMapWithAppendableValues.keySize(header);
        boolean valueIsAbsent = DurableMapWithAppendableValues.isValueAbsent(header);
        ByteBuffer keyRecordSlice = chunkBuffer.slice(4, keyRecordSize).order(chunkBuffer.order());
        Object candidateKey = this.keyDescriptor.read(keyRecordSlice);
        if (!this.keyDescriptor.isEqual(expectedKey, candidateKey)) {
            return null;
        }
        if (valueIsAbsent) {
            return Pair.pair((Object)expectedKey, null);
        }
        return Pair.pair((Object)expectedKey, (Object)new ItemsImpl(chunk));
    }

    private static int readHeader(@NotNull ByteBuffer keyBuffer) {
        if (keyBuffer == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(16);
        }
        return keyBuffer.getInt(0);
    }

    private static void putHeader(@NotNull ByteBuffer keyBuffer, int keySize, boolean valueEmpty) {
        if (keyBuffer == null) {
            DurableMapWithAppendableValues.$$$reportNull$$$0(17);
        }
        if (keySize < 0) {
            throw new IllegalArgumentException("keySize(=" + keySize + ") must have highest bit 0");
        }
        if (valueEmpty) {
            int highestBitMask = 32768;
            keyBuffer.putInt(0, keySize | highestBitMask);
        } else {
            keyBuffer.putInt(0, keySize);
        }
    }

    private static int keySize(int header) {
        int highestBitMask = 32768;
        return header & ~highestBitMask;
    }

    private static boolean isValueAbsent(int header) {
        int highestBitMask = 32768;
        return (header & highestBitMask) != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValuesLog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyHashToChunkIdMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compactedMapFactory";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedKey";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyBuffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/util/io/storages/durablemap/dev/DurableMapWithAppendableValues";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "items";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "containsMapping";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processKeys";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachEntry";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "forEach";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "compact";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupRecordId";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "readEntryIfKeyMatch";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "readHeader";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "putHeader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ItemsImpl
    implements AppendableDurableMap.Items<VItem> {
        private final ChunkedAppendOnlyLog.LogChunk startingChunk;
        private ChunkedAppendOnlyLog.LogChunk lastChunk;

        private ItemsImpl(ChunkedAppendOnlyLog.LogChunk startingChunk) {
            if (startingChunk == null) {
                ItemsImpl.$$$reportNull$$$0(0);
            }
            this.startingChunk = startingChunk;
            this.lastChunk = startingChunk;
        }

        @Override
        public void append(@NotNull VItem item) throws IOException {
            if (item == null) {
                ItemsImpl.$$$reportNull$$$0(1);
            }
            DataExternalizerEx.KnownSizeRecordWriter writer = DurableMapWithAppendableValues.this.valueDescriptor.writerFor(item);
            int valueSize = writer.recordSize();
            this.appendImpl(item, valueSize, writer);
        }

        private void appendImpl(@NotNull VItem item, int valueSize, @NotNull DataExternalizerEx.KnownSizeRecordWriter writer) throws IOException {
            if (item == null) {
                ItemsImpl.$$$reportNull$$$0(2);
            }
            if (writer == null) {
                ItemsImpl.$$$reportNull$$$0(3);
            }
            this.maybeAdvanceLastChunk();
            int totalRecordSize = valueSize + 4;
            boolean appended = this.lastChunk.append(buffer -> {
                buffer.putInt(valueSize);
                return writer.write(buffer);
            }, totalRecordSize);
            if (!appended) {
                ChunkedAppendOnlyLog.LogChunk nextChunk = DurableMapWithAppendableValues.this.keyValuesLog.append(this.lastChunk.capacity(), true);
                boolean succeed = this.lastChunk.nextChunkId(nextChunk.id());
                if (!succeed) {
                    throw new IllegalStateException("FIXME: ...");
                }
                this.lastChunk = nextChunk;
                this.append(item);
            }
        }

        private void maybeAdvanceLastChunk() throws IOException {
            long nextChunkId;
            while ((nextChunkId = this.lastChunk.nextChunkId()) != 0L) {
                this.lastChunk = DurableMapWithAppendableValues.this.keyValuesLog.read(nextChunkId);
            }
            return;
        }

        @Override
        public void remove(@NotNull VItem item) throws IOException {
            if (item == null) {
                ItemsImpl.$$$reportNull$$$0(4);
            }
            throw new UnsupportedOperationException("Method is not implemented yet");
        }

        @Override
        public <E extends Throwable> boolean forEach(@NotNull ThrowableConsumer<? super VItem, E> consumer) throws IOException, E {
            ByteBuffer buffer;
            int header;
            if (consumer == null) {
                ItemsImpl.$$$reportNull$$$0(5);
            }
            if (DurableMapWithAppendableValues.isValueAbsent(header = (buffer = this.startingChunk.read()).getInt())) {
                return true;
            }
            int keySize = DurableMapWithAppendableValues.keySize(header);
            buffer.position(4 + keySize);
            while (buffer.hasRemaining()) {
                int valueSize = buffer.getInt();
                Object item = DurableMapWithAppendableValues.this.valueDescriptor.read(buffer.slice(buffer.position(), valueSize).order(buffer.order()));
                consumer.consume(item);
                buffer.position(buffer.position() + valueSize);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startingChunk";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "writer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/util/io/storages/durablemap/dev/DurableMapWithAppendableValues$ItemsImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "append";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remove";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "forEach";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

