/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.enumerator;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.platform.util.io.storages.DataExternalizerEx;
import com.intellij.platform.util.io.storages.KeyDescriptorEx;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLog;
import com.intellij.platform.util.io.storages.intmultimaps.DurableIntToMultiIntMap;
import com.intellij.platform.util.io.storages.intmultimaps.HashUtils;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.CleanableStorage;
import com.intellij.util.io.DurableDataEnumerator;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import com.intellij.util.io.Unmappable;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DurableEnumerator<V>
implements DurableDataEnumerator<V>,
ScannableDataEnumeratorEx<V>,
CleanableStorage,
Unmappable {
    public static final int DATA_FORMAT_VERSION = 1;
    @NotNull
    private final AppendOnlyLog valuesLog;
    @NotNull
    private final KeyDescriptorEx<V> valueDescriptor;
    @NotNull
    private final DurableIntToMultiIntMap valueHashToId;

    public DurableEnumerator(@NotNull KeyDescriptorEx<V> valueDescriptor, @NotNull AppendOnlyLog valuesLog, @NotNull ThrowableComputable<DurableIntToMultiIntMap, IOException> mapFactory) throws IOException {
        if (valueDescriptor == null) {
            DurableEnumerator.$$$reportNull$$$0(0);
        }
        if (valuesLog == null) {
            DurableEnumerator.$$$reportNull$$$0(1);
        }
        if (mapFactory == null) {
            DurableEnumerator.$$$reportNull$$$0(2);
        }
        this.valueDescriptor = valueDescriptor;
        this.valuesLog = valuesLog;
        this.valueHashToId = (DurableIntToMultiIntMap)mapFactory.compute();
    }

    public boolean isDirty() {
        return false;
    }

    public void force() throws IOException {
        this.valuesLog.flush();
        this.valueHashToId.flush();
    }

    public void close() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[2];
        throwableRunnableArray[0] = this.valuesLog::close;
        throwableRunnableArray[1] = this.valueHashToId::close;
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't close " + String.valueOf(this.valuesLog) + "/" + String.valueOf(this.valueHashToId)), (ThrowableRunnable[])throwableRunnableArray);
    }

    public void closeAndUnsafelyUnmap() throws IOException {
        this.close();
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't .closeAndUnsafelyUnmap() " + String.valueOf(this.valuesLog) + "/" + String.valueOf(this.valueHashToId)), (ThrowableRunnable[])new ThrowableRunnable[]{() -> {
            if (this.valuesLog instanceof Unmappable) {
                ((Unmappable)this.valuesLog).closeAndUnsafelyUnmap();
            }
        }, () -> {
            if (this.valueHashToId instanceof Unmappable) {
                ((Unmappable)this.valueHashToId).closeAndUnsafelyUnmap();
            }
        }});
    }

    public void closeAndClean() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[2];
        throwableRunnableArray[0] = () -> ((AppendOnlyLog)this.valuesLog).closeAndClean();
        throwableRunnableArray[1] = () -> ((DurableIntToMultiIntMap)this.valueHashToId).closeAndClean();
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't closeAndClean " + String.valueOf(this.valuesLog) + "/" + String.valueOf(this.valueHashToId)), (ThrowableRunnable[])throwableRunnableArray);
    }

    public int enumerate(@Nullable V value) throws IOException {
        if (value == null) {
            return 0;
        }
        return this.lookupOrCreateIdForValue(value);
    }

    public int tryEnumerate(@Nullable V value) throws IOException {
        if (value == null) {
            return 0;
        }
        return this.lookupIdForValue(value);
    }

    @Nullable
    public V valueOf(int valueId) throws IOException {
        if (valueId == 0) {
            return null;
        }
        return (V)this.valuesLog.read(valueId, this.valueDescriptor::read);
    }

    public boolean forEach(@NotNull ScannableDataEnumeratorEx.ValueReader<? super V> reader) throws IOException {
        if (reader == null) {
            DurableEnumerator.$$$reportNull$$$0(3);
        }
        return this.valuesLog.forEachRecord((recordId, buffer) -> {
            int valueId = DurableEnumerator.convertLogIdToEnumeratorId(recordId);
            Object value = this.valueDescriptor.read(buffer);
            return reader.read(valueId, value);
        });
    }

    public int recordsCount() throws IOException {
        return this.valueHashToId.size();
    }

    public String toString() {
        return "DurableEnumerator[log: " + String.valueOf(this.valuesLog) + ", hashToId: " + String.valueOf(this.valueHashToId) + ", descriptor=" + String.valueOf(this.valueDescriptor) + "]";
    }

    private static int convertLogIdToEnumeratorId(long logRecordId) {
        return Math.toIntExact(logRecordId);
    }

    private int lookupIdForValue(@NotNull V value) throws IOException {
        if (value == null) {
            DurableEnumerator.$$$reportNull$$$0(4);
        }
        int hash = this.valueDescriptor.getHashCode(value);
        int valueHash = HashUtils.adjustHash(hash);
        return this.valueHashToId.lookup(valueHash, candidateId -> {
            Object candidateKey = this.valuesLog.read(candidateId, this.valueDescriptor::read);
            return this.valueDescriptor.isEqual(candidateKey, value);
        });
    }

    private int lookupOrCreateIdForValue(@NotNull V value) throws IOException {
        if (value == null) {
            DurableEnumerator.$$$reportNull$$$0(5);
        }
        int hash = this.valueDescriptor.getHashCode(value);
        int valueHash = HashUtils.adjustHash(hash);
        return this.valueHashToId.lookupOrInsert(valueHash, candidateId -> {
            Object candidateValue = this.valuesLog.read(candidateId, this.valueDescriptor::read);
            return this.valueDescriptor.isEqual(candidateValue, value);
        }, _valueHash_ -> {
            DataExternalizerEx.KnownSizeRecordWriter writer = this.valueDescriptor.writerFor(value);
            long logRecordId = this.valuesLog.append(writer, writer.recordSize());
            return DurableEnumerator.convertLogIdToEnumeratorId(logRecordId);
        });
    }

    @NotNull
    static <K> DurableIntToMultiIntMap fillValueHashToIdMap(@NotNull AppendOnlyLog valuesLog, @NotNull KeyDescriptorEx<K> valueDescriptor, @NotNull DurableIntToMultiIntMap valueHashToId) throws IOException {
        if (valuesLog == null) {
            DurableEnumerator.$$$reportNull$$$0(6);
        }
        if (valueDescriptor == null) {
            DurableEnumerator.$$$reportNull$$$0(7);
        }
        if (valueHashToId == null) {
            DurableEnumerator.$$$reportNull$$$0(8);
        }
        valuesLog.forEachRecord((logId, buffer) -> {
            Object value = valueDescriptor.read(buffer);
            int hash = valueDescriptor.getHashCode(value);
            int valueHash = HashUtils.adjustHash(hash);
            int id = DurableEnumerator.convertLogIdToEnumeratorId(logId);
            valueHashToId.put(valueHash, id);
            return true;
        });
        DurableIntToMultiIntMap durableIntToMultiIntMap = valueHashToId;
        if (durableIntToMultiIntMap == null) {
            DurableEnumerator.$$$reportNull$$$0(9);
        }
        return durableIntToMultiIntMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesLog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueHashToId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/util/io/storages/enumerator/DurableEnumerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/util/io/storages/enumerator/DurableEnumerator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fillValueHashToIdMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lookupIdForValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lookupOrCreateIdForValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillValueHashToIdMap";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

