/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.enumerator;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.platform.util.io.storages.KeyDescriptorEx;
import com.intellij.platform.util.io.storages.StorageFactory;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLog;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLogFactory;
import com.intellij.platform.util.io.storages.enumerator.DurableEnumerator;
import com.intellij.platform.util.io.storages.intmultimaps.DurableIntToMultiIntMap;
import com.intellij.platform.util.io.storages.intmultimaps.NonDurableNonParallelIntToMultiIntMap;
import com.intellij.platform.util.io.storages.intmultimaps.extendiblehashmap.ExtendibleMapFactory;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class DurableEnumeratorFactory<V>
implements StorageFactory<DurableEnumerator<V>> {
    private static final Logger LOG = Logger.getInstance(DurableEnumeratorFactory.class);
    public static final int DEFAULT_PAGE_SIZE = 0x800000;
    public static final StorageFactory<DurableIntToMultiIntMap> DEFAULT_IN_MEMORY_MAP_FACTORY = storagePath -> new NonDurableNonParallelIntToMultiIntMap();
    public static final StorageFactory<? extends AppendOnlyLog> DEFAULT_VALUES_LOG_FACTORY = AppendOnlyLogFactory.withDefaults().pageSize(0x800000).cleanIfFileIncompatible().failIfDataFormatVersionNotMatch(1);
    public static final StorageFactory<? extends DurableIntToMultiIntMap> DEFAULT_DURABLE_MAP_FACTORY = ExtendibleMapFactory.mediumSize().cleanIfFileIncompatible().ifNotClosedProperly(ExtendibleMapFactory.NotClosedProperlyAction.DROP_AND_CREATE_EMPTY_MAP);
    public static final String MAP_FILE_SUFFIX = ".hashToId";
    @NotNull
    private final KeyDescriptorEx<V> valueDescriptor;
    @NotNull
    private final StorageFactory<? extends AppendOnlyLog> valuesLogFactory;
    @NotNull
    private final StorageFactory<? extends DurableIntToMultiIntMap> valueHashToIdFactory;
    @NotNull
    private final String mapFileSuffix;
    private final boolean rebuildMapFromLogIfInconsistent;

    private DurableEnumeratorFactory(@NotNull KeyDescriptorEx<V> valueDescriptor, @NotNull StorageFactory<? extends AppendOnlyLog> valuesLogFactory, @NotNull StorageFactory<? extends DurableIntToMultiIntMap> valueHashToIdFactory, boolean rebuildMapFromLogIfInconsistent, @NotNull String mapFileSuffix) {
        if (valueDescriptor == null) {
            DurableEnumeratorFactory.$$$reportNull$$$0(0);
        }
        if (valuesLogFactory == null) {
            DurableEnumeratorFactory.$$$reportNull$$$0(1);
        }
        if (valueHashToIdFactory == null) {
            DurableEnumeratorFactory.$$$reportNull$$$0(2);
        }
        if (mapFileSuffix == null) {
            DurableEnumeratorFactory.$$$reportNull$$$0(3);
        }
        this.valueDescriptor = valueDescriptor;
        this.valuesLogFactory = valuesLogFactory;
        this.valueHashToIdFactory = valueHashToIdFactory;
        this.rebuildMapFromLogIfInconsistent = rebuildMapFromLogIfInconsistent;
        this.mapFileSuffix = mapFileSuffix;
    }

    public static <V> DurableEnumeratorFactory<V> defaultWithDurableMap(@NotNull KeyDescriptorEx<V> valueDescriptor) {
        if (valueDescriptor == null) {
            DurableEnumeratorFactory.$$$reportNull$$$0(4);
        }
        return new DurableEnumeratorFactory<V>(valueDescriptor, DEFAULT_VALUES_LOG_FACTORY, DEFAULT_DURABLE_MAP_FACTORY, true, MAP_FILE_SUFFIX);
    }

    public static <V> DurableEnumeratorFactory<V> defaultWithInMemoryMap(@NotNull KeyDescriptorEx<V> valueDescriptor) {
        if (valueDescriptor == null) {
            DurableEnumeratorFactory.$$$reportNull$$$0(5);
        }
        return new DurableEnumeratorFactory<V>(valueDescriptor, DEFAULT_VALUES_LOG_FACTORY, DEFAULT_IN_MEMORY_MAP_FACTORY, true, MAP_FILE_SUFFIX);
    }

    public DurableEnumeratorFactory<V> valuesLogFactory(@NotNull StorageFactory<? extends AppendOnlyLog> valuesLogFactory) {
        if (valuesLogFactory == null) {
            DurableEnumeratorFactory.$$$reportNull$$$0(6);
        }
        return new DurableEnumeratorFactory<V>(this.valueDescriptor, valuesLogFactory, this.valueHashToIdFactory, this.rebuildMapFromLogIfInconsistent, this.mapFileSuffix);
    }

    public DurableEnumeratorFactory<V> mapFactory(@NotNull StorageFactory<? extends DurableIntToMultiIntMap> valueHashToIdFactory) {
        if (valueHashToIdFactory == null) {
            DurableEnumeratorFactory.$$$reportNull$$$0(7);
        }
        return new DurableEnumeratorFactory<V>(this.valueDescriptor, this.valuesLogFactory, valueHashToIdFactory, this.rebuildMapFromLogIfInconsistent, this.mapFileSuffix);
    }

    public DurableEnumeratorFactory<V> rebuildMapIfInconsistent(boolean rebuildMapFromLogIfInconsistent) {
        return new DurableEnumeratorFactory<V>(this.valueDescriptor, this.valuesLogFactory, this.valueHashToIdFactory, rebuildMapFromLogIfInconsistent, this.mapFileSuffix);
    }

    @Override
    @NotNull
    public DurableEnumerator<V> open(@NotNull Path storagePath) throws IOException {
        if (storagePath == null) {
            DurableEnumeratorFactory.$$$reportNull$$$0(8);
        }
        String name = storagePath.getFileName().toString();
        Path hashToIdPath = storagePath.resolveSibling(name + this.mapFileSuffix);
        DurableEnumerator durableEnumerator = (DurableEnumerator)this.valuesLogFactory.wrapStorageSafely(storagePath, valuesLog -> (DurableEnumerator)this.valueHashToIdFactory.wrapStorageSafely(hashToIdPath, valueHashToId -> {
            if (this.rebuildMapFromLogIfInconsistent && !valuesLog.isEmpty() && valueHashToId.isEmpty()) {
                boolean mapIsDurable;
                boolean bl = mapIsDurable = !(valueHashToId instanceof NonDurableNonParallelIntToMultiIntMap);
                if (mapIsDurable) {
                    LOG.warn("[" + name + "]: .valueHashToId map is out-of-sync with .valuesLog data (records count don't match) -> rebuilding the map (impl: " + String.valueOf(valueHashToId.getClass()) + ")");
                }
                DurableEnumerator.fillValueHashToIdMap(valuesLog, this.valueDescriptor, valueHashToId);
                if (mapIsDurable) {
                    LOG.warn("[" + name + "]: .valueHashToId was rebuilt (" + valueHashToId.size() + " records)");
                } else {
                    LOG.info("[" + name + "]: .valueHashToId (in memory) was filled (" + valueHashToId.size() + " records)");
                }
            }
            return new DurableEnumerator<V>(this.valueDescriptor, (AppendOnlyLog)valuesLog, (ThrowableComputable<DurableIntToMultiIntMap, IOException>)((ThrowableComputable)() -> valueHashToId));
        }));
        if (durableEnumerator == null) {
            DurableEnumeratorFactory.$$$reportNull$$$0(9);
        }
        return durableEnumerator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesLogFactory";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueHashToIdFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapFileSuffix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/util/io/storages/enumerator/DurableEnumeratorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/util/io/storages/enumerator/DurableEnumeratorFactory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "open";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "defaultWithDurableMap";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "defaultWithInMemoryMap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "valuesLogFactory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mapFactory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

