/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.enumerator;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IntRef;
import com.intellij.platform.util.io.storages.StorageFactory;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLog;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLogFactory;
import com.intellij.platform.util.io.storages.intmultimaps.Int2IntMultimap;
import com.intellij.util.io.CleanableStorage;
import com.intellij.util.io.DurableDataEnumerator;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import com.intellij.util.io.Unmappable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DurableStringEnumerator
implements DurableDataEnumerator<String>,
ScannableDataEnumeratorEx<String>,
Unmappable,
CleanableStorage {
    public static final int DATA_FORMAT_VERSION = 1;
    public static final int PAGE_SIZE = 0x800000;
    private final AppendOnlyLog valuesLog;
    @NotNull
    private final CompletableFuture<Int2IntMultimap> valueHashToIdFuture;
    private final Object valueHashLock;
    private Int2IntMultimap valueHashToId;
    private static final StorageFactory<? extends AppendOnlyLog> VALUES_LOG_FACTORY = AppendOnlyLogFactory.withDefaults().pageSize(0x800000).failIfDataFormatVersionNotMatch(1).checkIfFileCompatibleEagerly(true).cleanIfFileIncompatible();

    public DurableStringEnumerator(@NotNull AppendOnlyLog valuesLog, @NotNull Int2IntMultimap valueHashToId) {
        if (valuesLog == null) {
            DurableStringEnumerator.$$$reportNull$$$0(0);
        }
        if (valueHashToId == null) {
            DurableStringEnumerator.$$$reportNull$$$0(1);
        }
        this(valuesLog, CompletableFuture.completedFuture(valueHashToId));
    }

    public DurableStringEnumerator(@NotNull AppendOnlyLog valuesLog, @NotNull CompletableFuture<Int2IntMultimap> valueHashToIdFuture) {
        if (valuesLog == null) {
            DurableStringEnumerator.$$$reportNull$$$0(2);
        }
        if (valueHashToIdFuture == null) {
            DurableStringEnumerator.$$$reportNull$$$0(3);
        }
        this.valueHashLock = new Object();
        this.valueHashToId = null;
        this.valuesLog = valuesLog;
        this.valueHashToIdFuture = valueHashToIdFuture;
    }

    @NotNull
    public static DurableStringEnumerator open(@NotNull Path storagePath) throws IOException {
        if (storagePath == null) {
            DurableStringEnumerator.$$$reportNull$$$0(4);
        }
        DurableStringEnumerator durableStringEnumerator = (DurableStringEnumerator)VALUES_LOG_FACTORY.wrapStorageSafely(storagePath, valuesLog -> new DurableStringEnumerator((AppendOnlyLog)valuesLog, DurableStringEnumerator.buildValueToIdIndex(valuesLog)));
        if (durableStringEnumerator == null) {
            DurableStringEnumerator.$$$reportNull$$$0(5);
        }
        return durableStringEnumerator;
    }

    @NotNull
    public static DurableStringEnumerator openAsync(@NotNull Path storagePath, @NotNull AsyncExecutor executor) throws IOException {
        if (storagePath == null) {
            DurableStringEnumerator.$$$reportNull$$$0(6);
        }
        if (executor == null) {
            DurableStringEnumerator.$$$reportNull$$$0(7);
        }
        DurableStringEnumerator durableStringEnumerator = (DurableStringEnumerator)VALUES_LOG_FACTORY.wrapStorageSafely(storagePath, valuesLog -> new DurableStringEnumerator((AppendOnlyLog)valuesLog, executor.async(() -> DurableStringEnumerator.buildValueToIdIndex(valuesLog))));
        if (durableStringEnumerator == null) {
            DurableStringEnumerator.$$$reportNull$$$0(8);
        }
        return durableStringEnumerator;
    }

    public boolean isDirty() {
        return false;
    }

    public void force() throws IOException {
        this.valuesLog.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int enumerate(@Nullable String value) throws IOException {
        if (value == null) {
            return 0;
        }
        int valueHash = DurableStringEnumerator.hashOf(value);
        Object object = this.valueHashLock;
        synchronized (object) {
            Int2IntMultimap valueHashToId = this.valueHashToId();
            int foundId = this.lookupValue(valueHashToId, value, valueHash);
            if (foundId != 0) {
                return foundId;
            }
            int id = DurableStringEnumerator.writeString(value, this.valuesLog);
            valueHashToId.put(valueHash, id);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tryEnumerate(@Nullable String value) throws IOException {
        if (value == null) {
            return 0;
        }
        int valueHash = DurableStringEnumerator.hashOf(value);
        Object object = this.valueHashLock;
        synchronized (object) {
            Int2IntMultimap valueHashToId = this.valueHashToId();
            return this.lookupValue(valueHashToId, value, valueHash);
        }
    }

    @Nullable
    public String valueOf(int valueId) throws IOException {
        if (!this.valuesLog.isValidId(valueId)) {
            return null;
        }
        return (String)this.valuesLog.read(valueId, DurableStringEnumerator::readString);
    }

    public boolean forEach(@NotNull ScannableDataEnumeratorEx.ValueReader<? super String> reader) throws IOException {
        if (reader == null) {
            DurableStringEnumerator.$$$reportNull$$$0(9);
        }
        return this.valuesLog.forEachRecord((recordId, buffer) -> {
            int valueId = DurableStringEnumerator.convertLogIdToValueId(recordId);
            String value = DurableStringEnumerator.readString(buffer);
            return reader.read(valueId, (Object)value);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int recordsCount() throws IOException {
        Object object = this.valueHashLock;
        synchronized (object) {
            return this.valueHashToId().size();
        }
    }

    public void close() throws IOException {
        try {
            this.valueHashToIdFuture.join();
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable e) {
            Logger.getInstance(DurableStringEnumerator.class).info(".valueHashToId computation failed", e);
        }
        this.valuesLog.close();
    }

    public void closeAndUnsafelyUnmap() throws IOException {
        this.close();
        if (this.valuesLog instanceof Unmappable) {
            ((Unmappable)this.valuesLog).closeAndUnsafelyUnmap();
        }
    }

    public void closeAndClean() throws IOException {
        this.close();
        this.valuesLog.closeAndClean();
    }

    @NotNull
    private Int2IntMultimap valueHashToId() throws IOException {
        Int2IntMultimap int2IntMultimap;
        try {
            if (this.valueHashToId == null) {
                this.valueHashToId = this.valueHashToIdFuture.get();
            }
            int2IntMultimap = this.valueHashToId;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        if (int2IntMultimap == null) {
            DurableStringEnumerator.$$$reportNull$$$0(10);
        }
        return int2IntMultimap;
    }

    private static int hashOf(@NotNull String value) {
        int hash;
        if (value == null) {
            DurableStringEnumerator.$$$reportNull$$$0(11);
        }
        if ((hash = value.hashCode()) == 0) {
            return -1;
        }
        return hash;
    }

    private int lookupValue(@NotNull Int2IntMultimap valueHashToId, @NotNull String value, int hash) throws IOException {
        if (valueHashToId == null) {
            DurableStringEnumerator.$$$reportNull$$$0(12);
        }
        if (value == null) {
            DurableStringEnumerator.$$$reportNull$$$0(13);
        }
        IntRef foundIdRef = new IntRef(0);
        try {
            valueHashToId.lookup(hash, candidateId -> {
                try {
                    String candidateValue = (String)this.valuesLog.read(candidateId, DurableStringEnumerator::readString);
                    if (candidateValue.equals(value)) {
                        foundIdRef.set(candidateId);
                        return false;
                    }
                    return true;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
            return foundIdRef.get();
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }

    @NotNull
    private static String readString(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            DurableStringEnumerator.$$$reportNull$$$0(14);
        }
        String string = IOUtil.readString((ByteBuffer)buffer);
        if (string == null) {
            DurableStringEnumerator.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static int writeString(@NotNull String value, @NotNull AppendOnlyLog valuesLog) throws IOException {
        if (value == null) {
            DurableStringEnumerator.$$$reportNull$$$0(16);
        }
        if (valuesLog == null) {
            DurableStringEnumerator.$$$reportNull$$$0(17);
        }
        byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
        long appendedId = valuesLog.append(valueBytes);
        return DurableStringEnumerator.convertLogIdToValueId(appendedId);
    }

    @NotNull
    private static Int2IntMultimap buildValueToIdIndex(@NotNull AppendOnlyLog valuesLog) throws IOException {
        if (valuesLog == null) {
            DurableStringEnumerator.$$$reportNull$$$0(18);
        }
        Int2IntMultimap valueHashToId = new Int2IntMultimap();
        valuesLog.forEachRecord((logId, buffer) -> {
            String value = DurableStringEnumerator.readString(buffer);
            int id = DurableStringEnumerator.convertLogIdToValueId(logId);
            int valueHash = DurableStringEnumerator.hashOf(value);
            valueHashToId.put(valueHash, id);
            return true;
        });
        Int2IntMultimap int2IntMultimap = valueHashToId;
        if (int2IntMultimap == null) {
            DurableStringEnumerator.$$$reportNull$$$0(19);
        }
        return int2IntMultimap;
    }

    private static int convertLogIdToValueId(long logId) {
        return Math.toIntExact(logId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 10, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesLog";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueHashToId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueHashToIdFuture";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagePath";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/util/io/storages/enumerator/DurableStringEnumerator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/util/io/storages/enumerator/DurableStringEnumerator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "open";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "openAsync";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "valueHashToId";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readString";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildValueToIdIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 15: 
            case 19: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openAsync";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hashOf";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lookupValue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readString";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeString";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildValueToIdIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 10, 15, 19 -> new IllegalStateException(string);
        };
    }

    public static interface AsyncExecutor {
        @NotNull
        public <T> CompletableFuture<T> async(@NotNull Callable<T> var1);
    }
}

