/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.intmultimaps.extendiblehashmap;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.platform.util.io.storages.StorageFactory;
import com.intellij.platform.util.io.storages.intmultimaps.extendiblehashmap.ExtendibleHashMap;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorageFactory;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.IOUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ExtendibleMapFactory
implements StorageFactory<ExtendibleHashMap> {
    private static final Logger LOG = Logger.getInstance(ExtendibleMapFactory.class);
    private final int pageSize;
    private final int segmentSize;
    private final NotClosedProperlyAction notClosedProperlyAction;
    private final boolean eagerlyCheckFileCompatibility;
    private final boolean cleanFileIfIncompatible;

    private ExtendibleMapFactory(int pageSize, int segmentSize, @NotNull NotClosedProperlyAction notClosedProperlyAction, boolean eagerlyCheckFileCompatibility, boolean cleanFileIfIncompatible) {
        if (notClosedProperlyAction == null) {
            ExtendibleMapFactory.$$$reportNull$$$0(0);
        }
        if (Integer.bitCount(segmentSize) != 1) {
            throw new IllegalArgumentException("segmentSize(=" + segmentSize + ") must be power of 2");
        }
        if (segmentSize > pageSize) {
            throw new IllegalArgumentException("segmentSize(=" + segmentSize + ") must be <= pageSize(=" + pageSize + ")");
        }
        if (pageSize % segmentSize != 0) {
            throw new IllegalArgumentException("segmentSize(=" + segmentSize + ") must align with pageSize(=" + pageSize + ")");
        }
        this.pageSize = pageSize;
        this.segmentSize = segmentSize;
        this.notClosedProperlyAction = notClosedProperlyAction;
        this.eagerlyCheckFileCompatibility = eagerlyCheckFileCompatibility;
        this.cleanFileIfIncompatible = cleanFileIfIncompatible;
    }

    public static ExtendibleMapFactory mediumSize() {
        return new ExtendibleMapFactory(0x100000, 32768, NotClosedProperlyAction.IGNORE_AND_HOPE_FOR_THE_BEST, true, false);
    }

    public static ExtendibleMapFactory largeSize() {
        int segmentSize = 65536;
        int pageSize = segmentSize * 32;
        return new ExtendibleMapFactory(pageSize, segmentSize, NotClosedProperlyAction.IGNORE_AND_HOPE_FOR_THE_BEST, true, false);
    }

    public ExtendibleMapFactory pageSize(int pageSize) {
        return new ExtendibleMapFactory(pageSize, this.segmentSize, this.notClosedProperlyAction, this.eagerlyCheckFileCompatibility, this.cleanFileIfIncompatible);
    }

    public ExtendibleMapFactory segmentSize(int segmentSize) {
        return new ExtendibleMapFactory(this.pageSize, segmentSize, this.notClosedProperlyAction, this.eagerlyCheckFileCompatibility, this.cleanFileIfIncompatible);
    }

    public ExtendibleMapFactory ifNotClosedProperly(@NotNull NotClosedProperlyAction action) {
        if (action == null) {
            ExtendibleMapFactory.$$$reportNull$$$0(1);
        }
        return new ExtendibleMapFactory(this.pageSize, this.segmentSize, action, this.eagerlyCheckFileCompatibility, this.cleanFileIfIncompatible);
    }

    public ExtendibleMapFactory cleanIfFileIncompatible() {
        return new ExtendibleMapFactory(this.pageSize, this.segmentSize, this.notClosedProperlyAction, true, true);
    }

    public ExtendibleMapFactory failIfFileIncompatible() {
        return new ExtendibleMapFactory(this.pageSize, this.segmentSize, this.notClosedProperlyAction, true, false);
    }

    @Override
    @NotNull
    public ExtendibleHashMap open(@NotNull Path storagePath) throws IOException {
        ExtendibleHashMap extendibleHashMap;
        if (storagePath == null) {
            ExtendibleMapFactory.$$$reportNull$$$0(2);
        }
        if (this.eagerlyCheckFileCompatibility) {
            long size;
            long l = size = Files.exists(storagePath, new LinkOption[0]) ? Files.size(storagePath) : 0L;
            if (size > 0L) {
                this.checkCrucialFileHeaderParamsEagerly(storagePath);
            }
        }
        MMappedFileStorageFactory mappedStorageFactory = MMappedFileStorageFactory.withDefaults().pageSize(this.pageSize);
        try {
            extendibleHashMap = (ExtendibleHashMap)mappedStorageFactory.wrapStorageSafely(storagePath, mappedStorage -> {
                ExtendibleHashMap map = new ExtendibleHashMap((MMappedFileStorage)mappedStorage, this.segmentSize);
                if (!map.wasProperlyClosed() && this.notClosedProperlyAction != NotClosedProperlyAction.IGNORE_AND_HOPE_FOR_THE_BEST) {
                    throw new CorruptedException("Storage [" + String.valueOf(storagePath) + "] was not closed properly, can't be trusted -- could be corrupted");
                }
                return map;
            });
        }
        catch (CorruptedException e) {
            if (this.notClosedProperlyAction == NotClosedProperlyAction.DROP_AND_CREATE_EMPTY_MAP) {
                LOG.info("[" + String.valueOf(storagePath) + "]: map is not closed properly, factory strategy[" + String.valueOf((Object)this.notClosedProperlyAction) + "] -> trying to drop & re-create map from 0");
                NioFiles.deleteRecursively((Path)storagePath);
                ExtendibleHashMap extendibleHashMap2 = (ExtendibleHashMap)mappedStorageFactory.wrapStorageSafely(storagePath, mappedStorage -> new ExtendibleHashMap((MMappedFileStorage)mappedStorage, this.segmentSize));
                if (extendibleHashMap2 == null) {
                    ExtendibleMapFactory.$$$reportNull$$$0(4);
                }
                return extendibleHashMap2;
            }
            throw e;
        }
        if (extendibleHashMap == null) {
            ExtendibleMapFactory.$$$reportNull$$$0(3);
        }
        return extendibleHashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkCrucialFileHeaderParamsEagerly(@NotNull Path storagePath) throws IOException {
        if (storagePath == null) {
            ExtendibleMapFactory.$$$reportNull$$$0(5);
        }
        ByteBuffer headerBuffer = ByteBuffer.allocate(80).order(ByteOrder.nativeOrder()).clear();
        try (FileChannel channel = FileChannel.open(storagePath, StandardOpenOption.READ);){
            try {
                int actuallyRead = channel.read(headerBuffer);
                if (actuallyRead != 80) {
                    throw new CorruptedException("[" + String.valueOf(storagePath) + "]: file is not empty, but < HEADER_SIZE(=80)");
                }
                int magicWord = ExtendibleHashMap.HeaderLayout.magicWord(headerBuffer);
                if (magicWord != ExtendibleHashMap.MAGIC_WORD) {
                    throw new IOException("[" + String.valueOf(storagePath) + "] is of incorrect type: .magicWord(=" + magicWord + ", '" + IOUtil.magicWordToASCII((int)magicWord) + "') != " + ExtendibleHashMap.MAGIC_WORD + " expected");
                }
                int implVersion = ExtendibleHashMap.HeaderLayout.version(headerBuffer);
                if (implVersion != 1) {
                    throw new IOException("[" + String.valueOf(storagePath) + "]: version(=" + implVersion + ") != current impl version(=1)");
                }
                int segmentSize = ExtendibleHashMap.HeaderLayout.segmentSize(headerBuffer);
                if (segmentSize != this.segmentSize) {
                    throw new IOException("[" + String.valueOf(storagePath) + "]: segmentSize(=" + this.segmentSize + ") != segmentSize(=" + segmentSize + ") storage was initialized with");
                }
            }
            catch (IOException ex) {
                if (!this.cleanFileIfIncompatible) throw ex;
                LOG.info("[" + String.valueOf(storagePath) + "] is incompatible with current format -> delete it, and pretend never seen it incompatible (incompatibility: " + ex.getMessage() + ")");
                NioFiles.deleteRecursively((Path)storagePath);
            }
            byte fileStatus = ExtendibleHashMap.HeaderLayout.fileStatus(headerBuffer);
            boolean wasProperlyClosed = fileStatus == 1;
            if (wasProperlyClosed) return;
            switch (this.notClosedProperlyAction.ordinal()) {
                case 1: {
                    throw new CorruptedException("Storage [" + String.valueOf(storagePath) + "] was not closed properly, can't be trusted -- could be corrupted");
                }
                case 2: {
                    LOG.info("[" + String.valueOf(storagePath) + "] was not closed properly, can't be trusted -> delete it, and re-create from 0");
                    NioFiles.deleteRecursively((Path)storagePath);
                    return;
                }
            }
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notClosedProperlyAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagePath";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/util/io/storages/intmultimaps/extendiblehashmap/ExtendibleMapFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/util/io/storages/intmultimaps/extendiblehashmap/ExtendibleMapFactory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "open";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "ifNotClosedProperly";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkCrucialFileHeaderParamsEagerly";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static enum NotClosedProperlyAction {
        IGNORE_AND_HOPE_FOR_THE_BEST,
        FAIL_SPECTACULARLY,
        DROP_AND_CREATE_EMPTY_MAP;

    }
}

