/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.mmapped;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.platform.util.io.storages.StorageFactory;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import com.intellij.util.io.IOUtil;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class MMappedFileStorageFactory
implements StorageFactory<MMappedFileStorage> {
    private static final Logger LOG = Logger.getInstance(MMappedFileStorageFactory.class);
    public static final int DEFAULT_PAGE_SIZE = 0x100000;
    private final int pageSize;
    private final IfNotPageAligned ifFileNotPageAligned;
    private final boolean createParentDirectoriesIfNotExist;

    public static MMappedFileStorageFactory withDefaults() {
        return new MMappedFileStorageFactory(0x100000, IfNotPageAligned.THROW_EXCEPTION, true);
    }

    private MMappedFileStorageFactory(int pageSize, @NotNull IfNotPageAligned ifFileNotPageAligned, boolean createParentDirectoriesIfNotExist) {
        if (ifFileNotPageAligned == null) {
            MMappedFileStorageFactory.$$$reportNull$$$0(0);
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize(=" + pageSize + ") must be >0");
        }
        if (Integer.bitCount(pageSize) != 1) {
            throw new IllegalArgumentException("pageSize(=" + pageSize + ") must be a power of 2");
        }
        this.pageSize = pageSize;
        this.ifFileNotPageAligned = ifFileNotPageAligned;
        this.createParentDirectoriesIfNotExist = createParentDirectoriesIfNotExist;
    }

    public MMappedFileStorageFactory pageSize(int pageSize) {
        return new MMappedFileStorageFactory(pageSize, this.ifFileNotPageAligned, this.createParentDirectoriesIfNotExist);
    }

    public MMappedFileStorageFactory ifFileIsNotPageAligned(@NotNull IfNotPageAligned ifFileNotPageAligned) {
        if (ifFileNotPageAligned == null) {
            MMappedFileStorageFactory.$$$reportNull$$$0(1);
        }
        return new MMappedFileStorageFactory(this.pageSize, ifFileNotPageAligned, this.createParentDirectoriesIfNotExist);
    }

    public MMappedFileStorageFactory createParentDirectories(boolean createParentDirectories) {
        return new MMappedFileStorageFactory(this.pageSize, this.ifFileNotPageAligned, createParentDirectories);
    }

    @Override
    @NotNull
    public MMappedFileStorage open(@NotNull Path storagePath) throws IOException {
        long fileSize;
        Path absoluteStoragePath;
        boolean storageFileExists;
        if (storagePath == null) {
            MMappedFileStorageFactory.$$$reportNull$$$0(2);
        }
        if (!(storageFileExists = Files.exists(absoluteStoragePath = storagePath.toAbsolutePath(), new LinkOption[0]))) {
            this.checkParentDirectories(absoluteStoragePath);
        }
        MMappedFileStorage.RegionAllocationAtomicityLock regionAllocationLock = MMappedFileStorage.RegionAllocationAtomicityLock.defaultLock(absoluteStoragePath);
        long l = fileSize = storageFileExists ? Files.size(absoluteStoragePath) : 0L;
        if (fileSize % (long)this.pageSize != 0L) {
            this.dealWithPageUnAlignedFileSize(absoluteStoragePath, fileSize, regionAllocationLock);
        }
        return new MMappedFileStorage(absoluteStoragePath, this.pageSize, regionAllocationLock);
    }

    /*
     * WARNING - void declaration
     */
    private void dealWithPageUnAlignedFileSize(@NotNull Path storagePath, long fileSize, @NotNull MMappedFileStorage.RegionAllocationAtomicityLock regionAllocationAtomicityLock) throws IOException {
        long startOfSuspiciousRegion;
        void regionAllocationLock;
        MMappedFileStorage.RegionAllocationAtomicityLock.Region region;
        if (storagePath == null) {
            MMappedFileStorageFactory.$$$reportNull$$$0(3);
        }
        if (regionAllocationAtomicityLock == null) {
            MMappedFileStorageFactory.$$$reportNull$$$0(4);
        }
        if ((region = regionAllocationLock.region(startOfSuspiciousRegion = fileSize / (long)this.pageSize * (long)this.pageSize, this.pageSize)).isUnfinished()) {
            LOG.warn("mmapped file region " + String.valueOf(region) + " allocation & zeroing has been started, but hasn't been properly finished -- IDE was crashed/killed? -> try finishing the job");
            try (FileChannel channel = FileChannel.open(storagePath, StandardOpenOption.WRITE);){
                IOUtil.fillFileRegionWithZeros((FileChannel)channel, (long)startOfSuspiciousRegion, (long)(startOfSuspiciousRegion + (long)this.pageSize));
            }
            region.finish();
            return;
        }
        switch (this.ifFileNotPageAligned.ordinal()) {
            case 1: {
                throw new IOException("[" + String.valueOf(storagePath) + "]: fileSize(=" + fileSize + " b) is not page(=" + this.pageSize + " b)-aligned");
            }
            case 0: {
                LOG.warn("[" + String.valueOf(storagePath) + "]: fileSize(=" + fileSize + " b) is not page(=" + this.pageSize + " b)-aligned -> expand until aligned");
                long fileSizeRoundedUpToPageSize = (fileSize / (long)this.pageSize + 1L) * (long)this.pageSize;
                region.start();
                try (FileChannel channel = FileChannel.open(storagePath, StandardOpenOption.WRITE);){
                    IOUtil.allocateFileRegion((FileChannel)channel, (long)fileSizeRoundedUpToPageSize);
                }
                region.finish();
                break;
            }
            case 2: {
                LOG.warn("[" + String.valueOf(storagePath) + "]: fileSize(=" + fileSize + " b) is not page(=" + this.pageSize + " b)-aligned -> delete & re-create");
                NioFiles.deleteRecursively((Path)storagePath);
            }
        }
    }

    private void checkParentDirectories(@NotNull Path storagePath) throws IOException {
        Path parentDir;
        if (storagePath == null) {
            MMappedFileStorageFactory.$$$reportNull$$$0(5);
        }
        if (Files.exists(parentDir = storagePath.getParent(), new LinkOption[0])) {
            return;
        }
        if (this.createParentDirectoriesIfNotExist) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
            return;
        }
        throw new NoSuchFileException("Parent directory of [" + String.valueOf(storagePath) + "] is not exist, and .createDirectoriesIfNotExist=false");
    }

    public String toString() {
        return "MMappedFileStorageFactory{pageSize: " + this.pageSize + ", ifNotPageAligned: " + String.valueOf((Object)this.ifFileNotPageAligned) + ", createParentDirectoriesIfNotExist: " + this.createParentDirectoriesIfNotExist + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifFileNotPageAligned";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regionAllocationLock";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/util/io/storages/mmapped/MMappedFileStorageFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "ifFileIsNotPageAligned";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "open";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "dealWithPageUnAlignedFileSize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParentDirectories";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum IfNotPageAligned {
        EXPAND_FILE,
        THROW_EXCEPTION,
        CLEAN;

    }
}

