/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0014B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/containers/LimitedPool;", "T", "", "myMaxCapacity", "", "myFactory", "Lcom/intellij/util/containers/LimitedPool$ObjectFactory;", "<init>", "(ILcom/intellij/util/containers/LimitedPool$ObjectFactory;)V", "myStorage", "", "[Ljava/lang/Object;", "myIndex", "alloc", "()Ljava/lang/Object;", "recycle", "", "t", "(Ljava/lang/Object;)V", "ensureCapacity", "ObjectFactory", "intellij.platform.util.multiplatform"})
public class LimitedPool<T> {
    private final int myMaxCapacity;
    @NotNull
    private final ObjectFactory<T> myFactory;
    @NotNull
    private Object[] myStorage;
    private int myIndex;

    public LimitedPool(int myMaxCapacity, @NotNull ObjectFactory<T> myFactory) {
        Intrinsics.checkNotNullParameter(myFactory, (String)"myFactory");
        this.myMaxCapacity = myMaxCapacity;
        this.myFactory = myFactory;
        this.myStorage = new Object[0];
    }

    public T alloc() {
        if (this.myIndex == 0) {
            return this.myFactory.create();
        }
        this.myIndex += -1;
        int i = this.myIndex;
        Object result = this.myStorage[i];
        this.myStorage[i] = null;
        return (T)result;
    }

    public void recycle(T t) {
        this.myFactory.cleanup(t);
        if (this.myIndex >= this.myMaxCapacity) {
            return;
        }
        this.ensureCapacity();
        int n = this.myIndex;
        this.myIndex = n + 1;
        this.myStorage[n] = t;
    }

    private final void ensureCapacity() {
        if (this.myStorage.length <= this.myIndex) {
            int newCapacity = this.myStorage.length * 3 / 2;
            if (newCapacity < 10) {
                Object[] objectArray = Arrays.copyOf(this.myStorage, 10);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
                this.myStorage = objectArray;
            } else if (newCapacity <= this.myMaxCapacity) {
                Object[] objectArray = Arrays.copyOf(this.myStorage, newCapacity);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
                this.myStorage = objectArray;
            } else {
                Object[] objectArray = Arrays.copyOf(this.myStorage, this.myMaxCapacity);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
                this.myStorage = objectArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\r\u0010\u0003\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/containers/LimitedPool$ObjectFactory;", "T", "", "create", "()Ljava/lang/Object;", "cleanup", "", "t", "(Ljava/lang/Object;)V", "intellij.platform.util.multiplatform"})
    public static interface ObjectFactory<T> {
        public T create();

        default public void cleanup(T t) {
        }
    }
}

