/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fastutil.ints;

import com.intellij.util.fastutil.Hash;
import com.intellij.util.fastutil.HashCommon;
import com.intellij.util.fastutil.ints.IntArrayList;
import com.intellij.util.fastutil.ints.IntEntry;
import com.intellij.util.fastutil.ints.IntIterator;
import com.intellij.util.fastutil.ints.IntListExtensionsKt;
import com.intellij.util.fastutil.ints.IntMap;
import com.intellij.util.fastutil.ints.MutableIntMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="This API is temporary multiplatform shim. Please make sure you are not using it by accident", replaceWith=@ReplaceWith(expression="it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap", imports={}), level=DeprecationLevel.WARNING)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0002\b\u0012\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0004WXYZB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\t\b\u0016\u00a2\u0006\u0004\b\b\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u000bB!\b\u0016\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\rB)\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0012B)\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u0013\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0014J\u0006\u0010/\u001a\u00020\u001aJ\b\u00100\u001a\u00020\u0005H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0005H\u0002J\u0010\u00104\u001a\u0002022\u0006\u00103\u001a\u000205H\u0002J\u0017\u00106\u001a\u0004\u0018\u00018\u00002\u0006\u00107\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u00108J\r\u00109\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010:J\u0014\u0010;\u001a\u0002022\f\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0010\u0010=\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J%\u0010>\u001a\u0002022\u0006\u00107\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010?J\u001f\u0010@\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010AJ\u0010\u0010B\u001a\u0002022\u0006\u00107\u001a\u00020\u0005H\u0002J\u0017\u0010C\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u00108J\u0018\u0010D\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u00108J\u000e\u0010E\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0005J\u0013\u0010F\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010GJ\u001b\u0010H\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\"\u001a\u00028\u0000\u00a2\u0006\u0002\u0010AJ\u0016\u0010C\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020IJ\r\u0010J\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010:J\u0013\u0010J\u001a\u0002022\u0006\u0010K\u001a\u00028\u0000\u00a2\u0006\u0002\u0010LJ#\u0010M\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010N\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010OJ\u001b\u0010M\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010AJ\u0006\u0010P\u001a\u000202J\u0010\u0010Q\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u0005J\u0010\u0010R\u001a\u0002022\u0006\u0010S\u001a\u00020\u0005H\u0002J\u0013\u0010T\u001a\u00020\u001a2\b\u0010U\u001a\u0004\u0018\u00010IH\u0096\u0002J\b\u0010V\u001a\u00020\u0005H\u0016R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#R \u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000&0%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010(\u00a8\u0006["}, d2={"Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap;", "V", "Lcom/intellij/util/fastutil/Hash;", "Lcom/intellij/util/fastutil/ints/MutableIntMap;", "expected", "", "f", "", "<init>", "(IF)V", "()V", "(I)V", "m", "(Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap;F)V", "k", "Lcom/intellij/util/fastutil/ints/IntArrayList;", "v", "", "(Lcom/intellij/util/fastutil/ints/IntArrayList;[Ljava/lang/Object;F)V", "", "([I[Ljava/lang/Object;F)V", "key", "value", "[Ljava/lang/Object;", "mask", "containsNullKey", "", "n", "maxFill", "minN", "size", "getSize", "()I", "setSize", "defaultValue", "Ljava/lang/Object;", "entries", "", "Lcom/intellij/util/fastutil/ints/IntEntry;", "getEntries", "()Ljava/util/Iterator;", "keys", "Lcom/intellij/util/fastutil/ints/IntIterator;", "getKeys", "()Lcom/intellij/util/fastutil/ints/IntIterator;", "values", "getValues", "isEmpty", "realSize", "ensureCapacity", "", "capacity", "tryCapacity", "", "removeEntry", "pos", "(I)Ljava/lang/Object;", "removeNullEntry", "()Ljava/lang/Object;", "putAll", "from", "find", "insert", "(IILjava/lang/Object;)V", "put", "(ILjava/lang/Object;)Ljava/lang/Object;", "shiftKeys", "remove", "get", "containsKey", "containsValue", "(Ljava/lang/Object;)Z", "getOrDefault", "", "defaultReturnValue", "rv", "(Ljava/lang/Object;)V", "replace", "oldValue", "(ILjava/lang/Object;Ljava/lang/Object;)Z", "clear", "trim", "rehash", "newN", "equals", "o", "hashCode", "MapIterator", "EntryIterator", "KeyIterator", "ValueIterator", "intellij.platform.util.multiplatform"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInt2ObjectOpenHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Int2ObjectOpenHashMap.kt\ncom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,603:1\n1#2:604\n*E\n"})
public final class Int2ObjectOpenHashMap<V>
implements Hash,
MutableIntMap<V> {
    @NotNull
    private int[] key;
    @NotNull
    private V[] value;
    private int mask;
    private boolean containsNullKey;
    private int n;
    private int maxFill;
    private int minN;
    private int size;
    private float f;
    @Nullable
    private V defaultValue;

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    @NotNull
    public Iterator<IntEntry<V>> getEntries() {
        return new EntryIterator();
    }

    @Override
    @NotNull
    public IntIterator getKeys() {
        return new KeyIterator();
    }

    @Override
    @NotNull
    public Iterator<V> getValues() {
        return new ValueIterator();
    }

    public Int2ObjectOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.INSTANCE.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, f);
        this.key = new int[this.n + 1];
        this.value = new Object[this.n + 1];
    }

    public Int2ObjectOpenHashMap() {
        this(16, 0.75f);
    }

    public Int2ObjectOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Int2ObjectOpenHashMap(@NotNull Int2ObjectOpenHashMap<V> m, float f) {
        Intrinsics.checkNotNullParameter(m, (String)"m");
        this(m.getSize(), f);
        this.putAll(m);
    }

    public /* synthetic */ Int2ObjectOpenHashMap(Int2ObjectOpenHashMap int2ObjectOpenHashMap, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.75f;
        }
        this(int2ObjectOpenHashMap, f);
    }

    public Int2ObjectOpenHashMap(@NotNull IntArrayList k, @NotNull V[] v, float f) {
        int n;
        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
        Intrinsics.checkNotNullParameter(v, (String)"v");
        this(k.getSize(), f);
        if (k.getSize() != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.getSize() + " and " + v.length + ')');
        }
        IntRange intRange = IntListExtensionsKt.getIndices(k);
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            while (true) {
                this.set(k.get(i), v[i]);
                if (i == n) break;
                ++i;
            }
        }
    }

    public /* synthetic */ Int2ObjectOpenHashMap(IntArrayList intArrayList, Object[] objectArray, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f = 0.75f;
        }
        this(intArrayList, objectArray, f);
    }

    public Int2ObjectOpenHashMap(@NotNull int[] k, @NotNull V[] v, float f) {
        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
        Intrinsics.checkNotNullParameter(v, (String)"v");
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ')');
        }
        int n = k.length;
        for (int i = 0; i < n; ++i) {
            this.set(k[i], v[i]);
        }
    }

    public /* synthetic */ Int2ObjectOpenHashMap(int[] nArray, Object[] objectArray, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f = 0.75f;
        }
        this(nArray, objectArray, f);
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    private final int realSize() {
        return this.containsNullKey ? this.getSize() - 1 : this.getSize();
    }

    private final void ensureCapacity(int capacity) {
        int needed = HashCommon.INSTANCE.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private final void tryCapacity(long capacity) {
        int needed = Math.min(0x40000000, Math.max(2, HashCommon.INSTANCE.nextPowerOfTwo((int)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private final V removeEntry(int pos) {
        V oldValue = this.value[pos];
        this.value[pos] = null;
        int n = this.getSize();
        this.setSize(n + -1);
        this.shiftKeys(pos);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private final V removeNullEntry() {
        this.containsNullKey = false;
        V oldValue = this.value[this.n];
        this.value[this.n] = null;
        int n = this.getSize();
        this.setSize(n + -1);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        V v = oldValue;
        Intrinsics.checkNotNull(v);
        return v;
    }

    public final void putAll(@NotNull Int2ObjectOpenHashMap<V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(from.getSize());
        } else {
            this.tryCapacity(this.getSize() + from.getSize());
        }
        int n = from.getSize();
        Iterator<IntEntry<V>> i = from.getEntries();
        IntEntry<V> e = null;
        while (n-- != 0) {
            e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    private final int find(int k) {
        int it;
        int n;
        if (k == 0) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(k) & this.mask;
        int[] nArray = key;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return -(pos + 1);
        }
        if (k == curr) {
            return pos;
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return -(pos + 1);
        } while (k != curr);
        return pos;
    }

    private final void insert(int pos, int k, V v) {
        if (pos == this.n) {
            this.containsNullKey = true;
        }
        this.key[pos] = k;
        this.value[pos] = v;
        int n = this.getSize();
        this.setSize(n + 1);
        if (n >= this.maxFill) {
            this.rehash(HashCommon.INSTANCE.arraySize(this.getSize() + 1, this.f));
        }
    }

    @Override
    @Nullable
    public V put(int key, V value) {
        int pos = this.find(key);
        if (pos < 0) {
            this.insert(-pos - 1, key, value);
            return this.defaultReturnValue();
        }
        V oldValue = this.value[pos];
        this.value[pos] = value;
        this.key[pos] = key;
        return oldValue;
    }

    private final void shiftKeys(int pos) {
        int pos2 = pos;
        int last = 0;
        int slot = 0;
        int curr = 0;
        int[] key = this.key;
        V[] value = this.value;
        while (true) {
            int n;
            int it = n = pos2;
            boolean bl = false;
            last = it;
            pos2 = n + 1 & this.mask;
            while (true) {
                it = n = key[pos2];
                boolean bl2 = false;
                curr = it;
                if (n == 0) {
                    key[last] = 0;
                    value[last] = null;
                    return;
                }
                slot = HashCommon.INSTANCE.mix(curr) & this.mask;
                if (last <= pos2 ? last >= slot || slot > pos2 : (pos2 + 1 <= slot ? slot <= last : false)) break;
                pos2 = pos2 + 1 & this.mask;
            }
            key[last] = curr;
            value[last] = value[pos2];
        }
    }

    @Override
    @Nullable
    public V remove(int k) {
        int it;
        int n;
        if (k == 0) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defaultReturnValue();
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(k) & this.mask;
        int[] nArray = key;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return this.defaultReturnValue();
        }
        if (k == curr) {
            return this.removeEntry(pos);
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return this.defaultReturnValue();
        } while (k != curr);
        return this.removeEntry(pos);
    }

    @Override
    @Nullable
    public V get(int k) {
        int it;
        int n;
        if (k == 0) {
            return this.containsNullKey ? this.value[this.n] : this.defaultReturnValue();
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(k) & this.mask;
        int[] nArray = key;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return this.defaultReturnValue();
        }
        if (k == curr) {
            return this.value[pos];
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return this.defaultReturnValue();
        } while (k != curr);
        return this.value[pos];
    }

    public final boolean containsKey(int k) {
        int it;
        int n;
        if (k == 0) {
            return this.containsNullKey;
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(k) & this.mask;
        int[] nArray = key;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return false;
        } while (k != curr);
        return true;
    }

    public final boolean containsValue(V v) {
        if (this.containsNullKey && Intrinsics.areEqual(this.value[this.n], v)) {
            return true;
        }
        int i = this.n;
        while (i-- != 0) {
            if (this.key[i] == 0 || !Intrinsics.areEqual(this.value[i], v)) continue;
            return true;
        }
        return false;
    }

    public final V getOrDefault(int k, V defaultValue) {
        int n;
        if (k == 0) {
            V v;
            if (this.containsNullKey) {
                V v2 = this.value[this.n];
                v = v2;
                Intrinsics.checkNotNull(v2);
            } else {
                v = defaultValue;
            }
            return v;
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int it = n = key[HashCommon.INSTANCE.mix(k) & this.mask];
        boolean bl = false;
        pos = it;
        it = n;
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return defaultValue;
        }
        if (k == curr) {
            V v = this.value[pos];
            Intrinsics.checkNotNull(v);
            return v;
        }
        do {
            it = n = key[pos + 1 & this.mask];
            boolean bl3 = false;
            pos = it;
            it = n;
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return defaultValue;
        } while (k != curr);
        V v = this.value[pos];
        Intrinsics.checkNotNull(v);
        return v;
    }

    public final boolean remove(int k, @NotNull Object v) {
        int n;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (k == 0) {
            if (this.containsNullKey && Intrinsics.areEqual((Object)v, this.value[this.n])) {
                this.removeNullEntry();
                return true;
            }
            return false;
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int it = n = key[HashCommon.INSTANCE.mix(k) & this.mask];
        boolean bl = false;
        pos = it;
        it = n;
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return false;
        }
        if (k == curr && Intrinsics.areEqual((Object)v, this.value[pos])) {
            this.removeEntry(pos);
            return true;
        }
        do {
            it = n = key[pos + 1 & this.mask];
            boolean bl3 = false;
            pos = it;
            it = n;
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return false;
        } while (k != curr || !Intrinsics.areEqual((Object)v, this.value[pos]));
        this.removeEntry(pos);
        return true;
    }

    @Nullable
    public final V defaultReturnValue() {
        return this.defaultValue;
    }

    public final void defaultReturnValue(V rv) {
        this.defaultValue = rv;
    }

    public final boolean replace(int k, V oldValue, V v) {
        int pos = this.find(k);
        if (pos < 0 || !Intrinsics.areEqual(oldValue, this.value[pos])) {
            return false;
        }
        this.value[pos] = v;
        return true;
    }

    public final V replace(int k, V v) {
        int pos = this.find(k);
        if (pos < 0) {
            V v2 = this.defaultReturnValue();
            Intrinsics.checkNotNull(v2);
            return v2;
        }
        V oldValue = this.value[pos];
        this.value[pos] = v;
        V v3 = oldValue;
        Intrinsics.checkNotNull(v3);
        return v3;
    }

    public final void clear() {
        if (this.getSize() == 0) {
            return;
        }
        this.setSize(0);
        this.containsNullKey = false;
        ArraysKt.fill$default((int[])this.key, (int)0, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((Object[])this.value, null, (int)0, (int)0, (int)6, null);
    }

    public final boolean trim(int n) {
        int l = HashCommon.INSTANCE.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (l >= this.n || this.getSize() > HashCommon.INSTANCE.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (Exception cantDoIt) {
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean trim$default(Int2ObjectOpenHashMap int2ObjectOpenHashMap, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = int2ObjectOpenHashMap.getSize();
        }
        return int2ObjectOpenHashMap.trim(n);
    }

    private final void rehash(int newN) {
        int[] key = this.key;
        V[] value = this.value;
        int mask = newN - 1;
        int[] newKey = new int[newN + 1];
        Object[] newValue = new Object[newN + 1];
        int i = this.n;
        int pos = 0;
        int j = this.realSize();
        while (j-- != 0) {
            int it;
            int n;
            while (key[--i] == 0) {
            }
            int n2 = n = HashCommon.INSTANCE.mix(key[i]) & mask;
            int[] nArray = newKey;
            boolean bl = false;
            pos = it;
            if (nArray[n] != 0) {
                do {
                    it = n = pos + 1 & mask;
                    nArray = newKey;
                    boolean bl2 = false;
                    pos = it;
                } while (nArray[n] != 0);
            }
            newKey[pos] = key[i];
            newValue[pos] = value[i];
        }
        newValue[newN] = value[this.n];
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntMap)) {
            return false;
        }
        if (this.getSize() != ((IntMap)o).getSize()) {
            return false;
        }
        Iterator<IntEntry<V>> iterator = this.getEntries();
        while (iterator.hasNext()) {
            IntEntry<V> intEntry = iterator.next();
            int key = intEntry.component1();
            V value = intEntry.component2();
            if (Intrinsics.areEqual(((IntMap)o).get(key), value)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        int[] key = this.key;
        V[] value = this.value;
        int j = this.realSize();
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (key[i] == 0) {
                ++i;
            }
            t = key[i];
            if (this != value[i]) {
                int n;
                if (value[i] == null) {
                    n = 0;
                } else {
                    V v = value[i];
                    n = v != null ? v.hashCode() : 0;
                }
                t ^= n;
            }
            h += t;
            ++i;
        }
        if (this.containsNullKey) {
            int n;
            if (value[this.n] == null) {
                n = 0;
            } else {
                V v = value[this.n];
                n = v != null ? v.hashCode() : 0;
            }
            h += n;
        }
        return h;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u0003B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0096\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap$EntryIterator;", "Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap$MapIterator;", "Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap;", "", "Lcom/intellij/util/fastutil/ints/IntEntry;", "<init>", "(Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap;)V", "next", "intellij.platform.util.multiplatform"})
    private final class EntryIterator
    extends MapIterator
    implements Iterator<IntEntry<V>>,
    KMappedMarker {
        @Override
        @NotNull
        public IntEntry<V> next() {
            int nextIndex = this.nextEntry();
            int n = Int2ObjectOpenHashMap.this.key[nextIndex];
            Object object = Int2ObjectOpenHashMap.this.value[nextIndex];
            Intrinsics.checkNotNull((Object)object);
            return new IntEntry<Object>(n, object);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00028\u00000\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap$KeyIterator;", "Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap$MapIterator;", "Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/intellij/util/fastutil/ints/IntIterator;", "<init>", "(Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap;)V", "next", "", "intellij.platform.util.multiplatform"})
    private final class KeyIterator
    extends MapIterator
    implements IntIterator {
        @Override
        public int next() {
            return Int2ObjectOpenHashMap.this.key[this.nextEntry()];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001c\u001a\u00020\u0011J\u0006\u0010\u001d\u001a\u00020\u0005J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap$MapIterator;", "", "<init>", "(Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap;)V", "pos", "", "getPos", "()I", "setPos", "(I)V", "last", "getLast", "setLast", "c", "getC", "setC", "mustReturnNullKey", "", "getMustReturnNullKey", "()Z", "setMustReturnNullKey", "(Z)V", "wrapped", "Lcom/intellij/util/fastutil/ints/IntArrayList;", "getWrapped", "()Lcom/intellij/util/fastutil/ints/IntArrayList;", "setWrapped", "(Lcom/intellij/util/fastutil/ints/IntArrayList;)V", "hasNext", "nextEntry", "shiftKeys", "", "intellij.platform.util.multiplatform"})
    @SourceDebugExtension(value={"SMAP\nInt2ObjectOpenHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Int2ObjectOpenHashMap.kt\ncom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap$MapIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,603:1\n1#2:604\n*E\n"})
    private abstract class MapIterator {
        private int pos;
        private int last;
        private int c;
        private boolean mustReturnNullKey;
        @Nullable
        private IntArrayList wrapped;

        public MapIterator() {
            this.pos = Int2ObjectOpenHashMap.this.n;
            this.last = -1;
            this.c = Int2ObjectOpenHashMap.this.getSize();
            this.mustReturnNullKey = Int2ObjectOpenHashMap.this.containsNullKey;
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n) {
            this.pos = n;
        }

        public final int getLast() {
            return this.last;
        }

        public final void setLast(int n) {
            this.last = n;
        }

        public final int getC() {
            return this.c;
        }

        public final void setC(int n) {
            this.c = n;
        }

        public final boolean getMustReturnNullKey() {
            return this.mustReturnNullKey;
        }

        public final void setMustReturnNullKey(boolean bl) {
            this.mustReturnNullKey = bl;
        }

        @Nullable
        public final IntArrayList getWrapped() {
            return this.wrapped;
        }

        public final void setWrapped(@Nullable IntArrayList intArrayList) {
            this.wrapped = intArrayList;
        }

        public final boolean hasNext() {
            return this.c != 0;
        }

        public final int nextEntry() {
            int n;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n2 = this.c;
            this.c = n2 + -1;
            if (this.mustReturnNullKey) {
                this.mustReturnNullKey = false;
                int it = n2 = Int2ObjectOpenHashMap.this.n;
                boolean bl = false;
                this.last = it;
                return n2;
            }
            int[] key = Int2ObjectOpenHashMap.this.key;
            do {
                this.pos += -1;
                if (this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                if (this.wrapped == null) {
                    throw new IllegalStateException();
                }
                IntArrayList intArrayList = this.wrapped;
                Intrinsics.checkNotNull((Object)intArrayList);
                int k = intArrayList.get(-this.pos - 1);
                int p = HashCommon.INSTANCE.mix(k) & Int2ObjectOpenHashMap.this.mask;
                while (k != key[p]) {
                    p = p + 1 & Int2ObjectOpenHashMap.this.mask;
                }
                return p;
            } while (key[this.pos] == 0);
            int it = n = this.pos;
            boolean bl = false;
            this.last = it;
            return n;
        }

        private final void shiftKeys(int pos) {
            int pos2 = pos;
            int last = 0;
            int slot = 0;
            int curr = 0;
            int[] key = Int2ObjectOpenHashMap.this.key;
            Object[] value = Int2ObjectOpenHashMap.this.value;
            while (true) {
                int n;
                int it = n = pos2;
                boolean bl = false;
                last = it;
                pos2 = n + 1 & Int2ObjectOpenHashMap.this.mask;
                while (true) {
                    it = n = key[pos2];
                    boolean bl2 = false;
                    curr = it;
                    if (n == 0) {
                        key[last] = 0;
                        value[last] = null;
                        return;
                    }
                    slot = HashCommon.INSTANCE.mix(curr) & Int2ObjectOpenHashMap.this.mask;
                    if (last <= pos2 ? last >= slot || slot > pos2 : (pos2 + 1 <= slot ? slot <= last : false)) break;
                    pos2 = pos2 + 1 & Int2ObjectOpenHashMap.this.mask;
                }
                if (pos2 < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new IntArrayList(2);
                    }
                    IntArrayList intArrayList = this.wrapped;
                    Intrinsics.checkNotNull((Object)intArrayList);
                    intArrayList.add(key[pos2]);
                }
                key[last] = curr;
                value[last] = value[pos2];
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap$ValueIterator;", "Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap$MapIterator;", "Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap;", "", "<init>", "(Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap;)V", "next", "()Ljava/lang/Object;", "intellij.platform.util.multiplatform"})
    private final class ValueIterator
    extends MapIterator
    implements Iterator<V>,
    KMappedMarker {
        @Override
        public V next() {
            Object object = Int2ObjectOpenHashMap.this.value[this.nextEntry()];
            Intrinsics.checkNotNull((Object)object);
            return object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

