/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import org.jetbrains.annotations.NotNull;

final class AsciiUtils {
    AsciiUtils() {
    }

    static int nextWordAscii(@NotNull String text, int start) {
        int i;
        if (text == null) {
            AsciiUtils.$$$reportNull$$$0(0);
        }
        if (!AsciiUtils.isLetterOrDigitAscii(text.charAt(start))) {
            return start + 1;
        }
        for (i = start; i < text.length() && AsciiUtils.isDigitAscii(text.charAt(i)); ++i) {
        }
        if (i > start) {
            return i;
        }
        while (i < text.length() && AsciiUtils.isUpperAscii(text.charAt(i))) {
            ++i;
        }
        if (i > start + 1) {
            if (i == text.length() || !AsciiUtils.isLetterAscii(text.charAt(i))) {
                return i;
            }
            return i - 1;
        }
        if (i == start) {
            ++i;
        }
        while (i < text.length() && AsciiUtils.isLetterAscii(text.charAt(i)) && !AsciiUtils.isWordStartAscii(text, i)) {
            ++i;
        }
        return i;
    }

    private static boolean isWordStartAscii(String text, int i) {
        char prev;
        char cur = text.charAt(i);
        char c = prev = i > 0 ? text.charAt(i - 1) : (char)'\u0000';
        if (AsciiUtils.isUpperAscii(cur)) {
            if (AsciiUtils.isUpperAscii(prev)) {
                int nextPos = i + 1;
                if (nextPos >= text.length()) {
                    return false;
                }
                return AsciiUtils.isLowerAscii(text.charAt(nextPos));
            }
            return true;
        }
        if (AsciiUtils.isDigitAscii(cur)) {
            return true;
        }
        if (!AsciiUtils.isLetterAscii(cur)) {
            return false;
        }
        return i == 0 || !AsciiUtils.isLetterOrDigitAscii(text.charAt(i - 1));
    }

    private static boolean isLetterAscii(char cur) {
        return cur >= 'a' && cur <= 'z' || cur >= 'A' && cur <= 'Z';
    }

    private static boolean isLetterOrDigitAscii(char cur) {
        return AsciiUtils.isLetterAscii(cur) || AsciiUtils.isDigitAscii(cur);
    }

    private static boolean isDigitAscii(char cur) {
        return cur >= '0' && cur <= '9';
    }

    static char toUpperAscii(char c) {
        if (c >= 'a' && c <= 'z') {
            return (char)(c + -32);
        }
        return c;
    }

    static char toLowerAscii(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c - -32);
        }
        return c;
    }

    static boolean isUpperAscii(char c) {
        return 'A' <= c && c <= 'Z';
    }

    static boolean isLowerAscii(char c) {
        return 'a' <= c && c <= 'z';
    }

    static boolean isAscii(@NotNull String string) {
        if (string == null) {
            AsciiUtils.$$$reportNull$$$0(1);
        }
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/AsciiUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "nextWordAscii";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAscii";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

