/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class ClickListener {
    private static final Logger LOG = Logger.getInstance(ClickListener.class);
    private static final int EPS = 4;
    private MouseAdapter myListener;

    public abstract boolean onClick(@NotNull MouseEvent var1, int var2);

    public void installOn(@NotNull Component c) {
        if (c == null) {
            ClickListener.$$$reportNull$$$0(0);
        }
        this.installOn(c, false);
    }

    public void installOn(@NotNull Component c, final boolean allowDragWhileClicking) {
        if (c == null) {
            ClickListener.$$$reportNull$$$0(1);
        }
        this.myListener = new MouseAdapter(){
            private Point pressPoint;
            private Point lastClickPoint;
            private long lastTimeClicked = -1L;
            private int clickCount = 0;

            @Override
            public void mousePressed(MouseEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.valueOf(ClickListener.this) + ": received " + String.valueOf(e));
                }
                Point point = e.getPoint();
                SwingUtilities.convertPointToScreen(point, e.getComponent());
                if (Math.abs(this.lastTimeClicked - e.getWhen()) > (long)UIUtil.getMultiClickInterval() || this.lastClickPoint != null && !ClickListener.isWithinEps(this.lastClickPoint, point)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.valueOf(ClickListener.this) + ": resetting click count");
                    }
                    this.clickCount = 0;
                    this.lastClickPoint = null;
                }
                ++this.clickCount;
                this.lastTimeClicked = e.getWhen();
                if (!e.isPopupTrigger()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.valueOf(ClickListener.this) + ": storing press point");
                    }
                    this.pressPoint = point;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Point clickedAt;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.valueOf(ClickListener.this) + " received " + String.valueOf(e));
                }
                Point releasedAt = e.getPoint();
                SwingUtilities.convertPointToScreen(releasedAt, e.getComponent());
                this.lastClickPoint = clickedAt = this.pressPoint;
                this.pressPoint = null;
                if (e.isConsumed() || clickedAt == null || e.isPopupTrigger() || !e.getComponent().contains(e.getPoint())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.valueOf(ClickListener.this) + " ignoring event");
                    }
                    return;
                }
                if ((allowDragWhileClicking || ClickListener.isWithinEps(releasedAt, clickedAt)) && ClickListener.this.onClick(e, this.clickCount)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.valueOf(ClickListener.this) + " processed event");
                    }
                    e.consume();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.valueOf(ClickListener.this) + " received " + String.valueOf(e));
                }
                if (e instanceof SyntheticClickEvent && !e.isConsumed() && ClickListener.this.onClick(e, e.getClickCount())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.valueOf(ClickListener.this) + " processed event");
                    }
                    e.consume();
                }
            }
        };
        c.addMouseListener(this.myListener);
    }

    private static boolean isWithinEps(Point releasedAt, Point clickedAt) {
        return Math.abs(clickedAt.x - releasedAt.x) < 4 && Math.abs(clickedAt.y - releasedAt.y) < 4;
    }

    public void uninstall(Component c) {
        c.removeMouseListener(this.myListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/ui/ClickListener", "installOn"));
    }

    @ApiStatus.Internal
    public static final class SyntheticClickEvent
    extends MouseEvent {
        public SyntheticClickEvent(Component source, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger, int button) {
            super(source, 500, when, modifiers, x, y, clickCount, popupTrigger, button);
        }
    }
}

