/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.accessibility;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AccessibleContextUtil {
    @ApiStatus.Internal
    public static final String PUNCTUATION_CHARACTER = ".";
    @ApiStatus.Internal
    public static final String PUNCTUATION_SEPARATOR = "  ";

    public static void setName(@NotNull Component component, @Nls String name) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(0);
        }
        AccessibleContextUtil.setAccessibleName(component, name);
    }

    public static void setName(@NotNull Component component, @NotNull Component source) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(1);
        }
        if (source == null) {
            AccessibleContextUtil.$$$reportNull$$$0(2);
        }
        AccessibleContextUtil.setName(component, AccessibleContextUtil.getAccessibleName(source));
    }

    public static void setCombinedName(@NotNull Component component, @Nullable Component j1, @NotNull @NlsSafe String separator, @Nullable Component j2) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(3);
        }
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(4);
        }
        AccessibleContextUtil.setAccessibleName(component, AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleName(j1), separator, AccessibleContextUtil.getAccessibleName(j2)));
    }

    public static void setCombinedName(@NotNull Component component, @Nullable Component j1, @NotNull @NlsSafe String separator1, @Nullable Component j2, @NotNull @NlsSafe String separator2, @Nullable Component j3) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(5);
        }
        if (separator1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(6);
        }
        if (separator2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(7);
        }
        AccessibleContextUtil.setAccessibleName(component, AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleName(j1), separator1, AccessibleContextUtil.getAccessibleName(j2), separator2, AccessibleContextUtil.getAccessibleName(j3)));
    }

    @Nls
    @Nullable
    public static String getCombinedName(@Nullable Component j1, @NotNull @NlsSafe String separator, @Nullable Component j2) {
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(8);
        }
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleName(j1), separator, AccessibleContextUtil.getAccessibleName(j2));
    }

    @Nls
    @Nullable
    public static String getCombinedName(@Nullable Component j1, @NotNull @NlsSafe String separator1, @Nullable Component j2, @NotNull @NlsSafe String separator2, @Nullable Component j3) {
        if (separator1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(9);
        }
        if (separator2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(10);
        }
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleName(j1), separator1, AccessibleContextUtil.getAccessibleName(j2), separator2, AccessibleContextUtil.getAccessibleName(j3));
    }

    @Nls
    @Nullable
    public static String getCombinedName(@NotNull @NlsSafe String separator, Component ... components) {
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(11);
        }
        String result = "";
        for (Component c : components) {
            result = AccessibleContextUtil.combineAccessibleStrings(result, separator, AccessibleContextUtil.getAccessibleName(c));
        }
        return result;
    }

    public static void setDescription(@NotNull Component component, @NotNull Component source) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(12);
        }
        if (source == null) {
            AccessibleContextUtil.$$$reportNull$$$0(13);
        }
        AccessibleContextUtil.setAccessibleDescription(component, AccessibleContextUtil.getAccessibleDescription(source));
    }

    public static void setDescription(@NotNull Component component, @Nls String description) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(14);
        }
        AccessibleContextUtil.setAccessibleDescription(component, description);
    }

    public static void setCombinedDescription(@NotNull Component component, @Nullable Component j1, @NotNull @NlsSafe String separator, @Nullable Component j2) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(15);
        }
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(16);
        }
        AccessibleContextUtil.setAccessibleDescription(component, AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleDescription(j1), separator, AccessibleContextUtil.getAccessibleDescription(j2)));
    }

    public static void setCombinedDescription(@NotNull Component component, @Nullable Component j1, @NotNull @NlsSafe String separator1, @Nullable Component j2, @NotNull @NlsSafe String separator2, @Nullable Component j3) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(17);
        }
        if (separator1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(18);
        }
        if (separator2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(19);
        }
        AccessibleContextUtil.setAccessibleDescription(component, AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleDescription(j1), separator1, AccessibleContextUtil.getAccessibleDescription(j2), separator2, AccessibleContextUtil.getAccessibleDescription(j3)));
    }

    public static String getCombinedDescription(@Nullable Component j1, @NotNull @NlsSafe String separator, @Nullable Component j2) {
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(20);
        }
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleDescription(j1), separator, AccessibleContextUtil.getAccessibleDescription(j2));
    }

    public static String getCombinedDescription(@Nullable Component j1, @NotNull @NlsSafe String separator1, @Nullable Component j2, @NotNull @NlsSafe String separator2, @Nullable Component j3) {
        if (separator1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(21);
        }
        if (separator2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(22);
        }
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleDescription(j1), separator1, AccessibleContextUtil.getAccessibleDescription(j2), separator2, AccessibleContextUtil.getAccessibleDescription(j3));
    }

    @Nullable
    @Nls
    public static String getUniqueDescription(@NotNull AccessibleContext context, @Nullable @Nls String description) {
        String name;
        if (context == null) {
            AccessibleContextUtil.$$$reportNull$$$0(23);
        }
        if (StringUtil.equals((CharSequence)description, (CharSequence)(name = context.getAccessibleName()))) {
            return null;
        }
        return description;
    }

    public static void setParent(@NotNull Component component, @Nullable Component newParent) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(24);
        }
        if (newParent instanceof Accessible) {
            component.getAccessibleContext().setAccessibleParent((Accessible)((Object)newParent));
            return;
        }
        component.getAccessibleContext().setAccessibleParent(null);
    }

    @Nullable
    @Nls
    public static String combineAccessibleStrings(@Nullable @Nls String s1, @Nullable @Nls String s2) {
        return AccessibleContextUtil.combineAccessibleStrings(s1, " ", s2);
    }

    @Nullable
    @Nls
    public static String combineAccessibleStrings(@Nullable @Nls String s1, @NotNull @NlsSafe String separator, @Nullable @Nls String s2) {
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(25);
        }
        if (StringUtil.isEmpty((String)s1) && StringUtil.isEmpty((String)s2)) {
            return null;
        }
        if (StringUtil.isEmpty((String)s1)) {
            return s2;
        }
        if (StringUtil.isEmpty((String)s2)) {
            return s1;
        }
        return s1 + separator + s2;
    }

    @Nullable
    @Nls
    public static String combineAccessibleStrings(@Nullable @Nls String s1, @NotNull @Nls String separator1, @Nullable @Nls String s2, @NotNull @Nls String separator2, @Nullable @Nls String s3) {
        if (separator1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(26);
        }
        if (separator2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(27);
        }
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.combineAccessibleStrings(s1, separator1, s2), separator2, s3);
    }

    @NotNull
    public static String replaceLineSeparatorsWithPunctuation(@Nullable String text) {
        if (StringUtil.isEmpty((String)text)) {
            return "";
        }
        String[] lines = StringUtil.splitByLines((String)text);
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String line : lines) {
            if (StringUtil.isEmpty((String)(line = line.trim()))) continue;
            if (first) {
                first = false;
            } else {
                result.append(PUNCTUATION_SEPARATOR);
            }
            result.append(line);
            if (line.endsWith(PUNCTUATION_CHARACTER)) continue;
            result.append(PUNCTUATION_CHARACTER);
        }
        String string = result.toString();
        if (string == null) {
            AccessibleContextUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nls
    @Nullable
    private static String getAccessibleName(@Nullable Component component) {
        if (component instanceof Accessible) {
            return component.getAccessibleContext().getAccessibleName();
        }
        return null;
    }

    private static void setAccessibleName(@NotNull Component component, @Nls String name) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(29);
        }
        if (component instanceof Accessible) {
            component.getAccessibleContext().setAccessibleName(name);
        }
    }

    @Nullable
    @Nls
    private static String getAccessibleDescription(@Nullable Component component) {
        if (component instanceof Accessible) {
            return component.getAccessibleContext().getAccessibleDescription();
        }
        return null;
    }

    private static void setAccessibleDescription(@NotNull Component component, @Nullable @Nls String description) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(30);
        }
        if (component instanceof Accessible) {
            component.getAccessibleContext().setAccessibleDescription(description);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 16: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 6: 
            case 9: 
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator1";
                break;
            }
            case 7: 
            case 10: 
            case 19: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator2";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/accessibility/AccessibleContextUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/accessibility/AccessibleContextUtil";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceLineSeparatorsWithPunctuation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCombinedName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCombinedName";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setCombinedDescription";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCombinedDescription";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueDescription";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "combineAccessibleStrings";
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setAccessibleName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setAccessibleDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 28 -> new IllegalStateException(string);
        };
    }
}

