/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.util.ui.JBFont;
import java.awt.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/intellij/ui/components/JBFontScaler;", "", "origFont", "Ljava/awt/Font;", "<init>", "(Ljava/awt/Font;)V", "originalDefaultSize", "", "currentDefaultSize", "getCurrentDefaultSize", "()I", "scaledFont", "intellij.platform.util.ui"})
public final class JBFontScaler {
    @NotNull
    private final Font origFont;
    private final int originalDefaultSize;

    public JBFontScaler(@NotNull Font origFont) {
        Intrinsics.checkNotNullParameter((Object)origFont, (String)"origFont");
        this.origFont = origFont;
        this.originalDefaultSize = JBFont.labelFontSize();
    }

    private final int getCurrentDefaultSize() {
        return JBFont.labelFontSize();
    }

    @NotNull
    public final Font scaledFont() {
        Font font;
        if (this.originalDefaultSize == this.getCurrentDefaultSize() || this.origFont instanceof JBFont) {
            font = this.origFont;
        } else {
            float newSize = this.origFont.getSize() == this.originalDefaultSize ? (float)this.getCurrentDefaultSize() : JBFont.scaleFontSize(this.origFont.getSize(), (float)this.getCurrentDefaultSize() / (float)this.originalDefaultSize);
            Font font2 = this.origFont.deriveFont(newSize);
            Intrinsics.checkNotNull((Object)font2);
            font = font2;
        }
        return font;
    }
}

