/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.components.JBComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class JBPanel<T extends JBPanel>
extends JPanel
implements JBComponent<T> {
    private Integer myPreferredWidth;
    private Integer myPreferredHeight;
    private Integer myMaximumWidth;
    private Integer myMaximumHeight;
    private Integer myMinimumWidth;
    private Integer myMinimumHeight;

    public JBPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public JBPanel(LayoutManager layout) {
        super(layout);
    }

    public JBPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public JBPanel() {
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform(this, super.getComponentGraphics(graphics));
    }

    @Override
    public final T withBorder(Border border) {
        this.setBorder(border);
        return (T)this;
    }

    @Override
    public final T withFont(JBFont font) {
        this.setFont(font);
        return (T)this;
    }

    @Override
    public final T andTransparent() {
        this.setOpaque(false);
        return (T)this;
    }

    @Override
    public final T andOpaque() {
        this.setOpaque(true);
        return (T)this;
    }

    public final T withBackground(@Nullable Color background) {
        this.setBackground(background);
        return (T)this;
    }

    public final T withPreferredWidth(int unscaledWidth) {
        this.myPreferredWidth = unscaledWidth;
        return (T)this;
    }

    public final T withPreferredHeight(int unscaledHeight) {
        this.myPreferredHeight = unscaledHeight;
        return (T)this;
    }

    public final T resetPreferredHeight() {
        this.myPreferredHeight = null;
        return (T)this;
    }

    public final T withPreferredSize(int unscaledWidth, int unscaledHeight) {
        this.myPreferredWidth = unscaledWidth;
        this.myPreferredHeight = unscaledHeight;
        return (T)this;
    }

    public final T withMaximumWidth(int unscaledWidth) {
        this.myMaximumWidth = unscaledWidth;
        return (T)this;
    }

    public final T withMaximumHeight(int unscaledHeight) {
        this.myMaximumHeight = unscaledHeight;
        return (T)this;
    }

    public final T withMaximumSize(int unscaledWidth, int unscaledHeight) {
        this.myMaximumWidth = unscaledWidth;
        this.myMaximumHeight = unscaledHeight;
        return (T)this;
    }

    public final T withMinimumWidth(int unscaledWidth) {
        this.myMinimumWidth = unscaledWidth;
        return (T)this;
    }

    public final T withMinimumHeight(int unscaledHeight) {
        this.myMinimumHeight = unscaledHeight;
        return (T)this;
    }

    @Override
    public Dimension getPreferredSize() {
        return JBPanel.getSize(super.getPreferredSize(), this.myPreferredWidth, this.myPreferredHeight, this.isPreferredSizeSet());
    }

    @Override
    public Dimension getMaximumSize() {
        return JBPanel.getSize(super.getMaximumSize(), this.myMaximumWidth, this.myMaximumHeight, this.isMaximumSizeSet());
    }

    @Override
    public Dimension getMinimumSize() {
        return JBPanel.getSize(super.getMinimumSize(), this.myMinimumWidth, this.myMinimumHeight, this.isMinimumSizeSet());
    }

    private static Dimension getSize(Dimension size, Integer unscaledWidth, Integer unscaledHeight, boolean isSet) {
        if (!isSet && size != null) {
            if (unscaledWidth != null) {
                size.width = JBUIScale.scale(unscaledWidth);
            }
            if (unscaledHeight != null) {
                size.height = JBUIScale.scale(unscaledHeight);
            }
        }
        return size;
    }
}

