/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageDataByPathLoaderKt;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.LoadIconParameters;
import com.intellij.ui.icons.RasterizedImageDataLoaderKt;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import java.awt.Image;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0016J\b\u0010!\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lcom/intellij/ui/icons/PatchedRasterizedImageDataLoader;", "Lcom/intellij/ui/icons/ImageDataLoader;", "path", "", "classLoaderRef", "Ljava/lang/ref/WeakReference;", "Ljava/lang/ClassLoader;", "flags", "", "<init>", "(Ljava/lang/String;Ljava/lang/ref/WeakReference;I)V", "getPath", "()Ljava/lang/String;", "getFlags", "()I", "getCoords", "Lkotlin/Pair;", "loadImage", "Ljava/awt/Image;", "parameters", "Lcom/intellij/ui/icons/LoadIconParameters;", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "patch", "transform", "Lcom/intellij/ui/icons/IconTransform;", "isMyClassLoader", "", "classLoader", "toString", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nRasterizedImageDataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RasterizedImageDataLoader.kt\ncom/intellij/ui/icons/PatchedRasterizedImageDataLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,309:1\n1#2:310\n23#3:311\n*S KotlinDebug\n*F\n+ 1 RasterizedImageDataLoader.kt\ncom/intellij/ui/icons/PatchedRasterizedImageDataLoader\n*L\n168#1:311\n*E\n"})
final class PatchedRasterizedImageDataLoader
implements ImageDataLoader {
    @NotNull
    private final String path;
    @NotNull
    private final WeakReference<ClassLoader> classLoaderRef;
    private final int flags;

    public PatchedRasterizedImageDataLoader(@NotNull String path, @NotNull WeakReference<ClassLoader> classLoaderRef, int flags) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(classLoaderRef, (String)"classLoaderRef");
        this.path = path;
        this.classLoaderRef = classLoaderRef;
        this.flags = flags;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    @Nullable
    public Pair<String, ClassLoader> getCoords() {
        Pair pair;
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        if (classLoader != null) {
            ClassLoader it = classLoader;
            boolean bl = false;
            pair = TuplesKt.to((Object)this.getPath(), (Object)it);
        } else {
            pair = null;
        }
        return pair;
    }

    @Override
    @Nullable
    public Image loadImage(@NotNull LoadIconParameters parameters, @NotNull ScaleContext scaleContext) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        if (classLoader == null) {
            return null;
        }
        ClassLoader classLoader2 = classLoader;
        try {
            String string;
            String string2;
            long start = StartUpMeasurer.getCurrentTimeIfEnabled();
            boolean isSvg = StringsKt.endsWith$default((String)this.getPath(), (String)".svg", (boolean)false, (int)2, null);
            float scale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
            int dotIndex = StringsKt.lastIndexOf$default((CharSequence)this.getPath(), (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotIndex < 0) {
                string2 = this.getPath();
            } else {
                String string3 = this.getPath().substring(0, dotIndex);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            }
            String name = string2;
            if (isSvg) {
                string = "svg";
            } else if (dotIndex < 0 || dotIndex == this.getPath().length() - 1) {
                string = "";
            } else {
                String string4 = this.getPath().substring(dotIndex + 1);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            }
            String ext = string;
            Image image = RasterizedImageDataLoaderKt.access$loadPatched(name, ext, isSvg, scale, scaleContext, parameters, this.getPath(), classLoader2, parameters.isDark);
            if (start != -1L) {
                IconLoadMeasurer.loadFromResources.end(start);
                IconLoadMeasurer.INSTANCE.addLoading(isSvg, start);
            }
            return image;
        }
        catch (IOException e) {
            PatchedRasterizedImageDataLoader $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PatchedRasterizedImageDataLoader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug((Throwable)e);
            return null;
        }
    }

    @Override
    @Nullable
    public URL getUrl() {
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        return classLoader != null ? classLoader.getResource(ImageDataByPathLoaderKt.normalizePath(this.getPath())) : null;
    }

    @Override
    @Nullable
    public ImageDataLoader patch(@NotNull IconTransform transform) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        return null;
    }

    @Override
    public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return this.classLoaderRef.get() == classLoader;
    }

    @NotNull
    public String toString() {
        return "PatchedRasterizedImageDataLoader(classLoader=" + this.classLoaderRef.get() + ", path=" + this.getPath() + ")";
    }
}

