/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.NewUiValue;
import com.intellij.util.ui.AvatarPalette;
import com.intellij.util.ui.AvatarPresentation;
import com.intellij.util.ui.ColorPalette;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.PaletteAvatarPresentation;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ/\u0010\u0004\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0007J \u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001a*\u00020\u00072\n\u0010\u001b\u001a\u00020\u001c\"\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0016\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007\u00a8\u0006!"}, d2={"Lcom/intellij/util/ui/AvatarUtils;", "", "<init>", "()V", "generateColoredAvatar", "Ljava/awt/image/BufferedImage;", "gradientSeed", "", "name", "size", "", "arcRatio", "", "palette", "Lcom/intellij/util/ui/ColorPalette;", "gc", "Ljava/awt/GraphicsConfiguration;", "presentation", "Lcom/intellij/util/ui/AvatarPresentation;", "generateColoredAvatar$intellij_platform_util_ui", "getFont", "Ljava/awt/Font;", "getNewUiFont", "initials", "text", "splitAtLeast2NonEmpty", "", "delimiters", "", "", "generateFromCamelCase", "firstName", "lastName", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nAvatarUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvatarUtils.kt\ncom/intellij/util/ui/AvatarUtils\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n434#2:244\n507#2,5:245\n434#2:258\n507#2,5:259\n413#2,4:268\n648#2,5:272\n456#2:277\n467#2:278\n1188#2,2:279\n468#2,2:281\n1190#2:283\n470#2:284\n1#3:250\n1563#4:251\n1634#4,3:252\n1563#4:255\n1634#4,2:256\n1636#4:264\n774#4:265\n865#4,2:266\n*S KotlinDebug\n*F\n+ 1 AvatarUtils.kt\ncom/intellij/util/ui/AvatarUtils\n*L\n143#1:244\n143#1:245,5\n165#1:258\n165#1:259,5\n173#1:268,4\n175#1:272,5\n177#1:277\n177#1:278\n177#1:279,2\n177#1:281,2\n177#1:283\n177#1:284\n160#1:251\n160#1:252,3\n164#1:255\n164#1:256,2\n164#1:264\n166#1:265\n166#1:266,2\n*E\n"})
public final class AvatarUtils {
    @NotNull
    public static final AvatarUtils INSTANCE = new AvatarUtils();

    private AvatarUtils() {
    }

    @NotNull
    public final BufferedImage generateColoredAvatar(@NotNull String gradientSeed, @NotNull String name, int size, double arcRatio, @NotNull ColorPalette palette) {
        Intrinsics.checkNotNullParameter((Object)gradientSeed, (String)"gradientSeed");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        PaletteAvatarPresentation presentation = new PaletteAvatarPresentation(name, gradientSeed, palette);
        return this.generateColoredAvatar$intellij_platform_util_ui(null, size, arcRatio, presentation);
    }

    public static /* synthetic */ BufferedImage generateColoredAvatar$default(AvatarUtils avatarUtils, String string, String string2, int n, double d, ColorPalette colorPalette, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 64;
        }
        if ((n2 & 8) != 0) {
            d = 0.0;
        }
        if ((n2 & 0x10) != 0) {
            colorPalette = AvatarPalette.INSTANCE;
        }
        return avatarUtils.generateColoredAvatar(string, string2, n, d, colorPalette);
    }

    @NotNull
    public final BufferedImage generateColoredAvatar$intellij_platform_util_ui(@Nullable GraphicsConfiguration gc, int size, double arcRatio, @NotNull AvatarPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        BufferedImage bufferedImage = ImageUtil.createImage(gc, size, size, 2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage image = bufferedImage;
        Graphics2D g2 = image.createGraphics();
        ImageUtil.applyQualityRenderingHints(g2);
        g2.setPaint(new GradientPaint(0.0f, size, presentation.getColor2(), size, 0.0f, presentation.getColor1()));
        double arcSize = arcRatio * (double)size;
        Area avatarOvalArea = new Area(new RoundRectangle2D.Double(0.0, 0.0, size, size, arcSize, arcSize));
        g2.fill(avatarOvalArea);
        g2.setPaint(Color.WHITE);
        g2.setFont(this.getFont(size));
        UIUtil.drawCenteredString(g2, new Rectangle(0, 0, size, size), presentation.getShortName());
        g2.dispose();
        return image;
    }

    private final Font getFont(int size) {
        Font font;
        if (NewUiValue.isEnabled()) {
            int fontSize = 13 * size / 20;
            font = this.getNewUiFont(fontSize);
        } else {
            JBFont jBFont = JBFont.create(new Font("Segoe UI", 0, (int)((double)size / 2.2)));
            Intrinsics.checkNotNull((Object)jBFont);
            font = jBFont;
        }
        return font;
    }

    private final Font getNewUiFont(int size) {
        Map attributes = new LinkedHashMap();
        attributes.put(TextAttribute.FAMILY, "JetBrains Mono");
        attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMIBOLD);
        JBFont jBFont = JBFont.create(Font.getFont(attributes)).deriveFont((float)size);
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"deriveFont(...)");
        return jBFont;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public final String initials(@NotNull String text) {
        void $this$mapTo$iv$iv;
        List words;
        Iterable<String> it;
        char[] it22;
        char[] cArray;
        char[] cArray2;
        char[] index$iv$iv2;
        List<String> $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String $this$filter$iv = text;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo22 = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv2 = 0; index$iv$iv2 < n; ++index$iv$iv2) {
            char element$iv$iv;
            char it22 = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv2);
            boolean bl = false;
            if (!(!Character.isHighSurrogate(it22) && !Character.isLowSurrogate(it22))) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String filtered = ((Object)StringsKt.trim((CharSequence)((StringBuilder)destination$iv$iv).toString())).toString();
        String camelCaseInitials = this.generateFromCamelCase(text);
        if (camelCaseInitials.length() == 2) {
            return camelCaseInitials;
        }
        char[] $i$f$filterTo22 = new char[]{' '};
        List<String> list = this.splitAtLeast2NonEmpty(filtered, $i$f$filterTo22);
        if (list == null && (list = this.splitAtLeast2NonEmpty(filtered, index$iv$iv2 = new char[]{','})) == null && (list = this.splitAtLeast2NonEmpty(filtered, cArray2 = new char[]{'-'})) == null && (list = this.splitAtLeast2NonEmpty(filtered, cArray = new char[]{'_'})) == null && (list = this.splitAtLeast2NonEmpty(filtered, it22 = new char[]{'.'})) == null) {
            it22 = new char[]{'`', '\'', '\"'};
            list = this.splitAtLeast2NonEmpty(filtered, it22);
        }
        if (($this$filterTo$iv$iv = list) != null) {
            it = $this$filterTo$iv$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{CollectionsKt.first(it), CollectionsKt.last(it)};
            v1 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            v1 = words = null;
        }
        if (words == null) {
            return camelCaseInitials;
        }
        Iterable $this$map$iv = words;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            String bl = (String)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(Character.valueOf(StringsKt.first((CharSequence)((CharSequence)it3))));
        }
        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitAtLeast2NonEmpty(String $this$splitAtLeast2NonEmpty, char ... delimiters) {
        List list;
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$splitAtLeast2NonEmpty, (char[])Arrays.copyOf(delimiters, delimiters.length), (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv2;
            void string;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void $this$filter$iv = string;
            boolean $i$f$filter = false;
            CharSequence charSequence = (CharSequence)$this$filter$iv;
            Appendable destination$iv$iv2 = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv2.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv2.charAt(index$iv$iv);
                boolean bl2 = false;
                if (!Character.isLetterOrDigit(it)) continue;
                destination$iv$iv2.append(element$iv$iv);
            }
            collection.add(((StringBuilder)destination$iv$iv2).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl3 = ((CharSequence)it).length() > 0;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        return it.size() >= 2 ? list : null;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateFromCamelCase(String text) {
        void $this$filterIndexedTo$iv$iv;
        String string;
        block4: {
            String string2;
            char it;
            int index$iv;
            int n;
            block3: {
                String $this$dropWhile$iv = text;
                boolean $i$f$dropWhile = false;
                n = ((CharSequence)$this$dropWhile$iv).length();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    it = $this$dropWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!Character.isLetter(it)) continue;
                    String string3 = $this$dropWhile$iv.substring(index$iv);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block3;
                }
                string2 = "";
            }
            String $this$takeWhile$iv = string2;
            boolean $i$f$takeWhile = false;
            n = $this$takeWhile$iv.length();
            for (index$iv = 0; index$iv < n; ++index$iv) {
                it = $this$takeWhile$iv.charAt(index$iv);
                int n2 = 0;
                if (Character.isLetterOrDigit(it)) continue;
                String it2 = $this$takeWhile$iv;
                n2 = 0;
                String string4 = it2.substring(n2, index$iv);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                break block4;
            }
            string = $this$takeWhile$iv;
        }
        String $this$filterIndexed$iv = string;
        boolean $i$f$filterIndexed = false;
        CharSequence index$iv = $this$filterIndexed$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv$iv$iv.length(); ++i) {
            void c;
            void element$iv$iv;
            char item$iv$iv$iv = $this$forEachIndexed$iv$iv$iv.charAt(i);
            int n = index$iv$iv$iv++;
            char c2 = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            void var15_20 = element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            if (!(index == 0 || Character.isUpperCase((char)c))) continue;
            destination$iv$iv.append((char)element$iv$iv);
        }
        String string5 = StringsKt.take((String)((StringBuilder)destination$iv$iv).toString(), (int)2).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
        return string5;
    }

    @NotNull
    public final String initials(@NotNull String firstName, @NotNull String lastName) {
        Intrinsics.checkNotNullParameter((Object)firstName, (String)"firstName");
        Intrinsics.checkNotNullParameter((Object)lastName, (String)"lastName");
        Object[] objectArray = new String[]{firstName, lastName};
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"", null, null, (int)0, null, AvatarUtils::initials$lambda$3, (int)30, null);
    }

    private static final CharSequence initials$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(StringsKt.first((CharSequence)it));
    }
}

