/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J3\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/util/ui/JBIconView;", "Ljavax/swing/text/View;", "elem", "Ljavax/swing/text/Element;", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljavax/swing/text/Element;Ljavax/swing/Icon;)V", "getPreferredSpan", "", "axis", "", "getAlignment", "getToolTipText", "", "x", "y", "allocation", "Ljava/awt/Shape;", "paint", "", "g", "Ljava/awt/Graphics;", "modelToView", "pos", "a", "b", "Ljavax/swing/text/Position$Bias;", "viewToModel", "bias", "", "(FFLjava/awt/Shape;[Ljavax/swing/text/Position$Bias;)I", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nExtendableHTMLViewFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtendableHTMLViewFactory.kt\ncom/intellij/util/ui/JBIconView\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,598:1\n19#2:599\n19#2:600\n19#2:601\n*S KotlinDebug\n*F\n+ 1 ExtendableHTMLViewFactory.kt\ncom/intellij/util/ui/JBIconView\n*L\n247#1:599\n257#1:600\n271#1:601\n*E\n"})
final class JBIconView
extends View {
    @NotNull
    private final Icon icon;

    public JBIconView(@NotNull Element elem, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        super(elem);
        this.icon = icon;
    }

    @Override
    public float getPreferredSpan(int axis) {
        Container $this$asSafely$iv = this.getContainer();
        boolean $i$f$asSafely = false;
        Container container = $this$asSafely$iv;
        if (!(container instanceof ExtendableHTMLViewFactory.ScaledHtmlJEditorPane)) {
            container = null;
        }
        ExtendableHTMLViewFactory.ScaledHtmlJEditorPane scaledHtmlJEditorPane = (ExtendableHTMLViewFactory.ScaledHtmlJEditorPane)((Object)container);
        float scaleFactor = scaledHtmlJEditorPane != null ? scaledHtmlJEditorPane.getContentsScaleFactor() : 1.0f;
        return switch (axis) {
            case 0 -> (float)this.icon.getIconWidth() * scaleFactor;
            case 1 -> (float)this.icon.getIconHeight() * scaleFactor;
            default -> throw new IllegalArgumentException("Invalid axis: " + axis);
        };
    }

    @Override
    public float getAlignment(int axis) {
        Container $this$asSafely$iv = this.getContainer();
        boolean $i$f$asSafely = false;
        Container container = $this$asSafely$iv;
        if (!(container instanceof ExtendableHTMLViewFactory.ScaledHtmlJEditorPane)) {
            container = null;
        }
        ExtendableHTMLViewFactory.ScaledHtmlJEditorPane scaledHtmlJEditorPane = (ExtendableHTMLViewFactory.ScaledHtmlJEditorPane)((Object)container);
        float scaleFactor = scaledHtmlJEditorPane != null ? scaledHtmlJEditorPane.getContentsScaleFactor() : 1.0f;
        int fontSize = this.getContainer().getFont().getSize();
        return axis == 1 ? (float)JBUIScale.scale(fontSize) / ((float)this.icon.getIconHeight() * scaleFactor) : super.getAlignment(axis);
    }

    @Override
    @Nullable
    public String getToolTipText(float x, float y, @NotNull Shape allocation) {
        Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
        Object object = this.getElement().getAttributes().getAttribute(HTML.Attribute.ALT);
        String string = object instanceof String ? (String)object : null;
        return string != null ? StringKt.nullize((String)string, (boolean)true) : null;
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull Shape allocation) {
        float scaleFactor;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
        Graphics2D g2d = (Graphics2D)g;
        Composite savedComposite = g2d.getComposite();
        g2d.setComposite(AlphaComposite.SrcOver);
        Container $this$asSafely$iv = this.getContainer();
        boolean $i$f$asSafely = false;
        Container container = $this$asSafely$iv;
        if (!(container instanceof ExtendableHTMLViewFactory.ScaledHtmlJEditorPane)) {
            container = null;
        }
        ExtendableHTMLViewFactory.ScaledHtmlJEditorPane scaledHtmlJEditorPane = (ExtendableHTMLViewFactory.ScaledHtmlJEditorPane)((Object)container);
        float f = scaleFactor = scaledHtmlJEditorPane != null ? scaledHtmlJEditorPane.getContentsScaleFactor() : 1.0f;
        Icon icon = this.icon instanceof ScalableIcon && !(scaleFactor == 1.0f) ? ((ScalableIcon)this.icon).scale(scaleFactor) : this.icon;
        Intrinsics.checkNotNull((Object)icon);
        Icon scaledIcon = icon;
        scaledIcon.paintIcon(null, g, allocation.getBounds().x, allocation.getBounds().y);
        g2d.setComposite(savedComposite);
    }

    @Override
    @NotNull
    public Shape modelToView(int pos, @NotNull Shape a, @NotNull Position.Bias b) throws BadLocationException {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        boolean bl = p0 <= pos ? pos <= p1 : false;
        if (bl) {
            Rectangle r = a.getBounds();
            if (pos == p1) {
                r.x += r.width;
            }
            r.width = 0;
            Intrinsics.checkNotNull((Object)r);
            return r;
        }
        throw new BadLocationException(pos + " not in range " + p0 + "," + p1, pos);
    }

    @Override
    public int viewToModel(float x, float y, @NotNull Shape a, @NotNull Position.Bias[] bias) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)bias, (String)"bias");
        Rectangle alloc = (Rectangle)a;
        if (x < (float)alloc.x + (float)alloc.width / 2.0f) {
            Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Forward, (String)"Forward");
            return this.getStartOffset();
        }
        Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Backward, (String)"Backward");
        return this.getEndOffset();
    }
}

