/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.util.ui.JBCachingScalableIcon;
import com.intellij.util.ui.RegionPainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\u0004\b\f\u0010\u000fB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\u0004\b\f\u0010\u0010B!\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\u0004\b\f\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0000H\u0016J*\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0003H\u0016J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/util/ui/RegionPaintIcon;", "Lcom/intellij/util/ui/JBCachingScalableIcon;", "width", "", "height", "top", "left", "bottom", "right", "painter", "Lcom/intellij/util/ui/RegionPainter;", "Ljava/awt/Component;", "<init>", "(IIIIIILcom/intellij/util/ui/RegionPainter;)V", "insets", "(IIILcom/intellij/util/ui/RegionPainter;)V", "(IILcom/intellij/util/ui/RegionPainter;)V", "size", "(ILcom/intellij/util/ui/RegionPainter;)V", "copy", "paintIcon", "", "c", "g", "Ljava/awt/Graphics;", "x", "y", "getIconWidth", "getIconHeight", "scaled", "toString", "", "hashCode", "equals", "", "other", "", "intellij.platform.util.ui"})
public final class RegionPaintIcon
extends JBCachingScalableIcon<RegionPaintIcon> {
    private final int width;
    private final int height;
    private final int top;
    private final int left;
    private final int bottom;
    private final int right;
    @NotNull
    private final RegionPainter<Component> painter;

    public RegionPaintIcon(int width, int height, int top, int left, int bottom, int right, @NotNull RegionPainter<Component> painter) {
        Intrinsics.checkNotNullParameter(painter, (String)"painter");
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.painter = painter;
    }

    public RegionPaintIcon(int width, int height, int insets, @NotNull RegionPainter<Component> painter) {
        Intrinsics.checkNotNullParameter(painter, (String)"painter");
        this(width, height, insets, insets, insets, insets, painter);
    }

    public RegionPaintIcon(int width, int height, @NotNull RegionPainter<Component> painter) {
        Intrinsics.checkNotNullParameter(painter, (String)"painter");
        this(width, height, 0, painter);
    }

    public RegionPaintIcon(int size, @NotNull RegionPainter<Component> painter) {
        Intrinsics.checkNotNullParameter(painter, (String)"painter");
        this(size, size, painter);
    }

    @Override
    @NotNull
    public RegionPaintIcon copy() {
        RegionPaintIcon icon = new RegionPaintIcon(this.width, this.height, this.top, this.left, this.bottom, this.right, this.painter);
        icon.updateContextFrom(this);
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (g instanceof Graphics2D) {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            Graphics graphics = g.create(x, y, width, height);
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2d = (Graphics2D)graphics;
            try {
                int dx = this.scaled(this.left);
                int dy = this.scaled(this.top);
                int dw = dx + this.scaled(this.right);
                int dh = dy + this.scaled(this.bottom);
                this.painter.paint(g2d, dx, dy, width - dw, height - dh, c);
            }
            finally {
                g2d.dispose();
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.scaled(this.width);
    }

    @Override
    public int getIconHeight() {
        return this.scaled(this.height);
    }

    private final int scaled(int size) {
        return size > 0 ? (int)Math.ceil(this.scaleVal(size)) : 0;
    }

    @Override
    @NotNull
    public String toString() {
        return this.painter.toString();
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.width, this.height, this.painter};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        RegionPaintIcon regionPaintIcon = other instanceof RegionPaintIcon ? (RegionPaintIcon)other : null;
        if (regionPaintIcon == null) {
            return false;
        }
        RegionPaintIcon icon = regionPaintIcon;
        return icon.width == this.width && icon.height == this.height && icon.top == this.top && icon.left == this.left && icon.right == this.right && icon.bottom == this.bottom && icon.scaleVal(1.0, DerivedScaleType.PIX_SCALE) == this.scaleVal(1.0, DerivedScaleType.PIX_SCALE) && Intrinsics.areEqual(icon.painter, this.painter);
    }
}

