/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.diagnostic.Checks;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColorHexUtil;
import com.intellij.ui.ColorMixture;
import com.intellij.ui.MixedColorProducer;
import com.intellij.util.MathUtil;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorUtil {
    private ColorUtil() {
    }

    @NotNull
    public static Color softer(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(0);
        }
        if (color.getBlue() > 220 && color.getRed() > 220 && color.getGreen() > 220) {
            Color color2 = color;
            if (color2 == null) {
                ColorUtil.$$$reportNull$$$0(1);
            }
            return color2;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color color3 = Color.getHSBColor(hsb[0], 0.6f * hsb[1], hsb[2]);
        if (color3 == null) {
            ColorUtil.$$$reportNull$$$0(2);
        }
        return color3;
    }

    @NotNull
    public static Color darker(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(3);
        }
        return ColorUtil.hackBrightness(color, tones, 0.9090909f);
    }

    @NotNull
    public static Color brighter(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(4);
        }
        return ColorUtil.hackBrightness(color, tones, 1.1f);
    }

    @NotNull
    public static Color tuneHue(@NotNull Color color, int howMuch, float hackValue) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(5);
        }
        return ColorUtil.tuneHSBComponent(color, 0, howMuch, hackValue);
    }

    @NotNull
    public static Color tuneSaturation(@NotNull Color color, int howMuch, float hackValue) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(6);
        }
        return ColorUtil.tuneHSBComponent(color, 1, howMuch, hackValue);
    }

    @NotNull
    public static Color tuneSaturationEspeciallyGrey(@NotNull Color color, int howMuch, float hackValue) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(7);
        }
        if (color.getRed() == color.getBlue() && color.getBlue() == color.getGreen()) {
            Color color2 = color.getGreen() <= 64 ? ColorUtil.shiftHSBComponent(color, 2, (float)howMuch * (1.0f - hackValue) / 1.5f) : (color.getGreen() >= 192 ? ColorUtil.shiftHSBComponent(color, 2, (float)howMuch * (hackValue - 1.0f) / 1.5f) : color);
            if (color2 == null) {
                ColorUtil.$$$reportNull$$$0(8);
            }
            return color2;
        }
        return ColorUtil.tuneHSBComponent(color, 1, howMuch, hackValue);
    }

    @NotNull
    public static Color hackBrightness(@NotNull Color color, int howMuch, float hackValue) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(9);
        }
        return ColorUtil.tuneHSBComponent(color, 2, howMuch, hackValue);
    }

    @NotNull
    private static Color tuneHSBComponent(@NotNull Color color, int componentIndex, int howMuch, float factor) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(10);
        }
        Checks.checkIndex((int)componentIndex, (int)3);
        Color color2 = new TuneHSBComponent(color, componentIndex, howMuch, factor).createColor(false);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(11);
        }
        return color2;
    }

    @NotNull
    private static Color shiftHSBComponent(@NotNull Color color, int componentIndex, float shift) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(12);
        }
        Checks.checkIndex((int)componentIndex, (int)3);
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        hsb[componentIndex] = MathUtil.clamp((float)(hsb[componentIndex] + shift), (float)0.0f, (float)1.0f);
        Color color2 = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(13);
        }
        return color2;
    }

    @NotNull
    public static Color saturate(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(14);
        }
        Color color2 = new Saturate(color, tones).createColor(false);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(15);
        }
        return color2;
    }

    @NotNull
    public static Color desaturate(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(16);
        }
        Color color2 = new Desaturate(color, tones).createColor(false);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(17);
        }
        return color2;
    }

    @NotNull
    public static Color dimmer(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(18);
        }
        Color color2 = new Dimmer(color).createColor(true);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(19);
        }
        return color2;
    }

    private static int shift(int colorComponent, double d) {
        int n = (int)((double)colorComponent * d);
        return n > 255 ? 255 : Math.max(n, 0);
    }

    @NotNull
    public static Color shift(@NotNull Color c, double d) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(20);
        }
        Color color = new Shift(c, d).createColor(true);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(21);
        }
        return color;
    }

    @NotNull
    public static Color withAlpha(@NotNull Color c, double a) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(22);
        }
        return ColorUtil.toAlpha(c, (int)(255.0 * a));
    }

    @NotNull
    public static Color withPreAlpha(@NotNull Color c, double a) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(23);
        }
        float[] rgba = new float[4];
        rgba = ColorUtil.withAlpha(c, a).getRGBComponents(rgba);
        return new Color(rgba[0] * rgba[3], rgba[1] * rgba[3], rgba[2] * rgba[3], 1.0f);
    }

    @NotNull
    public static Color toAlpha(@Nullable Color color, int a) {
        Color c = color == null ? Color.black : color;
        Color color2 = new ToAlpha(c, a).createColor(true);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(24);
        }
        return color2;
    }

    @NotNull
    public static String toHex(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(25);
        }
        return ColorUtil.toHex(c, false);
    }

    @NotNull
    public static String toHex(@NotNull Color c, boolean withAlpha) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(26);
        }
        String result = withAlpha ? Integer.toHexString(((c.getRGB() & 0xFFFFFF) << 8) + c.getAlpha()) : Integer.toHexString(c.getRGB() & 0xFFFFFF);
        int expectedLength = 6 + (withAlpha ? 2 : 0);
        String string = "0".repeat(expectedLength - result.length()) + result;
        if (string == null) {
            ColorUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String toHtmlColor(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(28);
        }
        String string = "#" + ColorUtil.toHex(c);
        if (string == null) {
            ColorUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static Color fromHex(@NotNull String str) {
        if (str == null) {
            ColorUtil.$$$reportNull$$$0(30);
        }
        Color color = ColorHexUtil.fromHex((String)str);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(31);
        }
        return color;
    }

    @Nullable
    public static Color fromHex(@Nullable String str, @Nullable Color defaultValue) {
        return ColorHexUtil.fromHex((String)str, (Color)defaultValue);
    }

    public static boolean isDark(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(32);
        }
        return (ColorUtil.getLuminance(c) + 0.05) / 0.05 < 4.5;
    }

    public static boolean areContrasting(@NotNull Color c1, @NotNull Color c2) {
        if (c1 == null) {
            ColorUtil.$$$reportNull$$$0(33);
        }
        if (c2 == null) {
            ColorUtil.$$$reportNull$$$0(34);
        }
        return Double.compare(ColorUtil.getContrast(c1, c2), 4.5) >= 0;
    }

    public static double getContrast(@NotNull Color c1, @NotNull Color c2) {
        if (c1 == null) {
            ColorUtil.$$$reportNull$$$0(35);
        }
        if (c2 == null) {
            ColorUtil.$$$reportNull$$$0(36);
        }
        double l1 = ColorUtil.getLuminance(c1);
        double l2 = ColorUtil.getLuminance(c2);
        return (Math.max(l1, l2) + 0.05) / (Math.min(l2, l1) + 0.05);
    }

    public static double getLuminance(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(37);
        }
        return ColorUtil.getLinearRGBComponentValue((double)color.getRed() / 255.0) * 0.2126 + ColorUtil.getLinearRGBComponentValue((double)color.getGreen() / 255.0) * 0.7152 + ColorUtil.getLinearRGBComponentValue((double)color.getBlue() / 255.0) * 0.0722;
    }

    private static double getLinearRGBComponentValue(double colorValue) {
        if (colorValue <= 0.03928) {
            return colorValue / 12.92;
        }
        return Math.pow((colorValue + 0.055) / 1.055, 2.4);
    }

    @NotNull
    public static Color mix(@NotNull Color c1, @NotNull Color c2, double balance) {
        if (c1 == null) {
            ColorUtil.$$$reportNull$$$0(38);
        }
        if (c2 == null) {
            ColorUtil.$$$reportNull$$$0(39);
        }
        if (balance <= 0.0) {
            Color color = c1;
            if (color == null) {
                ColorUtil.$$$reportNull$$$0(40);
            }
            return color;
        }
        if (balance >= 1.0) {
            Color color = c2;
            if (color == null) {
                ColorUtil.$$$reportNull$$$0(41);
            }
            return color;
        }
        Color color = new Mix(c1, c2, balance).createColor(true);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(42);
        }
        return color;
    }

    @NotNull
    public static Color alphaBlending(@NotNull Color foreground, @NotNull Color background) {
        if (foreground == null) {
            ColorUtil.$$$reportNull$$$0(43);
        }
        if (background == null) {
            ColorUtil.$$$reportNull$$$0(44);
        }
        Color color = new AlphaBlending(foreground, background).createColor(false);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(45);
        }
        return color;
    }

    private static int alphaBlendingComponent(int foregroundComponent, int foregroundAlpha, int backgroundComponent, int backgroundAlpha) {
        int denominator = 65025 - (255 - foregroundAlpha) * (255 - backgroundAlpha);
        if (denominator == 0) {
            return 0;
        }
        return (255 * foregroundAlpha * foregroundComponent + (255 - foregroundAlpha) * backgroundAlpha * backgroundComponent) / denominator;
    }

    @NotNull
    public static Color blendColorsInRgb(@NotNull Color bg, @NotNull Color fg, double value) {
        if (bg == null) {
            ColorUtil.$$$reportNull$$$0(46);
        }
        if (fg == null) {
            ColorUtil.$$$reportNull$$$0(47);
        }
        Color color = new BlendColorsInRgb(bg, fg, value).createColor(false);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(48);
        }
        return color;
    }

    private static int blendRgb(int bg, int fg, double value) {
        return (int)Math.round(Math.sqrt((double)(bg * bg) * (1.0 - value) + (double)(fg * fg) * value));
    }

    @NotNull
    public static Color worstContrastColor(@NotNull Color foreground, @NotNull Color background) {
        if (foreground == null) {
            ColorUtil.$$$reportNull$$$0(49);
        }
        if (background == null) {
            ColorUtil.$$$reportNull$$$0(50);
        }
        int backgroundAlpha = background.getAlpha();
        int r = ColorUtil.worstContrastComponent(foreground.getRed(), background.getRed(), backgroundAlpha);
        int g = ColorUtil.worstContrastComponent(foreground.getGreen(), background.getGreen(), backgroundAlpha);
        int b = ColorUtil.worstContrastComponent(foreground.getBlue(), background.getBlue(), backgroundAlpha);
        return new Color(r, g, b);
    }

    private static int worstContrastComponent(int foregroundComponent, int backgroundComponent, int backgroundAlpha) {
        if (backgroundAlpha == 255) {
            return 0;
        }
        int component = (255 * foregroundComponent - backgroundAlpha * backgroundComponent) / (255 - backgroundAlpha);
        return Math.max(0, Math.min(component, 255));
    }

    public static double calculateContrastRatio(@NotNull Color color1, @NotNull Color color2) {
        if (color1 == null) {
            ColorUtil.$$$reportNull$$$0(51);
        }
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(52);
        }
        double color1Luminance = ColorUtil.calculateColorLuminance(color1);
        double color2Luminance = ColorUtil.calculateColorLuminance(color2);
        return (Math.max(color1Luminance, color2Luminance) + 0.05) / (Math.min(color2Luminance, color1Luminance) + 0.05);
    }

    private static double calculateColorLuminance(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(53);
        }
        return ColorUtil.calculateLuminanceContribution((double)color.getRed() / 255.0) * 0.2126 + ColorUtil.calculateLuminanceContribution((double)color.getGreen() / 255.0) * 0.7152 + ColorUtil.calculateLuminanceContribution((double)color.getBlue() / 255.0) * 0.0722;
    }

    private static double calculateLuminanceContribution(double colorValue) {
        if (colorValue <= 0.03928) {
            return colorValue / 12.92;
        }
        return Math.pow((colorValue + 0.055) / 1.055, 2.4);
    }

    public static double getColorDistance(Color c1, Color c2) {
        double rmean = (double)(c1.getRed() + c2.getRed()) / 2.0;
        int r = c1.getRed() - c2.getRed();
        int g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return Math.sqrt(weightR * (double)r * (double)r + weightG * (double)g * (double)g + weightB * (double)b * (double)b);
    }

    @NotNull
    public static Color faded(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(54);
        }
        return ColorUtil.withAlpha(color, 0.45f);
    }

    @ApiStatus.Experimental
    @NotNull
    public static Color editorFaded(@NotNull Color color, boolean darkEditor) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(55);
        }
        return ColorUtil.withAlpha(color, darkEditor ? (double)0.6f : 0.5);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 8, 11, 13, 15, 17, 19, 21, 24, 27, 29, 31, 40, 41, 42, 45, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ColorUtil";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 33: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 34: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreground";
                break;
            }
            case 44: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fg";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color1";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ColorUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "softer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "tuneSaturationEspeciallyGrey";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "tuneHSBComponent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftHSBComponent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "saturate";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "desaturate";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "dimmer";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "shift";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toAlpha";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "toHex";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtmlColor";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "fromHex";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "mix";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "alphaBlending";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "blendColorsInRgb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "softer";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 48: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "darker";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "brighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tuneHue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tuneSaturation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tuneSaturationEspeciallyGrey";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hackBrightness";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tuneHSBComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shiftHSBComponent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saturate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "desaturate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "dimmer";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shift";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "withAlpha";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "withPreAlpha";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "toHex";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "toHtmlColor";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fromHex";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isDark";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "areContrasting";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getContrast";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLuminance";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "mix";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "alphaBlending";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "blendColorsInRgb";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "worstContrastColor";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "calculateContrastRatio";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "calculateColorLuminance";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "faded";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "editorFaded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 8, 11, 13, 15, 17, 19, 21, 24, 27, 29, 31, 40, 41, 42, 45, 48 -> new IllegalStateException(string);
        };
    }

    private static class TuneHSBComponent
    extends ColorMixture {
        @NotNull
        private final Color color;
        private final int componentIndex;
        private final int howMuch;
        private final float factor;

        private TuneHSBComponent(@NotNull Color color, int componentIndex, int howMuch, float factor) {
            if (color == null) {
                TuneHSBComponent.$$$reportNull$$$0(0);
            }
            super("tuneHSBComponent");
            this.color = color;
            this.componentIndex = componentIndex;
            this.howMuch = howMuch;
            this.factor = factor;
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull Object> getArgs() {
            List<Object> list = List.of(this.color, Integer.valueOf(this.componentIndex), Integer.valueOf(this.howMuch), Float.valueOf(this.factor));
            if (list == null) {
                TuneHSBComponent.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public Color get() {
            float[] hsb = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
            float component = hsb[this.componentIndex];
            for (int i = 0; i < this.howMuch && (component = MathUtil.clamp((float)(this.factor * component), (float)0.0f, (float)1.0f)) != 0.0f && component != 1.0f; ++i) {
            }
            hsb[this.componentIndex] = component;
            Color color = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
            if (color == null) {
                TuneHSBComponent.$$$reportNull$$$0(2);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/ColorUtil$TuneHSBComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/ColorUtil$TuneHSBComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgs";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class Saturate
    extends ColorMixture {
        @NotNull
        private final Color color;
        private final int tones;

        private Saturate(@NotNull Color color, int tones) {
            if (color == null) {
                Saturate.$$$reportNull$$$0(0);
            }
            super("saturate");
            this.color = color;
            this.tones = tones;
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull Object> getArgs() {
            List<Object> list = List.of(this.color, Integer.valueOf(this.tones));
            if (list == null) {
                Saturate.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public Color get() {
            float[] hsb = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
            float saturation = hsb[1];
            for (int i = 0; i < this.tones && (saturation = Math.min(1.0f, saturation * 1.1f)) != 1.0f; ++i) {
            }
            Color color = Color.getHSBColor(hsb[0], saturation, hsb[2]);
            if (color == null) {
                Saturate.$$$reportNull$$$0(2);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/ColorUtil$Saturate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/ColorUtil$Saturate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgs";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class Desaturate
    extends ColorMixture {
        @NotNull
        private final Color color;
        private final int tones;

        private Desaturate(@NotNull Color color, int tones) {
            if (color == null) {
                Desaturate.$$$reportNull$$$0(0);
            }
            super("desaturate");
            this.color = color;
            this.tones = tones;
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull Object> getArgs() {
            List<Object> list = List.of(this.color, Integer.valueOf(this.tones));
            if (list == null) {
                Desaturate.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public Color get() {
            float[] hsb = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
            float saturation = hsb[1];
            for (int i = 0; i < this.tones && (saturation = Math.max(0.0f, saturation / 1.1f)) != 0.0f; ++i) {
            }
            Color color = Color.getHSBColor(hsb[0], saturation, hsb[2]);
            if (color == null) {
                Desaturate.$$$reportNull$$$0(2);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/ColorUtil$Desaturate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/ColorUtil$Desaturate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgs";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class Dimmer
    extends ColorMixture {
        @NotNull
        private final Color color;

        private Dimmer(@NotNull Color color) {
            if (color == null) {
                Dimmer.$$$reportNull$$$0(0);
            }
            super("dimmer");
            this.color = color;
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull Object> getArgs() {
            List<Object> list = List.of(this.color);
            if (list == null) {
                Dimmer.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public Color get() {
            float[] rgb = this.color.getRGBColorComponents(null);
            float alpha = 0.8f;
            float rem = 1.0f - alpha;
            return new Color(rgb[0] * alpha + rem, rgb[1] * alpha + rem, rgb[2] * alpha + rem);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/ColorUtil$Dimmer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/ColorUtil$Dimmer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class Shift
    extends ColorMixture {
        @NotNull
        private final Color color;
        private final double d;

        private Shift(@NotNull Color color, double d) {
            if (color == null) {
                Shift.$$$reportNull$$$0(0);
            }
            super("shift");
            this.color = color;
            this.d = d;
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull Object> getArgs() {
            List<Object> list = List.of(this.color, Double.valueOf(this.d));
            if (list == null) {
                Shift.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public Color get() {
            return new Color(ColorUtil.shift(this.color.getRed(), this.d), ColorUtil.shift(this.color.getGreen(), this.d), ColorUtil.shift(this.color.getBlue(), this.d), this.color.getAlpha());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/ColorUtil$Shift";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/ColorUtil$Shift";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class ToAlpha
    extends ColorMixture {
        @NotNull
        private final Color color;
        private final int alpha;

        private ToAlpha(@NotNull Color color, int alpha) {
            if (color == null) {
                ToAlpha.$$$reportNull$$$0(0);
            }
            super("toAlpha");
            this.color = color;
            this.alpha = alpha;
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull Object> getArgs() {
            List<Object> list = List.of(this.color, Integer.valueOf(this.alpha));
            if (list == null) {
                ToAlpha.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public Color get() {
            return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.alpha);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/ColorUtil$ToAlpha";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/ColorUtil$ToAlpha";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class Mix
    extends ColorMixture {
        @NotNull
        private final Color color1;
        @NotNull
        private final Color color2;
        private final double balance;
        private final MixedColorProducer producer;

        private Mix(@NotNull Color color1, @NotNull Color color2, double balance) {
            if (color1 == null) {
                Mix.$$$reportNull$$$0(0);
            }
            if (color2 == null) {
                Mix.$$$reportNull$$$0(1);
            }
            super("mix");
            this.color1 = color1;
            this.color2 = color2;
            this.balance = balance;
            this.producer = new MixedColorProducer(color1, color2);
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull Object> getArgs() {
            List<Object> list = List.of(this.color1, this.color2, Double.valueOf(this.balance));
            if (list == null) {
                Mix.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @NotNull
        public Color get() {
            Color color = this.producer.produce(this.balance);
            if (color == null) {
                Mix.$$$reportNull$$$0(3);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color2";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/ColorUtil$Mix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/ColorUtil$Mix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgs";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class AlphaBlending
    extends ColorMixture {
        @NotNull
        private final Color foreground;
        @NotNull
        private final Color background;

        private AlphaBlending(@NotNull Color foreground, @NotNull Color background) {
            if (foreground == null) {
                AlphaBlending.$$$reportNull$$$0(0);
            }
            if (background == null) {
                AlphaBlending.$$$reportNull$$$0(1);
            }
            super("alphaBlending");
            this.foreground = foreground;
            this.background = background;
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull Object> getArgs() {
            List<Object> list = List.of(this.foreground, this.background);
            if (list == null) {
                AlphaBlending.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @NotNull
        public Color get() {
            return new Color(ColorUtil.alphaBlendingComponent(this.foreground.getRed(), this.foreground.getAlpha(), this.background.getRed(), this.background.getAlpha()), ColorUtil.alphaBlendingComponent(this.foreground.getGreen(), this.foreground.getAlpha(), this.background.getGreen(), this.background.getAlpha()), ColorUtil.alphaBlendingComponent(this.foreground.getBlue(), this.foreground.getAlpha(), this.background.getBlue(), this.background.getAlpha()), (65025 - (255 - this.background.getAlpha()) * (255 - this.foreground.getAlpha())) / 255);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foreground";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "background";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/ColorUtil$AlphaBlending";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/ColorUtil$AlphaBlending";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class BlendColorsInRgb
    extends ColorMixture {
        @NotNull
        private final Color background;
        @NotNull
        private final Color foreground;
        private final double value;

        private BlendColorsInRgb(@NotNull Color background, @NotNull Color foreground, double value) {
            if (background == null) {
                BlendColorsInRgb.$$$reportNull$$$0(0);
            }
            if (foreground == null) {
                BlendColorsInRgb.$$$reportNull$$$0(1);
            }
            super("colorBlendInRgb");
            this.background = background;
            this.foreground = foreground;
            this.value = value;
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull Object> getArgs() {
            List<Object> list = List.of(this.background, this.foreground, Double.valueOf(this.value));
            if (list == null) {
                BlendColorsInRgb.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @NotNull
        public Color get() {
            Color bg = this.background;
            Color fg = this.foreground;
            int red = ColorUtil.blendRgb(bg.getRed(), fg.getRed(), this.value);
            int green = ColorUtil.blendRgb(bg.getGreen(), fg.getGreen(), this.value);
            int blue = ColorUtil.blendRgb(bg.getBlue(), fg.getBlue(), this.value);
            return new Color(MathUtil.clamp((int)red, (int)0, (int)255), MathUtil.clamp((int)green, (int)0, (int)255), MathUtil.clamp((int)blue, (int)0, (int)255));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "background";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foreground";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/ColorUtil$BlendColorsInRgb";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/ColorUtil$BlendColorsInRgb";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

