/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScreenUtil {
    public static final String DISPOSE_TEMPORARY = "dispose.temporary";
    private static final @Nullable Map<@NotNull GraphicsConfiguration, @NotNull Pair<@NotNull Insets, @NotNull Long>> insetCache = Boolean.getBoolean("ide.cache.screen.insets") ? new WeakHashMap() : null;
    private static final int ourInsetsTimeout = SystemProperties.getIntProperty((String)"ide.insets.cache.timeout", (int)5000);

    private ScreenUtil() {
    }

    public static boolean isVisible(@NotNull Point location) {
        if (location == null) {
            ScreenUtil.$$$reportNull$$$0(0);
        }
        return ScreenUtil.getScreenRectangle(location).contains(location);
    }

    public static boolean isVisible(@NotNull Rectangle bounds) {
        Rectangle[] allScreenBounds;
        if (bounds == null) {
            ScreenUtil.$$$reportNull$$$0(1);
        }
        if (bounds.isEmpty()) {
            return false;
        }
        for (Rectangle screenBounds : allScreenBounds = ScreenUtil.getAllScreenBounds()) {
            int sq2;
            int sq1;
            double visibleFraction;
            Rectangle intersection = screenBounds.intersection(bounds);
            if (intersection.isEmpty() || !((visibleFraction = (double)(sq1 = intersection.width * intersection.height) / (double)(sq2 = bounds.width * bounds.height)) > 0.1)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Rectangle getMainScreenBounds() {
        return ScreenUtil.getScreenRectangle(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    @NotNull
    private static @NotNull Rectangle @NotNull [] getAllScreenBounds() {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Rectangle[] result = new Rectangle[devices.length];
        for (int i = 0; i < devices.length; ++i) {
            result[i] = ScreenUtil.getScreenRectangle(devices[i]);
        }
        if (result == null) {
            ScreenUtil.$$$reportNull$$$0(2);
        }
        return result;
    }

    @NotNull
    public static Shape getAllScreensShape() {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (devices.length == 0) {
            return new Rectangle();
        }
        if (devices.length == 1) {
            return ScreenUtil.getScreenRectangle(devices[0]);
        }
        Area area = new Area();
        for (GraphicsDevice device : devices) {
            area.add(new Area(ScreenUtil.getScreenRectangle(device)));
        }
        Area area2 = area;
        if (area2 == null) {
            ScreenUtil.$$$reportNull$$$0(3);
        }
        return area2;
    }

    @NotNull
    public static Rectangle getAllScreensRectangle() {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (devices.length == 0) {
            return new Rectangle();
        }
        if (devices.length == 1) {
            return ScreenUtil.getScreenRectangle(devices[0]);
        }
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        for (GraphicsDevice device : devices) {
            int y;
            Rectangle rectangle = ScreenUtil.getScreenRectangle(device);
            int x = rectangle.x;
            if (minX > x) {
                minX = x;
            }
            if (maxX < (x += rectangle.width)) {
                maxX = x;
            }
            if (minY > (y = rectangle.y)) {
                minY = y;
            }
            if (maxY >= (y += rectangle.height)) continue;
            maxY = y;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    @NotNull
    public static Rectangle getScreenRectangle(@NotNull Point p) {
        if (p == null) {
            ScreenUtil.$$$reportNull$$$0(4);
        }
        return ScreenUtil.getScreenRectangle(p.x, p.y);
    }

    @NotNull
    public static Rectangle getScreenRectangle(@NotNull Component component) {
        GraphicsConfiguration configuration;
        if (component == null) {
            ScreenUtil.$$$reportNull$$$0(5);
        }
        if ((configuration = component.getGraphicsConfiguration()) != null) {
            return ScreenUtil.getScreenRectangle(configuration);
        }
        Point p = new Point();
        SwingUtilities.convertPointToScreen(p, component);
        return ScreenUtil.getScreenRectangle(p);
    }

    @Nullable
    public static GraphicsDevice getScreenDevice(@NotNull Rectangle bounds) {
        if (bounds == null) {
            ScreenUtil.$$$reportNull$$$0(6);
        }
        GraphicsDevice candidate = null;
        int maxIntersection = 0;
        for (GraphicsDevice device : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration config = device.getDefaultConfiguration();
            Rectangle rect = config.getBounds();
            Rectangle intersection = rect.intersection(bounds);
            if (intersection.isEmpty() || intersection.width * intersection.height <= maxIntersection) continue;
            maxIntersection = intersection.width * intersection.height;
            candidate = device;
        }
        return candidate;
    }

    public static boolean isStandardAddRemoveNotify(@Nullable Component component) {
        JRootPane rootPane = ScreenUtil.findMainRootPane(component);
        return rootPane == null || rootPane.getClientProperty(DISPOSE_TEMPORARY) == null;
    }

    @Nullable
    private static JRootPane findMainRootPane(@Nullable Component component) {
        while (component != null) {
            Container parent = component.getParent();
            if (parent == null) {
                return component instanceof RootPaneContainer ? ((RootPaneContainer)((Object)component)).getRootPane() : null;
            }
            component = parent;
        }
        return null;
    }

    @NotNull
    private static Rectangle applyInsets(@NotNull Rectangle rect, @Nullable Insets i) {
        if (rect == null) {
            ScreenUtil.$$$reportNull$$$0(7);
        }
        rect = new Rectangle(rect);
        JBInsets.removeFrom(rect, i);
        Rectangle rectangle = rect;
        if (rectangle == null) {
            ScreenUtil.$$$reportNull$$$0(8);
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static Insets getScreenInsets(@NotNull GraphicsConfiguration gc) {
        if (gc == null) {
            ScreenUtil.$$$reportNull$$$0(9);
        }
        if (insetCache == null) {
            return ScreenUtil.calcInsets(gc);
        }
        Map<GraphicsConfiguration, Pair<Insets, Long>> map = insetCache;
        // MONITORENTER : map
        Pair data = insetCache.get(gc);
        long now = System.currentTimeMillis();
        if (data == null || now > (Long)data.second + (long)ourInsetsTimeout) {
            data = new Pair((Object)ScreenUtil.calcInsets(gc), (Object)now);
            insetCache.put(gc, (Pair<Insets, Long>)data);
        }
        Insets insets = (Insets)data.first;
        // MONITOREXIT : map
        if (insets != null) return insets;
        ScreenUtil.$$$reportNull$$$0(10);
        return insets;
    }

    @NotNull
    private static Insets calcInsets(GraphicsConfiguration gc) {
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        if (insets == null) {
            ScreenUtil.$$$reportNull$$$0(11);
        }
        return insets;
    }

    @NotNull
    private static Rectangle getScreenRectangle(@NotNull GraphicsDevice device) {
        if (device == null) {
            ScreenUtil.$$$reportNull$$$0(12);
        }
        return ScreenUtil.getScreenRectangle(device.getDefaultConfiguration());
    }

    @NotNull
    public static Rectangle getScreenRectangle(@NotNull GraphicsConfiguration configuration) {
        if (configuration == null) {
            ScreenUtil.$$$reportNull$$$0(13);
        }
        return ScreenUtil.applyInsets(configuration.getBounds(), ScreenUtil.getScreenInsets(configuration));
    }

    @NotNull
    public static Rectangle getScreenRectangle(int x, int y) {
        if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
            return new Rectangle(x, y, 0, 0);
        }
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (devices.length == 0) {
            return new Rectangle(x, y, 0, 0);
        }
        if (devices.length == 1) {
            return ScreenUtil.getScreenRectangle(devices[0]);
        }
        Rectangle[] rectangles = new Rectangle[devices.length];
        for (int i = 0; i < devices.length; ++i) {
            GraphicsConfiguration configuration = devices[i].getDefaultConfiguration();
            Rectangle bounds = configuration.getBounds();
            rectangles[i] = ScreenUtil.applyInsets(bounds, ScreenUtil.getScreenInsets(configuration));
            if (!bounds.contains(x, y)) continue;
            Rectangle rectangle = rectangles[i];
            if (rectangle == null) {
                ScreenUtil.$$$reportNull$$$0(14);
            }
            return rectangle;
        }
        Rectangle bounds = rectangles[0];
        int minimum = ScreenUtil.distance(bounds, x, y);
        if (bounds.width == 0 || bounds.height == 0) {
            minimum = Integer.MAX_VALUE;
        }
        for (int i = 1; i < rectangles.length; ++i) {
            int distance;
            if (rectangles[i].width == 0 || rectangles[i].height == 0 || minimum <= (distance = ScreenUtil.distance(rectangles[i], x, y))) continue;
            minimum = distance;
            bounds = rectangles[i];
        }
        if (bounds.width == 0 || bounds.height == 0) {
            return new Rectangle(x, y, 0, 0);
        }
        Rectangle rectangle = bounds;
        if (rectangle == null) {
            ScreenUtil.$$$reportNull$$$0(15);
        }
        return rectangle;
    }

    private static int normalize(int value, int min, int max) {
        return value < min ? min : Math.min(value, max);
    }

    private static int distance(@NotNull Rectangle bounds, int x, int y) {
        if (bounds == null) {
            ScreenUtil.$$$reportNull$$$0(16);
        }
        x -= ScreenUtil.normalize(x, bounds.x, bounds.x + bounds.width);
        y -= ScreenUtil.normalize(y, bounds.y, bounds.y + bounds.height);
        return x * x + y * y;
    }

    public static void moveAndScale(@NotNull Point location, @NotNull Rectangle fromScreen, @NotNull Rectangle toScreen) {
        if (location == null) {
            ScreenUtil.$$$reportNull$$$0(17);
        }
        if (fromScreen == null) {
            ScreenUtil.$$$reportNull$$$0(18);
        }
        if (toScreen == null) {
            ScreenUtil.$$$reportNull$$$0(19);
        }
        ScreenUtil.checkScreensNonEmpty(fromScreen, toScreen);
        double kw = toScreen.getWidth() / fromScreen.getWidth();
        double kh = toScreen.getHeight() / fromScreen.getHeight();
        location.setLocation((double)toScreen.x + (double)(location.x - fromScreen.x) * kw, (double)toScreen.y + (double)(location.y - fromScreen.y) * kh);
    }

    public static void moveAndScale(@NotNull Dimension size, @NotNull Rectangle fromScreen, @NotNull Rectangle toScreen) {
        if (size == null) {
            ScreenUtil.$$$reportNull$$$0(20);
        }
        if (fromScreen == null) {
            ScreenUtil.$$$reportNull$$$0(21);
        }
        if (toScreen == null) {
            ScreenUtil.$$$reportNull$$$0(22);
        }
        ScreenUtil.checkScreensNonEmpty(fromScreen, toScreen);
        double kw = toScreen.getWidth() / fromScreen.getWidth();
        double kh = toScreen.getHeight() / fromScreen.getHeight();
        size.setSize((double)size.width * kw, (double)size.height * kh);
    }

    public static void moveAndScale(@NotNull Rectangle bounds, @NotNull Rectangle fromScreen, @NotNull Rectangle toScreen) {
        if (bounds == null) {
            ScreenUtil.$$$reportNull$$$0(23);
        }
        if (fromScreen == null) {
            ScreenUtil.$$$reportNull$$$0(24);
        }
        if (toScreen == null) {
            ScreenUtil.$$$reportNull$$$0(25);
        }
        ScreenUtil.checkScreensNonEmpty(fromScreen, toScreen);
        double kw = toScreen.getWidth() / fromScreen.getWidth();
        double kh = toScreen.getHeight() / fromScreen.getHeight();
        bounds.setRect((double)toScreen.x + (double)(bounds.x - fromScreen.x) * kw, (double)toScreen.y + (double)(bounds.y - fromScreen.y) * kh, (double)bounds.width * kw, (double)bounds.height * kh);
    }

    private static void checkScreensNonEmpty(@NotNull Rectangle fromScreen, @NotNull Rectangle toScreen) {
        if (fromScreen == null) {
            ScreenUtil.$$$reportNull$$$0(26);
        }
        if (toScreen == null) {
            ScreenUtil.$$$reportNull$$$0(27);
        }
        if (fromScreen.isEmpty()) {
            throw new IllegalArgumentException("Can't move from an empty screen: " + String.valueOf(fromScreen));
        }
        if (toScreen.isEmpty()) {
            throw new IllegalArgumentException("Can't move to an empty screen: " + String.valueOf(toScreen));
        }
    }

    public static void moveRectangleToFitTheScreen(@NotNull Rectangle aRectangle) {
        if (aRectangle == null) {
            ScreenUtil.$$$reportNull$$$0(28);
        }
        if (StartupUiUtil.isWaylandToolkit()) {
            return;
        }
        int screenX = aRectangle.x + aRectangle.width / 2;
        int screenY = aRectangle.y + aRectangle.height / 2;
        Rectangle screen = ScreenUtil.getScreenRectangle(screenX, screenY);
        ScreenUtil.moveToFit(aRectangle, screen, null);
    }

    public static void moveToFit(@NotNull Rectangle rectangle, @NotNull Rectangle container, @Nullable Insets padding) {
        if (rectangle == null) {
            ScreenUtil.$$$reportNull$$$0(29);
        }
        if (container == null) {
            ScreenUtil.$$$reportNull$$$0(30);
        }
        ScreenUtil.moveToFit(rectangle, container, padding, false);
    }

    public static void moveToFit(@NotNull Rectangle rectangle, @NotNull Rectangle container, @Nullable Insets padding, boolean crop) {
        if (rectangle == null) {
            ScreenUtil.$$$reportNull$$$0(31);
        }
        if (container == null) {
            ScreenUtil.$$$reportNull$$$0(32);
        }
        Rectangle move = new Rectangle(rectangle);
        JBInsets.addTo(move, padding);
        if (move.getMaxX() > container.getMaxX()) {
            move.x = (int)container.getMaxX() - move.width;
        }
        if (move.getMinX() < container.getMinX()) {
            move.x = (int)container.getMinX();
        }
        if (move.getMaxX() > container.getMaxX() && crop) {
            move.width = (int)container.getMaxX() - move.x;
        }
        if (move.getMaxY() > container.getMaxY()) {
            move.y = (int)container.getMaxY() - move.height;
        }
        if (move.getMinY() < container.getMinY()) {
            move.y = (int)container.getMinY();
        }
        if (move.getMaxY() > container.getMaxY() && crop) {
            move.height = (int)container.getMaxY() - move.y;
        }
        JBInsets.removeFrom(move, padding);
        rectangle.setBounds(move);
    }

    public static void fitToScreenVertical(@NotNull Rectangle rectangle, int top, int bottom, boolean rightAligned) {
        if (rectangle == null) {
            ScreenUtil.$$$reportNull$$$0(33);
        }
        if (StartupUiUtil.isWaylandToolkit()) {
            return;
        }
        Rectangle screen = ScreenUtil.getScreenRectangle(rectangle.x, rectangle.y);
        if (rectangle.width > screen.width) {
            rectangle.width = screen.width;
        }
        if (rightAligned) {
            rectangle.x -= rectangle.width;
        }
        if (rectangle.x < screen.x) {
            rectangle.x = screen.x;
        } else {
            int max = screen.x + screen.width;
            if (rectangle.x > max) {
                rectangle.x = max - rectangle.width;
            }
        }
        int above = rectangle.y - screen.y - top;
        int below = screen.height - above - top - bottom;
        if (below > rectangle.height) {
            rectangle.y += bottom;
        } else if (above > rectangle.height) {
            rectangle.y -= rectangle.height + top;
        } else if (below > above) {
            rectangle.y += bottom;
            rectangle.height = below;
        } else {
            rectangle.y -= rectangle.height + top;
            rectangle.height = above;
        }
    }

    public static void fitToScreen(@NotNull Rectangle r) {
        int yOverdraft;
        if (r == null) {
            ScreenUtil.$$$reportNull$$$0(34);
        }
        if (StartupUiUtil.isWaylandToolkit()) {
            return;
        }
        Rectangle screen = ScreenUtil.getScreenRectangle(r.x, r.y);
        int xOverdraft = r.x + r.width - screen.x - screen.width;
        if (xOverdraft > 0) {
            int shift = Math.min(xOverdraft, r.x - screen.x);
            r.x -= shift;
            if ((xOverdraft -= shift) > 0) {
                r.width -= xOverdraft;
            }
        }
        if ((yOverdraft = r.y + r.height - screen.y - screen.height) > 0) {
            int shift = Math.min(yOverdraft, r.y - screen.y);
            r.y -= shift;
            if ((yOverdraft -= shift) > 0) {
                r.height -= yOverdraft;
            }
        }
    }

    @NotNull
    public static Point findNearestPointOnBorder(@NotNull Rectangle rect, @NotNull Point p) {
        Point[] variants;
        if (rect == null) {
            ScreenUtil.$$$reportNull$$$0(35);
        }
        if (p == null) {
            ScreenUtil.$$$reportNull$$$0(36);
        }
        int x0 = rect.x;
        int y0 = rect.y;
        int x1 = x0 + rect.width;
        int y1 = y0 + rect.height;
        double distance = -1.0;
        Point best = null;
        for (Point variant : variants = new Point[]{new Point(p.x, y0), new Point(p.x, y1), new Point(x0, p.y), new Point(x1, p.y)}) {
            double d = variant.distance(p.x, p.y);
            if (best != null && !(distance > d)) continue;
            best = variant;
            distance = d;
        }
        Point point = best;
        if (point == null) {
            ScreenUtil.$$$reportNull$$$0(37);
        }
        return point;
    }

    public static void cropRectangleToFitTheScreen(@NotNull Rectangle rect) {
        if (rect == null) {
            ScreenUtil.$$$reportNull$$$0(38);
        }
        if (StartupUiUtil.isWaylandToolkit()) {
            return;
        }
        int screenX = rect.x;
        int screenY = rect.y;
        Rectangle screen = ScreenUtil.getScreenRectangle(screenX, screenY);
        if (rect.getMaxX() > screen.getMaxX()) {
            rect.width = (int)screen.getMaxX() - rect.x;
        }
        if (rect.getMinX() < screen.getMinX()) {
            rect.x = (int)screen.getMinX();
        }
        if (rect.getMaxY() > screen.getMaxY()) {
            rect.height = (int)screen.getMaxY() - rect.y;
        }
        if (rect.getMinY() < screen.getMinY()) {
            rect.y = (int)screen.getMinY();
        }
    }

    public static boolean isMovementTowards(@Nullable Point prevLocation, @NotNull Point location, @Nullable Rectangle bounds) {
        if (location == null) {
            ScreenUtil.$$$reportNull$$$0(39);
        }
        if (bounds == null) {
            return false;
        }
        if (prevLocation == null || prevLocation.equals(location)) {
            return true;
        }
        if (bounds.contains(location)) {
            return true;
        }
        int dx = prevLocation.x - location.x;
        int dy = prevLocation.y - location.y;
        if (dx > 0 && bounds.x >= prevLocation.x) {
            return false;
        }
        if (dx < 0 && bounds.x + bounds.width <= prevLocation.x) {
            return false;
        }
        if (dy < 0 && bounds.y + bounds.height <= prevLocation.y) {
            return false;
        }
        if (dy > 0 && bounds.y >= prevLocation.y) {
            return false;
        }
        if (dx == 0) {
            return location.x >= bounds.x && location.x < bounds.x + bounds.width && dy > 0 ^ bounds.y > location.y;
        }
        if (dy == 0) {
            return location.y >= bounds.y && location.y < bounds.y + bounds.height && dx > 0 ^ bounds.x > location.x;
        }
        float a = (float)dy / (float)dx;
        float b = (float)location.y - a * (float)location.x;
        float crossY = a * (float)bounds.x + b;
        if (crossY >= (float)bounds.y && crossY < (float)(bounds.y + bounds.height)) {
            return true;
        }
        crossY = a * (float)(bounds.x + bounds.width) + b;
        if (crossY >= (float)bounds.y && crossY < (float)(bounds.y + bounds.height)) {
            return true;
        }
        float crossX = ((float)bounds.y - b) / a;
        if (crossX >= (float)bounds.x && crossX < (float)(bounds.x + bounds.width)) {
            return true;
        }
        crossX = ((float)(bounds.y + bounds.height) - b) / a;
        return crossX >= (float)bounds.x && crossX < (float)(bounds.x + bounds.width);
    }

    public static boolean intersectsVisibleScreen(@NotNull Window window) {
        if (window == null) {
            ScreenUtil.$$$reportNull$$$0(40);
        }
        if (StartupUiUtil.isWaylandToolkit()) {
            return true;
        }
        GraphicsConfiguration configuration = window.getGraphicsConfiguration();
        if (Objects.equals(configuration.getDevice().getIDstring(), "DummyHeadless")) {
            return true;
        }
        return configuration.getBounds().intersects(window.getBounds());
    }

    @ApiStatus.Internal
    @NotNull
    public static @NotNull List<@NotNull String> loggableMonitorConfiguration(@Nullable JFrame ideFrame) {
        ArrayList<String> result = new ArrayList<String>();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : ge.getScreenDevices()) {
            DisplayMode displayMode = device.getDisplayMode();
            GraphicsConfiguration gc = device.getDefaultConfiguration();
            float scale = JBUIScale.sysScale(gc);
            Rectangle bounds = ScreenUtil.getScreenRectangle(gc);
            result.add(String.format("%s (%dx%d scaled at %.02f with insets %s)%s%s", bounds, displayMode.getWidth(), displayMode.getHeight(), Float.valueOf(scale), ScreenUtil.getScreenInsets(gc), device == ge.getDefaultScreenDevice() ? ", default" : "", ideFrame != null && device == ideFrame.getGraphicsConfiguration().getDevice() ? ", IDE frame" : ""));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            ScreenUtil.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 8, 10, 11, 14, 15, 37, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 6: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ScreenUtil";
                break;
            }
            case 4: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gc";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 18: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromScreen";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toScreen";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aRectangle";
                break;
            }
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ScreenUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllScreenBounds";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllScreensShape";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "applyInsets";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenInsets";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInsets";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenRectangle";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "findNearestPointOnBorder";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "loggableMonitorConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 37: 
            case 41: {
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getScreenRectangle";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getScreenDevice";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyInsets";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getScreenInsets";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "distance";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "moveAndScale";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkScreensNonEmpty";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "moveRectangleToFitTheScreen";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "moveToFit";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fitToScreenVertical";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "fitToScreen";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findNearestPointOnBorder";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "cropRectangleToFitTheScreen";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isMovementTowards";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "intersectsVisibleScreen";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 8, 10, 11, 14, 15, 37, 41 -> new IllegalStateException(string);
        };
    }
}

