/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.github.benmanes.caffeine.cache.Cache;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.CachedImageIconKt;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageDataByPathLoader;
import java.lang.invoke.MethodHandles;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001aT\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\b\u0001\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\"\u0010\u0006\u001a\u001e\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00050\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00072\u0012\b\u0002\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u000bH\u0007\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\"\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"findIconByPath", "Ljavax/swing/Icon;", "path", "", "classLoader", "Ljava/lang/ClassLoader;", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lkotlin/Pair;", "Lcom/intellij/ui/icons/CachedImageIcon;", "toolTip", "Ljava/util/function/Supplier;", "normalizePath", "patchedPath", "LOOKUP", "Ljava/lang/invoke/MethodHandles$Lookup;", "kotlin.jvm.PlatformType", "isReflectivePath", "", "getReflectiveIcon", "getClassNameByIconPath", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nImageDataByPathLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageDataByPathLoader.kt\ncom/intellij/ui/icons/ImageDataByPathLoaderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,184:1\n13#2:185\n*S KotlinDebug\n*F\n+ 1 ImageDataByPathLoader.kt\ncom/intellij/ui/icons/ImageDataByPathLoaderKt\n*L\n155#1:185\n*E\n"})
public final class ImageDataByPathLoaderKt {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    @ApiStatus.Internal
    @Nullable
    public static final Icon findIconByPath(@NonNls @NotNull String path, @NotNull ClassLoader classLoader, @Nullable Cache<Pair<String, ClassLoader>, CachedImageIcon> cache, @Nullable Supplier<String> toolTip) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        long startTime = StartUpMeasurer.getCurrentTimeIfEnabled();
        if (ImageDataByPathLoaderKt.isReflectivePath(path)) {
            v0 = ImageDataByPathLoaderKt.getReflectiveIcon(path, classLoader);
        } else {
            Object object;
            Object effectivePath;
            String originalPath = ImageDataByPathLoaderKt.normalizePath(path);
            Pair<String, ClassLoader> patched = CachedImageIconKt.patchIconPath(originalPath, classLoader);
            Object object2 = patched;
            if (object2 == null || (object2 = (String)object2.getFirst()) == null) {
                object2 = effectivePath = originalPath;
            }
            if ((object = patched) == null || (object = (ClassLoader)object.getSecond()) == null) {
                object = classLoader;
            }
            Object effectiveClassLoader = object;
            v0 = ImageDataByPathLoaderKt.isReflectivePath(effectivePath) ? ImageDataByPathLoaderKt.getReflectiveIcon(effectivePath, effectiveClassLoader) : (icon = cache == null ? (Icon)ImageDataByPathLoader.Companion.createIcon$intellij_platform_util_ui(originalPath, (ClassLoader)effectiveClassLoader, (Pair<String, ? extends ClassLoader>)patched, (String)effectivePath, (ClassLoader)effectiveClassLoader, toolTip) : (Icon)cache.get((Object)new Pair((Object)originalPath, effectiveClassLoader), arg_0 -> ImageDataByPathLoaderKt.findIconByPath$lambda$1(arg_0 -> ImageDataByPathLoaderKt.findIconByPath$lambda$0(patched, effectivePath, effectiveClassLoader, toolTip, arg_0), arg_0)));
        }
        if (startTime != -1L) {
            IconLoadMeasurer.findIcon.end(startTime);
        }
        return icon;
    }

    public static /* synthetic */ Icon findIconByPath$default(String string, ClassLoader classLoader, Cache cache, Supplier supplier, int n, Object object) {
        if ((n & 8) != 0) {
            supplier = null;
        }
        return ImageDataByPathLoaderKt.findIconByPath(string, classLoader, (Cache<Pair<String, ClassLoader>, CachedImageIcon>)cache, supplier);
    }

    @NotNull
    public static final String normalizePath(@NotNull String patchedPath) {
        Intrinsics.checkNotNullParameter((Object)patchedPath, (String)"patchedPath");
        char[] cArray = new char[]{'/'};
        return StringsKt.trimStart((String)patchedPath, (char[])cArray);
    }

    @ApiStatus.Internal
    public static final boolean isReflectivePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return !StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)path, (CharSequence)"Icons.", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)".svg", (boolean)false, (int)2, null);
    }

    @ApiStatus.Internal
    @Nullable
    public static final Icon getReflectiveIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        try {
            String string = path.substring(StringsKt.lastIndexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String fieldName = string;
            String className = ImageDataByPathLoaderKt.getClassNameByIconPath(path);
            Class<?> aClass = classLoader.loadClass(className);
            return LOOKUP.findStaticGetter(aClass, fieldName, Icon.class).invoke();
        }
        catch (Throwable e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(CachedImageIcon.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot get reflective icon (path=" + path + ")", e);
            return null;
        }
    }

    @NotNull
    public static final String getClassNameByIconPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int dotIndex = StringsKt.lastIndexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null);
        StringBuilder builder = new StringBuilder(path.length() + 20);
        builder.append(path, 0, dotIndex);
        int separatorIndex = -1;
        while ((dotIndex = StringsKt.lastIndexOf$default((CharSequence)path, (char)'.', (int)(dotIndex - 1), (boolean)false, (int)4, null)) != -1 && !Character.isLowerCase(path.charAt(dotIndex + 1))) {
            if (separatorIndex != -1) {
                builder.setCharAt(separatorIndex, '$');
            }
            separatorIndex = dotIndex;
        }
        if (!Character.isLowerCase(builder.charAt(0))) {
            if (separatorIndex != -1) {
                builder.setCharAt(separatorIndex, '$');
            }
            builder.insert(0, StringsKt.startsWith$default((String)path, (String)"AllIcons.", (boolean)false, (int)2, null) ? "com.intellij.icons." : "icons.");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final CachedImageIcon findIconByPath$lambda$0(Pair $patched, String $effectivePath, ClassLoader $effectiveClassLoader, Supplier $toolTip, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = (String)it.getFirst();
        Object object = it.getSecond();
        Intrinsics.checkNotNull((Object)object);
        return ImageDataByPathLoader.Companion.createIcon$intellij_platform_util_ui(string, (ClassLoader)object, (Pair<String, ? extends ClassLoader>)$patched, $effectivePath, $effectiveClassLoader, $toolTip);
    }

    private static final CachedImageIcon findIconByPath$lambda$1(Function1 $tmp0, Object p0) {
        return (CachedImageIcon)$tmp0.invoke(p0);
    }
}

