/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.UtilUiBundle;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ThreeStateCheckBox
extends JCheckBox {
    public static final String THREE_STATE_CHECKBOX_STATE = "ThreeStateCheckbox.state";
    private State myState;
    private boolean myThirdStateEnabled = true;

    public ThreeStateCheckBox() {
        this(null, null, State.DONT_CARE);
    }

    public ThreeStateCheckBox(State initial) {
        this(null, null, initial);
    }

    public ThreeStateCheckBox(@Nls String text) {
        this(text, null, State.DONT_CARE);
    }

    public ThreeStateCheckBox(@Nls String text, State initial) {
        this(text, null, initial);
    }

    public ThreeStateCheckBox(@Nls String text, Icon icon) {
        this(text, icon, State.DONT_CARE);
    }

    public ThreeStateCheckBox(@Nls String text, Icon icon, State initial) {
        super(text, icon);
        this.setModel(new JToggleButton.ToggleButtonModel(){

            @Override
            public void setSelected(boolean selected) {
                ThreeStateCheckBox.this.setState(ThreeStateCheckBox.this.nextState());
                this.fireStateChanged();
                this.fireItemStateChanged(new ItemEvent(this, 701, this, 1));
            }

            @Override
            public boolean isSelected() {
                return ThreeStateCheckBox.this.myState == State.SELECTED;
            }
        });
        this.setState(initial);
    }

    @NotNull
    protected State nextState() {
        return ThreeStateCheckBox.nextState(this.myState, this.myThirdStateEnabled);
    }

    @NotNull
    public static State nextState(@NotNull State state, boolean thirdStateEnabled) {
        if (state == null) {
            ThreeStateCheckBox.$$$reportNull$$$0(0);
        }
        State state2 = switch (state.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> State.NOT_SELECTED;
            case 1 -> {
                if (thirdStateEnabled) {
                    yield State.DONT_CARE;
                }
                yield State.SELECTED;
            }
            case 2 -> State.SELECTED;
        };
        if (state2 == null) {
            ThreeStateCheckBox.$$$reportNull$$$0(1);
        }
        return state2;
    }

    public boolean isThirdStateEnabled() {
        return this.myThirdStateEnabled;
    }

    public void setThirdStateEnabled(boolean thirdStateEnabled) {
        this.myThirdStateEnabled = thirdStateEnabled;
    }

    @Override
    public void setSelected(boolean b) {
        this.setState(b ? State.SELECTED : State.NOT_SELECTED);
    }

    public void setState(State state) {
        State oldState = this.myState;
        this.myState = state;
        String value = state == State.DONT_CARE ? "indeterminate" : null;
        this.putClientProperty("JButton.selectedState", value);
        this.firePropertyChange(THREE_STATE_CHECKBOX_STATE, (Object)oldState, (Object)state);
        this.repaint();
    }

    public State getState() {
        return this.myState;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            return;
        }
        if (this.getState() == State.DONT_CARE) {
            Icon icon = this.getIcon();
            if (icon == null) {
                icon = UIManager.getIcon("CheckBox.icon");
            }
            if (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
                icon = JBUIScale.scaleIcon(EmptyIcon.create(20, 18));
            }
            if (icon != null) {
                Insets i = this.getInsets();
                Rectangle r = this.getBounds();
                Rectangle r1 = new Rectangle();
                r1.x = i.left;
                r1.y = i.top;
                r1.width = r.width - (i.right + r1.x);
                r1.height = r.height - (i.bottom + r1.y);
                Rectangle r2 = new Rectangle();
                Rectangle r3 = new Rectangle();
                String text = this.getText();
                SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), text, icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), r1, r2, r3, text == null ? 0 : this.getIconTextGap());
                g.setColor(UIUtil.getTreeForeground());
                int height = r2.height / 10;
                int width = r2.width / 3;
                g.fillRect(r2.x + r2.width / 2 - width / 2, r2.y + r2.height / 2 - height / 2, width, height);
            }
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleThreeStateCheckBox();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/ThreeStateCheckBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/ThreeStateCheckBox";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "nextState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nextState";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum State {
        SELECTED,
        NOT_SELECTED,
        DONT_CARE;

    }

    protected final class AccessibleThreeStateCheckBox
    extends JCheckBox.AccessibleJCheckBox {
        protected AccessibleThreeStateCheckBox() {
            super(ThreeStateCheckBox.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            if (ThreeStateCheckBox.this.myThirdStateEnabled) {
                return AccessibleRole.TOGGLE_BUTTON;
            }
            return super.getAccessibleRole();
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            if (ThreeStateCheckBox.this.myThirdStateEnabled) {
                AccessibleStateSet set = super.getAccessibleStateSet();
                set.remove(AccessibleState.CHECKED);
                return set;
            }
            return super.getAccessibleStateSet();
        }

        @Override
        public String getAccessibleName() {
            if (ThreeStateCheckBox.this.myThirdStateEnabled) {
                return this.addStateDescription(super.getAccessibleName());
            }
            return super.getAccessibleName();
        }

        @Nls
        private String addStateDescription(@Nls String name) {
            String key = switch (ThreeStateCheckBox.this.getState().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "accessible.checkbox.name.checked";
                case 1 -> "accessible.checkbox.name.not.checked";
                case 2 -> "accessible.checkbox.name.partially.checked";
            };
            return AccessibleContextUtil.combineAccessibleStrings(name, UtilUiBundle.message(key, new Object[0]));
        }
    }
}

