/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.IconLoaderKt;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CachedImageIconKt;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.icons.IconReplacer;
import com.intellij.ui.icons.IconUtilKt;
import java.awt.Component;
import java.awt.Graphics;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\tH\u0016J*\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\fH\u0016J\b\u0010\u001a\u001a\u00020\fH\u0016J\u0006\u0010\u001b\u001a\u00020\u0005J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/util/LazyIcon;", "Lcom/intellij/ui/icons/CopyableIcon;", "Lcom/intellij/ui/RetrievableIcon;", "producer", "Ljava/util/function/Supplier;", "Ljavax/swing/Icon;", "<init>", "(Ljava/util/function/Supplier;)V", "wasComputed", "", "icon", "transformModCount", "", "isComplex", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "replaceBy", "replacer", "Lcom/intellij/ui/icons/IconReplacer;", "getIconWidth", "getIconHeight", "getOrComputeIcon", "retrieveIcon", "copy", "intellij.platform.util.ui"})
public final class LazyIcon
implements CopyableIcon,
RetrievableIcon {
    @NotNull
    private final Supplier<? extends Icon> producer;
    private boolean wasComputed;
    @Nullable
    private volatile Icon icon;
    private int transformModCount;

    public LazyIcon(@NotNull Supplier<? extends Icon> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        this.producer = producer;
        this.transformModCount = CachedImageIconKt.pathTransformGlobalModCount.get();
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.getOrComputeIcon().paintIcon(c, g, x, y);
    }

    @NotNull
    public Icon replaceBy(@NotNull IconReplacer replacer) {
        Intrinsics.checkNotNullParameter((Object)replacer, (String)"replacer");
        return new LazyIcon(() -> LazyIcon.replaceBy$lambda$0(replacer, this));
    }

    @Override
    public int getIconWidth() {
        return this.getOrComputeIcon().getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getOrComputeIcon().getIconHeight();
    }

    @NotNull
    public final synchronized Icon getOrComputeIcon() {
        Icon icon;
        Icon icon2 = this.icon;
        int newTransformModCount = CachedImageIconKt.pathTransformGlobalModCount.get();
        if (icon2 != null && this.wasComputed && this.transformModCount == newTransformModCount) {
            return icon2;
        }
        this.transformModCount = newTransformModCount;
        this.wasComputed = true;
        try {
            icon = this.producer.get();
            Intrinsics.checkNotNull((Object)icon);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            IconLoaderKt.access$getLOG().error("Cannot compute icon", e);
            icon = IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Stub);
        }
        this.icon = icon2 = icon;
        return icon2;
    }

    @Override
    @NotNull
    public Icon retrieveIcon() {
        return this.getOrComputeIcon();
    }

    @Override
    @NotNull
    public Icon copy() {
        return IconUtilKt.copyIcon(this.getOrComputeIcon(), null, false);
    }

    private static final Icon replaceBy$lambda$0(IconReplacer $replacer, LazyIcon this$0) {
        return $replacer.replaceIcon(this$0.producer.get());
    }
}

