/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.reference.SoftReference;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.lang.ref.WeakReference;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFocusWatcher
implements ContainerListener,
FocusListener {
    private WeakReference<Component> topComponent;

    public Component getTopComponent() {
        return (Component)SoftReference.dereference(this.topComponent);
    }

    @Override
    public final void componentAdded(ContainerEvent e) {
        Component component = e.getChild();
        if (component != null) {
            this.installImpl(component);
        }
    }

    @Override
    public final void componentRemoved(ContainerEvent e) {
        Component removedChild = e.getChild();
        this.deinstall(removedChild, e);
    }

    public final void deinstall(Component component) {
        this.deinstall(component, null);
    }

    private void deinstall(Component component, @Nullable AWTEvent cause) {
        if (component == null) {
            return;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                this.deinstall(container.getComponent(i));
            }
            container.removeContainerListener(this);
        }
        component.removeFocusListener(this);
        this.componentUnregistered(component, cause);
    }

    public final void install(@NotNull Component component) {
        if (component == null) {
            BaseFocusWatcher.$$$reportNull$$$0(0);
        }
        this.topComponent = new WeakReference<Component>(component);
        this.installImpl(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installImpl(@NotNull Component component) {
        if (component == null) {
            BaseFocusWatcher.$$$reportNull$$$0(1);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            Object object = container.getTreeLock();
            synchronized (object) {
                int componentCount = container.getComponentCount();
                for (int i = 0; i < componentCount; ++i) {
                    Component child = container.getComponent(i);
                    if (child == null) continue;
                    this.installImpl(child);
                }
                container.addContainerListener(this);
            }
        }
        if (component instanceof JMenuItem || component instanceof JMenuBar) {
            return;
        }
        component.addFocusListener(this);
    }

    protected void componentUnregistered(Component component, @Nullable AWTEvent cause) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "component";
        objectArray2[1] = "com/intellij/openapi/wm/BaseFocusWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "installImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

