/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;

public final class SmartExpander {
    private static boolean ourRecursiveCollapseEnabled = true;

    @ApiStatus.Internal
    public static void setRecursiveCollapseEnabled(boolean enabled) {
        ourRecursiveCollapseEnabled = enabled;
    }

    public static void installOn(final JTree tree) {
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
                if (!ourRecursiveCollapseEnabled) {
                    return;
                }
                TreePath path = event.getPath();
                TreeModel model = tree.getModel();
                Object lastPathComponent = path.getLastPathComponent();
                int childCount = model.getChildCount(lastPathComponent);
                for (int i = 0; i < childCount; ++i) {
                    Object child = model.getChild(lastPathComponent, i);
                    TreePath childPath = path.pathByAddingChild(child);
                    if (!tree.isExpanded(childPath)) continue;
                    tree.collapsePath(childPath);
                }
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
            }
        });
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Object lastPathComponent;
                TreePath path = event.getPath();
                TreeModel model = tree.getModel();
                if (model.getChildCount(lastPathComponent = path.getLastPathComponent()) == 1) {
                    TreePath firstChildPath = path.pathByAddingChild(model.getChild(lastPathComponent, 0));
                    tree.expandPath(firstChildPath);
                }
            }
        });
    }
}

