/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.IconManager;
import com.intellij.ui.NewUiValue;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageDataByFilePathLoader;
import com.intellij.ui.icons.ImageDataByPathLoaderKt;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.ImageDataLoaderDescriptor;
import com.intellij.ui.icons.LoadIconParameters;
import com.intellij.ui.icons.PatchedRasterizedImageDataLoader;
import com.intellij.ui.icons.RasterizedImageDataLoaderDescriptor;
import com.intellij.ui.icons.RasterizedImageDataLoaderKt;
import com.intellij.ui.scale.ScaleContext;
import java.awt.Image;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0007H\u0016J\b\u0010&\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lcom/intellij/ui/icons/RasterizedImageDataLoader;", "Lcom/intellij/ui/icons/ImageDataLoader;", "path", "", "expUIPath", "classLoaderRef", "Ljava/lang/ref/WeakReference;", "Ljava/lang/ClassLoader;", "cacheKey", "", "flags", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/ref/WeakReference;II)V", "getPath", "()Ljava/lang/String;", "getExpUIPath", "getFlags", "()I", "getCoords", "Lkotlin/Pair;", "serializeToByteArray", "Lcom/intellij/ui/icons/ImageDataLoaderDescriptor;", "loadImage", "Ljava/awt/Image;", "parameters", "Lcom/intellij/ui/icons/LoadIconParameters;", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "patch", "transform", "Lcom/intellij/ui/icons/IconTransform;", "isMyClassLoader", "", "classLoader", "toString", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nRasterizedImageDataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RasterizedImageDataLoader.kt\ncom/intellij/ui/icons/RasterizedImageDataLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,309:1\n1#2:310\n23#3:311\n*S KotlinDebug\n*F\n+ 1 RasterizedImageDataLoader.kt\ncom/intellij/ui/icons/RasterizedImageDataLoader\n*L\n93#1:311\n*E\n"})
final class RasterizedImageDataLoader
implements ImageDataLoader {
    @NotNull
    private final String path;
    @Nullable
    private final String expUIPath;
    @NotNull
    private final WeakReference<ClassLoader> classLoaderRef;
    private final int cacheKey;
    private final int flags;

    public RasterizedImageDataLoader(@NotNull String path, @Nullable String expUIPath, @NotNull WeakReference<ClassLoader> classLoaderRef, int cacheKey, int flags) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(classLoaderRef, (String)"classLoaderRef");
        this.path = path;
        this.expUIPath = expUIPath;
        this.classLoaderRef = classLoaderRef;
        this.cacheKey = cacheKey;
        this.flags = flags;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public String getExpUIPath() {
        return this.expUIPath;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    @Nullable
    public Pair<String, ClassLoader> getCoords() {
        Pair pair;
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        if (classLoader != null) {
            ClassLoader it = classLoader;
            boolean bl = false;
            pair = TuplesKt.to((Object)this.getPath(), (Object)it);
        } else {
            pair = null;
        }
        return pair;
    }

    @Override
    @NotNull
    public ImageDataLoaderDescriptor serializeToByteArray() {
        Object t = this.classLoaderRef.get();
        Intrinsics.checkNotNull(t);
        ClassLoader classLoader = (ClassLoader)t;
        Pair pluginInfo = IconManager.Companion.getInstance().getPluginAndModuleId(classLoader);
        String string = this.getPath();
        String string2 = this.getExpUIPath();
        String string3 = (String)pluginInfo.getFirst();
        String string4 = (String)pluginInfo.getSecond();
        int n = this.getFlags();
        int n2 = this.cacheKey;
        return new RasterizedImageDataLoaderDescriptor(string, string2, string3, string4, n2, n);
    }

    @Override
    @Nullable
    public Image loadImage(@NotNull LoadIconParameters parameters, @NotNull ScaleContext scaleContext) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        if (classLoader == null) {
            return null;
        }
        ClassLoader classLoader2 = classLoader;
        try {
            long start = StartUpMeasurer.getCurrentTimeIfEnabled();
            boolean isSvg = this.cacheKey != 0;
            Image image = RasterizedImageDataLoaderKt.access$loadRasterized(this.getPath(), scaleContext, parameters, classLoader2, isSvg, this.cacheKey, this.getFlags());
            if (start != -1L) {
                IconLoadMeasurer.loadFromResources.end(start);
                IconLoadMeasurer.INSTANCE.addLoading(isSvg, start);
            }
            return image;
        }
        catch (IOException e) {
            RasterizedImageDataLoader $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(RasterizedImageDataLoader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug((Throwable)e);
            return null;
        }
    }

    @Override
    @Nullable
    public URL getUrl() {
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        return classLoader != null ? classLoader.getResource(this.getPath()) : null;
    }

    @Override
    @Nullable
    public ImageDataLoader patch(@NotNull IconTransform transform) {
        WeakReference<ClassLoader> effectiveClassLoaderRef;
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        if (classLoader == null) {
            return null;
        }
        ClassLoader classLoader2 = classLoader;
        Pair<String, ClassLoader> patched = transform.patchPath(this.getPath(), classLoader2);
        if (patched == null) {
            if (this.getExpUIPath() != null && NewUiValue.isEnabled()) {
                return new PatchedRasterizedImageDataLoader(this.getExpUIPath(), this.classLoaderRef, this.getFlags());
            }
            return null;
        }
        if (StringsKt.startsWith$default((String)((String)patched.getFirst()), (String)"file:/", (boolean)false, (int)2, null)) {
            return new ImageDataByFilePathLoader((String)patched.getFirst());
        }
        ClassLoader classLoader3 = (ClassLoader)patched.getSecond();
        if (classLoader3 != null) {
            ClassLoader p0 = classLoader3;
            boolean bl = false;
            v2 = new WeakReference<ClassLoader>(p0);
        } else {
            v2 = effectiveClassLoaderRef = this.classLoaderRef;
        }
        if (ImageDataByPathLoaderKt.isReflectivePath((String)patched.getFirst()) && patched.getSecond() != null) {
            CachedImageIcon cachedImageIcon;
            String string = (String)patched.getFirst();
            Object object = patched.getSecond();
            Intrinsics.checkNotNull((Object)object);
            Icon icon = ImageDataByPathLoaderKt.getReflectiveIcon(string, (ClassLoader)object);
            CachedImageIcon cachedImageIcon2 = cachedImageIcon = icon instanceof CachedImageIcon ? (CachedImageIcon)icon : null;
            if (cachedImageIcon != null) {
                CachedImageIcon it = cachedImageIcon;
                boolean bl = false;
                ImageDataLoader loader = it.loader;
                if (loader instanceof RasterizedImageDataLoader) {
                    return new PatchedRasterizedImageDataLoader(((RasterizedImageDataLoader)loader).getPath(), effectiveClassLoaderRef, ((RasterizedImageDataLoader)loader).getFlags());
                }
                return loader;
            }
        }
        return new PatchedRasterizedImageDataLoader((String)patched.getFirst(), effectiveClassLoaderRef, this.getFlags());
    }

    @Override
    public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return this.classLoaderRef.get() == classLoader;
    }

    @NotNull
    public String toString() {
        return "RasterizedImageDataLoader(classLoader=" + this.classLoaderRef.get() + ", path=" + this.getPath() + ")";
    }
}

