/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scale;

import com.intellij.openapi.util.registry.Registry;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\b\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\b\u0010\r\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"DISCRETE_SCALE_RESOLUTION", "", "USER_SCALE_FACTOR_PROPERTY", "", "SYS_SCALE_ACCESS_STACK_TRACE", "Ljava/util/concurrent/atomic/AtomicReference;", "", "discreteScale", "scale", "getScreenScale", "getTransformScaleX", "transform", "Ljava/awt/geom/AffineTransform;", "computeSystemScaleFactorForJreHiDPI", "intellij.platform.util.ui"})
public final class JBUIScaleKt {
    private static final float DISCRETE_SCALE_RESOLUTION = 0.25f;
    @NotNull
    private static final String USER_SCALE_FACTOR_PROPERTY = "JBUIScale.userScaleFactor";
    @NotNull
    private static final AtomicReference<Throwable> SYS_SCALE_ACCESS_STACK_TRACE = new AtomicReference();

    private static final float discreteScale(float scale) {
        float it = scale / 0.25f;
        boolean bl = false;
        return (float)(Registry.Companion.is("ide.scale.discrete.take.floor", false) ? (int)it : MathKt.roundToInt((float)it)) * 0.25f;
    }

    private static final float getScreenScale() {
        int n;
        try {
            n = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException ignored) {
            n = 96;
        }
        int dpi = n;
        return JBUIScaleKt.discreteScale((float)dpi / 96.0f);
    }

    public static final float getTransformScaleX(@NotNull AffineTransform transform) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        Point2D.Double p = new Point2D.Double(1.0, 0.0);
        transform.deltaTransform(p, p);
        return (float)p.distance(0.0, 0.0);
    }

    private static final float computeSystemScaleFactorForJreHiDPI() {
        GraphicsDevice gd;
        GraphicsDevice graphicsDevice;
        try {
            graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        }
        catch (HeadlessException ignore) {
            graphicsDevice = null;
        }
        GraphicsDevice graphicsDevice2 = gd = graphicsDevice;
        GraphicsConfiguration gc = graphicsDevice2 != null ? graphicsDevice2.getDefaultConfiguration() : null;
        return gc == null || gc.getDevice().getType() == 1 ? 1.0f : (float)gc.getDefaultTransform().getScaleX();
    }

    public static final /* synthetic */ AtomicReference access$getSYS_SCALE_ACCESS_STACK_TRACE$p() {
        return SYS_SCALE_ACCESS_STACK_TRACE;
    }

    public static final /* synthetic */ float access$computeSystemScaleFactorForJreHiDPI() {
        return JBUIScaleKt.computeSystemScaleFactorForJreHiDPI();
    }

    public static final /* synthetic */ float access$discreteScale(float scale) {
        return JBUIScaleKt.discreteScale(scale);
    }

    public static final /* synthetic */ float access$getScreenScale() {
        return JBUIScaleKt.getScreenScale();
    }
}

