/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class JBValue {
    protected JBValue() {
    }

    public int get() {
        return PaintUtil.RoundingMode.ROUND.round(JBUIScale.scale(this.getUnscaled()));
    }

    public float getFloat() {
        return JBUIScale.scale(this.getUnscaled());
    }

    public int get(@NotNull PaintUtil.RoundingMode rm) {
        if (rm == null) {
            JBValue.$$$reportNull$$$0(0);
        }
        return rm.round(JBUIScale.scale(this.getUnscaled()));
    }

    public abstract float getUnscaled();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rm", "com/intellij/util/ui/JBValue", "get"));
    }

    public static final class JBValueGroup {
        private final List<CachedFloat> group = new LinkedList<CachedFloat>();
        private final PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.updateCachedValues();
            }
        };

        public void updateCachedValues() {
            for (CachedFloat value : this.group) {
                value.scaleAndCache();
            }
        }

        public JBValueGroup() {
            JBUIScale.addUserScaleChangeListener(this.listener);
        }

        public JBValue value(float value) {
            CachedFloat v = new CachedFloat(() -> java.lang.Float.valueOf(value));
            this.group.add(v);
            return v;
        }

        public JBValue value(@NotNull Supplier<java.lang.Float> valueSupplier) {
            if (valueSupplier == null) {
                JBValueGroup.$$$reportNull$$$0(0);
            }
            CachedFloat v = new CachedFloat(valueSupplier);
            this.group.add(v);
            return v;
        }

        public void dispose() {
            JBUIScale.removeUserScaleChangeListener(this.listener);
            this.group.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueSupplier", "com/intellij/util/ui/JBValue$JBValueGroup", "value"));
        }
    }

    private static final class CachedFloat
    extends JBValue {
        @NotNull
        private final Supplier<java.lang.Float> valueSupplier;
        private float cachedScaledValue;

        private CachedFloat(@NotNull Supplier<java.lang.Float> valueSupplier) {
            if (valueSupplier == null) {
                CachedFloat.$$$reportNull$$$0(0);
            }
            this.valueSupplier = valueSupplier;
            this.scaleAndCache();
        }

        @Override
        public float getUnscaled() {
            return this.valueSupplier.get().floatValue();
        }

        @Override
        public int get() {
            return PaintUtil.RoundingMode.ROUND.round(this.cachedScaledValue);
        }

        @Override
        public float getFloat() {
            return this.cachedScaledValue;
        }

        @Override
        public int get(@NotNull PaintUtil.RoundingMode rm) {
            if (rm == null) {
                CachedFloat.$$$reportNull$$$0(1);
            }
            return rm.round(this.cachedScaledValue);
        }

        public void scaleAndCache() {
            this.cachedScaledValue = JBUIScale.scale(this.getUnscaled());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueSupplier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rm";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ui/JBValue$CachedFloat";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Float
    extends JBValue {
        @ApiStatus.Internal
        public static final JBValue EMPTY = new Float(0.0f);
        private final float value;

        public Float(float value) {
            this(value, false);
        }

        public Float(float value, boolean preScaled) {
            this.value = preScaled ? value / JBUIScale.scale(1.0f) : value;
        }

        @Override
        public float getUnscaled() {
            return this.value;
        }
    }

    public static final class UIInteger
    extends JBValue {
        @NotNull
        private final String key;
        private final int defValue;

        public UIInteger(@NotNull String key, int defValue) {
            if (key == null) {
                UIInteger.$$$reportNull$$$0(0);
            }
            this.key = key;
            this.defValue = defValue;
        }

        @Override
        public float getUnscaled() {
            return JBUI.getInt(this.key, this.defValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/ui/JBValue$UIInteger", "<init>"));
        }
    }
}

