/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.KeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextWithMnemonic {
    private static final Logger LOG = Logger.getInstance(TextWithMnemonic.class);
    public static final TextWithMnemonic EMPTY = new TextWithMnemonic("", -1, "");
    private static final Pattern MNEMONIC = Pattern.compile(" ?\\(_?[A-Z]\\)");
    @NotNull
    @Nls
    private final String text;
    private final int mnemonicIndex;
    @NotNull
    @Nls
    private final String mnemonicSuffix;

    private TextWithMnemonic(@NotNull @Nls String text, int mnemonicIndex, @NotNull @Nls String mnemonicSuffix) {
        if (text == null) {
            TextWithMnemonic.$$$reportNull$$$0(0);
        }
        if (mnemonicSuffix == null) {
            TextWithMnemonic.$$$reportNull$$$0(1);
        }
        assert (mnemonicIndex >= 0 || mnemonicSuffix.isEmpty());
        assert (mnemonicIndex >= -1 && mnemonicIndex < text.length() + mnemonicSuffix.length());
        this.text = text;
        this.mnemonicIndex = mnemonicIndex;
        this.mnemonicSuffix = mnemonicSuffix;
    }

    @NotNull
    @Nls
    public String getText() {
        String string = this.getText(false);
        if (string == null) {
            TextWithMnemonic.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getText(boolean withMnemonicSuffix) {
        String string = this.format(false, null, withMnemonicSuffix);
        if (string == null) {
            TextWithMnemonic.$$$reportNull$$$0(3);
        }
        return string;
    }

    public int getMnemonicCode() {
        char ch = this.getMnemonicChar();
        return ch == '\uffff' ? 0 : KeyEvent.getExtendedKeyCodeForChar(ch);
    }

    public char getMnemonicChar() {
        if (this.mnemonicIndex < 0) {
            return '\uffff';
        }
        int index = this.mnemonicIndex - this.text.length();
        return index < 0 ? this.text.charAt(this.mnemonicIndex) : this.mnemonicSuffix.charAt(index);
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public boolean hasMnemonic() {
        return this.mnemonicIndex >= 0;
    }

    public TextWithMnemonic dropMnemonic(boolean forceRemove) {
        if (!this.hasMnemonic()) {
            return this;
        }
        if (!forceRemove) {
            return TextWithMnemonic.fromPlainText(this.text);
        }
        Matcher matcher = MNEMONIC.matcher(this.text);
        if (matcher.find()) {
            return TextWithMnemonic.fromPlainText(matcher.replaceAll(""));
        }
        return this;
    }

    @NotNull
    public TextWithMnemonic withMnemonicIndex(int index) {
        if (index == this.mnemonicIndex) {
            TextWithMnemonic textWithMnemonic = this;
            if (textWithMnemonic == null) {
                TextWithMnemonic.$$$reportNull$$$0(4);
            }
            return textWithMnemonic;
        }
        if (index >= -1) {
            String text = this.getText();
            if (index == -1) {
                return TextWithMnemonic.fromPlainText(text);
            }
            if (index < text.length() - TextWithMnemonic.getEllipsisLength(text)) {
                return TextWithMnemonic.fromPlainTextWithIndex(text, index);
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    public TextWithMnemonic append(@NotNull @Nls String textToAppend) {
        if (textToAppend == null) {
            TextWithMnemonic.$$$reportNull$$$0(5);
        }
        return new TextWithMnemonic(this.text + textToAppend, this.mnemonicIndex < this.text.length() ? this.mnemonicIndex : this.mnemonicIndex + textToAppend.length(), this.mnemonicSuffix);
    }

    public TextWithMnemonic replaceFirst(@NotNull String target, @Nls @NotNull String replacement) {
        int index;
        if (target == null) {
            TextWithMnemonic.$$$reportNull$$$0(6);
        }
        if (replacement == null) {
            TextWithMnemonic.$$$reportNull$$$0(7);
        }
        if ((index = this.text.indexOf(target)) == -1) {
            return this;
        }
        String resultText = this.text.substring(0, index) + replacement + this.text.substring(index + target.length());
        int resultIndex = this.mnemonicIndex < index ? this.mnemonicIndex : (this.mnemonicIndex >= index + target.length() ? this.mnemonicIndex - target.length() + replacement.length() : -1);
        return new TextWithMnemonic(resultText, resultIndex, this.mnemonicSuffix);
    }

    @ApiStatus.Internal
    @Nullable
    public static TextWithMnemonic fromMnemonicText(@NotNull @Nls String text) {
        if (text == null) {
            TextWithMnemonic.$$$reportNull$$$0(8);
        }
        return TextWithMnemonic.fromMnemonicText(text, true);
    }

    @ApiStatus.Internal
    @Nullable
    public static TextWithMnemonic fromMnemonicText(@NotNull @Nls String text, boolean reportInvalidMnemonics) {
        Object errorDetails;
        int pos;
        if (text == null) {
            TextWithMnemonic.$$$reportNull$$$0(9);
        }
        if ((pos = text.indexOf(27)) < 0) {
            return null;
        }
        String str = text.substring(pos + 1);
        IllegalArgumentException error = null;
        Object object = errorDetails = reportInvalidMnemonics ? " in text: " + text : "";
        if (str.isEmpty()) {
            error = new IllegalArgumentException("unexpected mnemonic marker" + (String)errorDetails);
        }
        if (str.indexOf(27) >= 0) {
            error = new IllegalArgumentException("several mnemonic markers" + (String)errorDetails);
        }
        if (error != null) {
            if (reportInvalidMnemonics) {
                LOG.error((Throwable)error);
            } else {
                LOG.warn((Throwable)error);
            }
            return null;
        }
        return TextWithMnemonic.fromPlainTextWithIndex((String)(pos > 0 ? text.substring(0, pos) + str : str), pos);
    }

    @Contract(pure=true)
    @NotNull
    public static TextWithMnemonic fromPlainText(@NotNull @Nls String text) {
        if (text == null) {
            TextWithMnemonic.$$$reportNull$$$0(10);
        }
        return text.isEmpty() ? EMPTY : new TextWithMnemonic(text, -1, "");
    }

    @Contract(pure=true)
    @NotNull
    public static TextWithMnemonic fromPlainText(@NotNull @Nls String text, char mnemonicChar) {
        if (text == null) {
            TextWithMnemonic.$$$reportNull$$$0(11);
        }
        if (mnemonicChar == '\u0000') {
            return TextWithMnemonic.fromPlainText(text);
        }
        mnemonicChar = Character.toUpperCase(mnemonicChar);
        for (int i = 0; i < text.length(); ++i) {
            if (Character.toUpperCase(text.charAt(i)) != mnemonicChar) continue;
            return new TextWithMnemonic(text, i, "");
        }
        int ellipsisLength = TextWithMnemonic.getEllipsisLength(text);
        String suffix = "(" + mnemonicChar + ")" + text.substring(text.length() - ellipsisLength);
        text = text.substring(0, text.length() - ellipsisLength);
        return new TextWithMnemonic(text, text.length() + 1, suffix);
    }

    @NotNull
    public static TextWithMnemonic fromPlainTextWithIndex(@NotNull @Nls String text, int index) {
        int pos;
        if (text == null) {
            TextWithMnemonic.$$$reportNull$$$0(12);
        }
        if (index < 0) {
            return TextWithMnemonic.fromPlainText(text);
        }
        if (index < text.length() && (pos = text.length() - TextWithMnemonic.getEllipsisLength(text) - 3) >= 0 && index == pos + 1 && text.charAt(pos) == '(' && text.charAt(pos + 2) == ')') {
            while (pos > 0 && text.charAt(pos - 1) == ' ') {
                --pos;
            }
            return new TextWithMnemonic(text.substring(0, pos), index, text.substring(pos));
        }
        return new TextWithMnemonic(text, index, "");
    }

    @Contract(pure=true)
    @NotNull
    public static TextWithMnemonic parse(@NotNull @Nls String text) {
        TextWithMnemonic mnemonic;
        if (text == null) {
            TextWithMnemonic.$$$reportNull$$$0(13);
        }
        TextWithMnemonic textWithMnemonic = mnemonic = text.isEmpty() ? EMPTY : TextWithMnemonic.fromMnemonicText(text);
        if (mnemonic != null) {
            TextWithMnemonic textWithMnemonic2 = mnemonic;
            if (textWithMnemonic2 == null) {
                TextWithMnemonic.$$$reportNull$$$0(14);
            }
            return textWithMnemonic2;
        }
        if (text.contains("_") || text.contains("&")) {
            @Nls StringBuilder plainText = new StringBuilder();
            int mnemonicIndex = -1;
            int backShift = 0;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (mnemonicIndex == -1 && (ch == '_' || ch == '&')) {
                    if (++i >= text.length()) break;
                    ch = text.charAt(i);
                    if (ch != '_' && ch != '&') {
                        mnemonicIndex = i - 1 - backShift;
                    } else {
                        ++backShift;
                    }
                }
                plainText.append(ch);
            }
            return TextWithMnemonic.fromPlainTextWithIndex(plainText.toString(), mnemonicIndex);
        }
        return TextWithMnemonic.fromPlainText(text);
    }

    private static int getEllipsisLength(String text) {
        if (text.endsWith("...")) {
            return 3;
        }
        if (text.endsWith("\u2026")) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextWithMnemonic mnemonic = (TextWithMnemonic)o;
        return this.mnemonicIndex == mnemonic.mnemonicIndex && this.text.equals(mnemonic.text) && this.mnemonicSuffix.equals(mnemonic.mnemonicSuffix);
    }

    public int hashCode() {
        return (this.text.hashCode() * 31 + this.mnemonicIndex) * 31 + this.mnemonicSuffix.hashCode();
    }

    @Nls
    public String toString() {
        return this.format(true, Character.valueOf('_'), true);
    }

    @ApiStatus.Internal
    @NotNull
    @Nls
    public String format(boolean escapeMnemonics, @Nullable Character mnemonicPrefix, boolean withSuffix) {
        boolean completeTextIncludesMnemonics;
        Object completeText;
        if (this.mnemonicSuffix.isEmpty()) {
            completeText = this.text;
            completeTextIncludesMnemonics = this.mnemonicIndex >= 0 && this.mnemonicIndex < this.text.length();
        } else if (withSuffix) {
            completeText = this.text + this.mnemonicSuffix;
            completeTextIncludesMnemonics = this.mnemonicIndex >= 0 && this.mnemonicIndex < ((String)completeText).length();
        } else {
            int ellipsisLength = TextWithMnemonic.getEllipsisLength(this.mnemonicSuffix);
            completeText = ellipsisLength == 0 ? this.text : this.text + this.mnemonicSuffix.substring(this.mnemonicSuffix.length() - ellipsisLength);
            boolean bl = completeTextIncludesMnemonics = this.mnemonicIndex >= 0 && this.mnemonicIndex < this.text.length();
        }
        if (mnemonicPrefix != null && completeTextIncludesMnemonics) {
            String firstPart = ((String)completeText).substring(0, this.mnemonicIndex);
            String secondPart = ((String)completeText).substring(this.mnemonicIndex);
            String string = escapeMnemonics ? StringUtil.escapeMnemonics((String)firstPart) + mnemonicPrefix + secondPart : firstPart + mnemonicPrefix + secondPart;
            if (string == null) {
                TextWithMnemonic.$$$reportNull$$$0(15);
            }
            return string;
        }
        Object object = escapeMnemonics ? StringUtil.escapeMnemonics((String)completeText) : completeText;
        if (object == null) {
            TextWithMnemonic.$$$reportNull$$$0(16);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mnemonicSuffix";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/TextWithMnemonic";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToAppend";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/TextWithMnemonic";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withMnemonicIndex";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceFirst";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromMnemonicText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fromPlainText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fromPlainTextWithIndex";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

