/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.awt;

import com.intellij.ui.awt.AnchoredPoint;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativePoint {
    @NotNull
    private final Component myComponent;
    @NotNull
    private final Point myPointOnComponent;
    @NotNull
    private final Component myOriginalComponent;
    @NotNull
    private final Point myOriginalPoint;

    public RelativePoint(@NotNull MouseEvent event) {
        if (event == null) {
            RelativePoint.$$$reportNull$$$0(0);
        }
        this(event.getComponent(), event.getPoint());
    }

    public RelativePoint(@NotNull Point screenPoint) {
        if (screenPoint == null) {
            RelativePoint.$$$reportNull$$$0(1);
        }
        this(RelativePoint.getTargetWindow(), RelativePoint.calcPoint(screenPoint));
    }

    @NotNull
    private static Point calcPoint(@NotNull Point screenPoint) {
        if (screenPoint == null) {
            RelativePoint.$$$reportNull$$$0(2);
        }
        Point p = new Point(screenPoint.x, screenPoint.y);
        SwingUtilities.convertPointFromScreen(p, RelativePoint.getTargetWindow());
        Point point = p;
        if (point == null) {
            RelativePoint.$$$reportNull$$$0(3);
        }
        return point;
    }

    @NotNull
    private static Window getTargetWindow() {
        Window[] windows = Window.getWindows();
        Window targetWindow = null;
        for (Window each : windows) {
            if (!each.isActive()) continue;
            targetWindow = each;
            break;
        }
        if (targetWindow == null) {
            targetWindow = JOptionPane.getRootFrame();
        }
        Frame frame = targetWindow;
        if (frame == null) {
            RelativePoint.$$$reportNull$$$0(4);
        }
        return frame;
    }

    public RelativePoint(@NotNull Component aComponent, @NotNull Point aPointOnComponent) {
        if (aComponent == null) {
            RelativePoint.$$$reportNull$$$0(5);
        }
        if (aPointOnComponent == null) {
            RelativePoint.$$$reportNull$$$0(6);
        }
        JRootPane rootPane = SwingUtilities.getRootPane(aComponent);
        if (aComponent.isShowing() && rootPane != null) {
            this.myComponent = rootPane;
            this.myPointOnComponent = SwingUtilities.convertPoint(aComponent, aPointOnComponent, this.myComponent);
        } else {
            this.myComponent = aComponent;
            this.myPointOnComponent = aPointOnComponent;
        }
        this.myOriginalComponent = aComponent;
        this.myOriginalPoint = aPointOnComponent;
    }

    @NotNull
    public Component getComponent() {
        Component component = this.myComponent;
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(7);
        }
        return component;
    }

    public Point getPoint() {
        return this.myPointOnComponent;
    }

    @NotNull
    public Point getPoint(@Nullable Component aTargetComponent) {
        boolean window = aTargetComponent instanceof Window;
        if (aTargetComponent == null || !window && (aTargetComponent.getParent() == null || SwingUtilities.getWindowAncestor(aTargetComponent) == null)) {
            return new Point();
        }
        Point point = SwingUtilities.convertPoint(this.getComponent(), this.getPoint(), aTargetComponent);
        if (point == null) {
            RelativePoint.$$$reportNull$$$0(8);
        }
        return point;
    }

    @NotNull
    public RelativePoint getPointOn(@NotNull Component aTargetComponent) {
        if (aTargetComponent == null) {
            RelativePoint.$$$reportNull$$$0(9);
        }
        Point point = this.getPoint(aTargetComponent);
        return new RelativePoint(aTargetComponent, point);
    }

    @NotNull
    public Point getScreenPoint() {
        Point point = (Point)this.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, this.getComponent());
        Point point2 = point;
        if (point2 == null) {
            RelativePoint.$$$reportNull$$$0(10);
        }
        return point2;
    }

    @NotNull
    public MouseEvent toMouseEvent() {
        return new MouseEvent(this.myComponent, 0, 0L, 0, this.myPointOnComponent.x, this.myPointOnComponent.y, 1, false);
    }

    @NotNull
    public String toString() {
        String string = String.valueOf(this.getPoint()) + " on " + String.valueOf(this.getComponent());
        if (string == null) {
            RelativePoint.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static RelativePoint getCenterOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(12);
        }
        return new AnchoredPoint(AnchoredPoint.Anchor.CENTER, component);
    }

    @NotNull
    public static RelativePoint getSouthEastOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(13);
        }
        return new AnchoredPoint(AnchoredPoint.Anchor.BOTTOM_RIGHT, component);
    }

    @NotNull
    public static RelativePoint getSouthWestOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(14);
        }
        return new AnchoredPoint(AnchoredPoint.Anchor.BOTTOM_LEFT, component);
    }

    @NotNull
    public static RelativePoint getSouthOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(15);
        }
        return new AnchoredPoint(AnchoredPoint.Anchor.BOTTOM, component);
    }

    @NotNull
    public static RelativePoint getNorthWestOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(16);
        }
        return new AnchoredPoint(AnchoredPoint.Anchor.TOP_LEFT, component);
    }

    @NotNull
    public static RelativePoint getNorthEastOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(17);
        }
        return new AnchoredPoint(AnchoredPoint.Anchor.TOP_RIGHT, component);
    }

    @NotNull
    public static RelativePoint fromScreen(Point screenPoint) {
        Frame root = JOptionPane.getRootFrame();
        SwingUtilities.convertPointFromScreen(screenPoint, root);
        return new RelativePoint(root, screenPoint);
    }

    @NotNull
    public Component getOriginalComponent() {
        Component component = this.myOriginalComponent;
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(18);
        }
        return component;
    }

    @NotNull
    public Point getOriginalPoint() {
        Point point = this.myOriginalPoint;
        if (point == null) {
            RelativePoint.$$$reportNull$$$0(19);
        }
        return point;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8, 10, 11, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenPoint";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/awt/RelativePoint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPointOnComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aTargetComponent";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/awt/RelativePoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPoint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetWindow";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoint";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenPoint";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalComponent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcPoint";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 18: 
            case 19: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPointOn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCenterOf";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSouthEastOf";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSouthWestOf";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSouthOf";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNorthWestOf";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNorthEastOf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8, 10, 11, 18, 19 -> new IllegalStateException(string);
        };
    }
}

