/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scale;

import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ui/scale/ScaleContextCache;", "T", "", "dataProvider", "Lkotlin/Function1;", "Lcom/intellij/ui/scale/ScaleContext;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "data", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Pair;", "", "getOrProvide", "scaleContext", "(Lcom/intellij/ui/scale/ScaleContext;)Ljava/lang/Object;", "clear", "", "intellij.platform.util.ui"})
public class ScaleContextCache<T> {
    @NotNull
    private final Function1<ScaleContext, T> dataProvider;
    @NotNull
    private final AtomicReference<Pair<Double, T>> data;

    public ScaleContextCache(@NotNull Function1<? super ScaleContext, ? extends T> dataProvider) {
        Intrinsics.checkNotNullParameter(dataProvider, (String)"dataProvider");
        this.dataProvider = dataProvider;
        this.data = new AtomicReference<Object>(null);
    }

    @Nullable
    public final T getOrProvide(@NotNull ScaleContext scaleContext) {
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        Pair data = this.data.get();
        double scale = scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        if (data == null || Double.compare(scale, ((Number)data.getFirst()).doubleValue()) != 0) {
            data = TuplesKt.to((Object)scale, (Object)this.dataProvider.invoke((Object)scaleContext));
            this.data.set(data);
        }
        return (T)data.getSecond();
    }

    public final void clear() {
        this.data.set(null);
    }
}

